/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.arquillian;

import org.apache.commons.lang3.StringUtils;
import org.jboss.arquillian.drone.api.annotation.Default;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyInstance;
import org.jboss.arquillian.graphene.proxy.Interceptor;
import org.jboss.arquillian.graphene.proxy.InvocationContext;
import org.jboss.arquillian.graphene.request.RequestGuardException;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public final class PrimeGraphene
extends Graphene {
    private PrimeGraphene() {
    }

    public static void disableAnimations() {
        PrimeGraphene.executeScript("if (window.$) { $(function() { $.fx.off = true; }); }");
    }

    public static void enableAnimations() {
        PrimeGraphene.executeScript("if (window.$) { $(function() { $.fx.off = false; }); }");
    }

    public static void handleRequestGuardException(RequestGuardException e) {
        System.err.println("Expected " + e.getRequestExpected() + " request, " + e.getRequestDone() + " was done instead. Ignoring.");
    }

    public static WebDriver getWebDriver() {
        return GrapheneContext.getContextFor(Default.class).getWebDriver(new Class[0]);
    }

    public static <T> T executeScript(String script) {
        JavascriptExecutor executor = (JavascriptExecutor)PrimeGraphene.getWebDriver();
        return (T)executor.executeScript(script, new Object[0]);
    }

    public static boolean hasCssClass(WebElement element, String cssClass) {
        String classes = element.getAttribute("class");
        if (classes == null || StringUtils.isBlank((CharSequence)classes)) {
            return false;
        }
        for (String currentClass : classes.split(" ")) {
            if (!currentClass.equals(cssClass)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAjaxScript(String script) {
        if (script == null || StringUtils.isBlank((CharSequence)script)) {
            return false;
        }
        return script.contains("PrimeFaces.ab(") || script.contains("pf.ab(") || script.contains("mojarra.ab(") || script.contains("jsf.ajax.request");
    }

    public static boolean hasAjaxBehavior(WebElement element, String behavior) {
        if (!PrimeGraphene.hasBehavior(element, behavior)) {
            return false;
        }
        String id = element.getAttribute("id");
        String result = (String)PrimeGraphene.executeScript("return " + PrimeGraphene.getWidgetByIdScript(id) + ".getBehavior('" + behavior + "').toString();");
        return PrimeGraphene.isAjaxScript(result);
    }

    public static boolean hasBehavior(WebElement element, String behavior) {
        if (!PrimeGraphene.isWidget(element)) {
            return false;
        }
        String id = element.getAttribute("id");
        return (Boolean)PrimeGraphene.executeScript("return " + PrimeGraphene.getWidgetByIdScript(id) + ".hasBehavior('" + behavior + "');");
    }

    public static boolean isWidget(WebElement element) {
        String id = element.getAttribute("id");
        if (id == null || id.isEmpty()) {
            return false;
        }
        Object result = PrimeGraphene.executeScript("return " + PrimeGraphene.getWidgetByIdScript(id) + ";");
        return result != null;
    }

    public static String getWidgetByIdScript(String id) {
        return "PrimeFaces.getWidgetById('" + id + "')";
    }

    public static boolean isElementPresent(By by) {
        try {
            PrimeGraphene.getWebDriver().findElement(by);
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public static boolean isElementPresent(WebElement element) {
        try {
            element.isDisplayed();
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public static boolean isElementDisplayed(By by) {
        try {
            return PrimeGraphene.getWebDriver().findElement(by).isDisplayed();
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public static boolean isElementDisplayed(WebElement element) {
        try {
            return element.isDisplayed();
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public static boolean isElementEnabled(By by) {
        try {
            return PrimeGraphene.getWebDriver().findElement(by).isEnabled();
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public static boolean isElementEnabled(WebElement element) {
        try {
            return element.isEnabled();
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public static <T> T guardHttpSilently(T target) {
        GrapheneProxyInstance proxy = (GrapheneProxyInstance)Graphene.guardHttp(target);
        PrimeGraphene.registerSilentInterceptor(proxy);
        return (T)proxy;
    }

    public static <T> T guardAjaxSilently(T target) {
        GrapheneProxyInstance proxy = (GrapheneProxyInstance)Graphene.guardAjax(target);
        PrimeGraphene.registerSilentInterceptor(proxy);
        return (T)proxy;
    }

    private static void registerSilentInterceptor(GrapheneProxyInstance proxy) {
        proxy.registerInterceptor(new Interceptor(){

            public Object intercept(InvocationContext context) throws Throwable {
                try {
                    return context.invoke();
                }
                catch (RequestGuardException ex) {
                    PrimeGraphene.handleRequestGuardException(ex);
                    return null;
                }
            }

            public int getPrecedence() {
                return 1;
            }
        });
    }
}

