/*
 * Decompiled with CFR 0.152.
 */
package org.prevayler.demos.jxpath;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import org.apache.commons.jxpath.JXPathContext;
import org.prevayler.Prevayler;
import org.prevayler.PrevaylerFactory;
import org.prevayler.Transaction;
import org.prevayler.demos.jxpath.ProjectManagementSystem;
import org.prevayler.demos.jxpath.commands.AddProject;
import org.prevayler.demos.jxpath.commands.AddTask;
import org.prevayler.demos.jxpath.model.Project;
import org.prevayler.demos.jxpath.model.Task;

public class Main {
    public static void usage() {
        System.out.println("Usage: Main <list|proj|task|snap> <parameters>\n\nParameters:\n    list:   <xpath expression>\n    proj:   <id> <name>\n    task:   <id> <name> <start> <end> <projectId>\n    snap\n\nNote: dates should be entered in a locale-sensitive format (your locale is " + System.getProperty("user.language") + "_" + System.getProperty("user.country") + ").");
        System.exit(0);
    }

    public static void main(String[] args) {
        try {
            Prevayler prevayler = PrevaylerFactory.createPrevayler((Serializable)new ProjectManagementSystem(), (String)"demoJXPath");
            if (args.length < 1) {
                Main.usage();
            } else if ("list".equalsIgnoreCase(args[0]) && args.length >= 2) {
                Main.list(prevayler, args[1]);
            } else if ("proj".equalsIgnoreCase(args[0]) && args.length >= 3) {
                Main.addProject(prevayler, args[1], args[2]);
            } else if ("task".equalsIgnoreCase(args[0]) && args.length >= 6) {
                Main.addTask(prevayler, args[1], args[2], args[3], args[4], args[5]);
            } else if ("snap".equalsIgnoreCase(args[0])) {
                prevayler.takeSnapshot();
            } else {
                Main.usage();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void list(Prevayler prevayler, String xpathExp) {
        System.out.println("Executing XPath expression...");
        ProjectManagementSystem pms = (ProjectManagementSystem)prevayler.prevalentSystem();
        JXPathContext context = JXPathContext.newContext((Object)pms);
        Iterator i = context.iterate(xpathExp);
        while (i.hasNext()) {
            Object obj = i.next();
            System.out.println(obj.toString());
        }
    }

    private static void addProject(Prevayler prevayler, String id, String name) throws Exception {
        System.out.println("Adding project '" + name + "' (id '" + id + "')...");
        Project p = new Project();
        p.setId(Integer.parseInt(id));
        p.setName(name);
        AddProject cmd = new AddProject();
        cmd.setProject(p);
        prevayler.execute((Transaction)cmd);
    }

    private static void addTask(Prevayler prevayler, String id, String name, String start, String end, String projectId) throws Exception {
        System.out.println("Adding task '" + id + "' to project '" + projectId + "'...");
        Task t = new Task();
        t.setId(Integer.parseInt(id));
        t.setName(name);
        t.setStart(SimpleDateFormat.getInstance().parse(start));
        t.setEnd(SimpleDateFormat.getInstance().parse(end));
        System.out.println("Start: " + t.getStart());
        System.out.println("End:   " + t.getEnd());
        AddTask cmd = new AddTask();
        cmd.setTask(t);
        cmd.setProjectId(Integer.parseInt(projectId));
        prevayler.execute((Transaction)cmd);
    }
}

