/*
 *    Copyright 2018-2021 Prebid.org, Inc.
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

package org.prebid.mobile.rendering.bidding.interfaces;

import org.prebid.mobile.AdSize;
import org.prebid.mobile.rendering.bidding.data.bid.Bid;
import org.prebid.mobile.rendering.bidding.listeners.BannerEventListener;

public class StandaloneBannerEventHandler implements BannerEventHandler {
    private BannerEventListener mBannerViewListener;

    @Override
    public AdSize[] getAdSizeArray() {
        return new AdSize[0];
    }

    @Override
    public void setBannerEventListener(BannerEventListener bannerViewListener) {
        mBannerViewListener = bannerViewListener;
    }

    @Override
    public void requestAdWithBid(Bid bid) {
        mBannerViewListener.onPrebidSdkWin();
    }

    @Override
    public void trackImpression() {

    }

    @Override
    public void destroy() {

    }
}
