/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.prebid.mobile.CacheManager;
import org.prebid.mobile.ImpressionTracker;
import org.prebid.mobile.ImpressionTrackerListener;
import org.prebid.mobile.LogUtil;
import org.prebid.mobile.NativeData;
import org.prebid.mobile.NativeImage;
import org.prebid.mobile.NativeTitle;
import org.prebid.mobile.PrebidNativeAdEventListener;
import org.prebid.mobile.VisibilityDetector;

public class PrebidNativeAd {
    private static final String TAG = "PrebidNativeAd";
    private final ArrayList<NativeTitle> titles = new ArrayList();
    private final ArrayList<NativeImage> images = new ArrayList();
    private final ArrayList<NativeData> dataList = new ArrayList();
    private String clickUrl;
    private ArrayList<String> imp_trackers;
    private VisibilityDetector visibilityDetector;
    private boolean expired;
    private View registeredView;
    private PrebidNativeAdEventListener listener;
    private ArrayList<ImpressionTracker> impressionTrackers;

    public static PrebidNativeAd create(String cacheId) {
        String content = CacheManager.get(cacheId);
        if (!TextUtils.isEmpty((CharSequence)content)) {
            try {
                JSONArray eventtrackers;
                JSONObject link;
                JSONObject details = new JSONObject(content);
                String admStr = details.getString("adm");
                JSONObject adm = new JSONObject(admStr);
                JSONArray asset = adm.getJSONArray("assets");
                PrebidNativeAd ad = new PrebidNativeAd();
                CacheManager.registerCacheExpiryListener(cacheId, new CacheManager.CacheExpiryListener(){

                    @Override
                    public void onCacheExpired() {
                        if (PrebidNativeAd.this.registeredView == null) {
                            if (PrebidNativeAd.this.listener != null) {
                                PrebidNativeAd.this.listener.onAdExpired();
                            }
                            PrebidNativeAd.this.expired = true;
                            if (PrebidNativeAd.this.visibilityDetector != null) {
                                PrebidNativeAd.this.visibilityDetector.destroy();
                                PrebidNativeAd.this.visibilityDetector = null;
                            }
                            PrebidNativeAd.this.impressionTrackers = null;
                            PrebidNativeAd.this.listener = null;
                        }
                    }
                });
                for (int i = 0; i < asset.length(); ++i) {
                    JSONObject adObject = asset.getJSONObject(i);
                    if (adObject.has("title")) {
                        JSONObject title = adObject.getJSONObject("title");
                        if (title.has("text")) {
                            String titleText = title.getString("text");
                            if (!titleText.isEmpty()) {
                                ad.addTitle(new NativeTitle(titleText));
                            }
                        } else {
                            LogUtil.w(TAG, "Json title object doesn't have text field");
                        }
                    }
                    if (adObject.has("data")) {
                        JSONObject data = adObject.getJSONObject("data");
                        if (data.has("value")) {
                            int type = 0;
                            if (data.has("type")) {
                                type = data.optInt("type");
                            }
                            String value = data.getString("value");
                            ad.addData(new NativeData(type, value));
                        } else {
                            LogUtil.w(TAG, "Json data object doesn't have type or value field");
                        }
                    }
                    if (!adObject.has("img")) continue;
                    JSONObject img = adObject.getJSONObject("img");
                    if (img.has("url")) {
                        int type = 0;
                        if (img.has("type")) {
                            type = img.optInt("type");
                        }
                        String url = img.getString("url");
                        ad.addImage(new NativeImage(type, url));
                        continue;
                    }
                    LogUtil.w(TAG, "Json image object doesn't have url or type field");
                }
                if (adm.has("link") && (link = adm.getJSONObject("link")).has("url")) {
                    String url = link.getString("url");
                    if (url.contains("{AUCTION_PRICE}") && details.has("price")) {
                        url = url.replace("{AUCTION_PRICE}", details.getString("price"));
                    }
                    ad.setClickUrl(url);
                }
                if (adm.has("eventtrackers") && (eventtrackers = adm.getJSONArray("eventtrackers")).length() > 0) {
                    ad.imp_trackers = new ArrayList();
                    for (int count = 0; count < eventtrackers.length(); ++count) {
                        JSONObject eventtracker = eventtrackers.getJSONObject(count);
                        if (!eventtracker.has("url")) continue;
                        String impUrl = eventtracker.getString("url");
                        if (impUrl.contains("{AUCTION_PRICE}") && details.has("price")) {
                            impUrl = impUrl.replace("{AUCTION_PRICE}", details.getString("price"));
                        }
                        ad.imp_trackers.add(impUrl);
                    }
                }
                return ad;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private PrebidNativeAd() {
    }

    public void addTitle(NativeTitle title) {
        this.titles.add(title);
    }

    public void addData(NativeData data) {
        this.dataList.add(data);
    }

    public void addImage(NativeImage image) {
        this.images.add(image);
    }

    @NonNull
    public ArrayList<NativeTitle> getTitles() {
        return this.titles;
    }

    @NonNull
    public ArrayList<NativeImage> getImages() {
        return this.images;
    }

    @NonNull
    public ArrayList<NativeData> getDataList() {
        return this.dataList;
    }

    private void setClickUrl(String clickUrl) {
        this.clickUrl = clickUrl;
    }

    @NonNull
    public String getTitle() {
        if (!this.titles.isEmpty()) {
            return this.titles.get(0).getText();
        }
        return "";
    }

    @NonNull
    public String getDescription() {
        for (NativeData data : this.dataList) {
            if (data.getType() != NativeData.Type.DESCRIPTION) continue;
            return data.getValue();
        }
        return "";
    }

    @NonNull
    public String getIconUrl() {
        for (NativeImage image : this.images) {
            if (image.getType() != NativeImage.Type.ICON) continue;
            return image.getUrl();
        }
        return "";
    }

    @NonNull
    public String getImageUrl() {
        for (NativeImage image : this.images) {
            if (image.getType() != NativeImage.Type.MAIN_IMAGE) continue;
            return image.getUrl();
        }
        return "";
    }

    @NonNull
    public String getCallToAction() {
        for (NativeData data : this.dataList) {
            if (data.getType() != NativeData.Type.CALL_TO_ACTION) continue;
            return data.getValue();
        }
        return "";
    }

    @NonNull
    public String getSponsoredBy() {
        for (NativeData data : this.dataList) {
            if (data.getType() != NativeData.Type.SPONSORED_BY) continue;
            return data.getValue();
        }
        return "";
    }

    public boolean registerView(View view, final PrebidNativeAdEventListener listener) {
        if (!this.expired && view != null) {
            this.listener = listener;
            this.visibilityDetector = VisibilityDetector.create(view);
            if (this.visibilityDetector == null) {
                return false;
            }
            this.impressionTrackers = new ArrayList(this.imp_trackers.size());
            for (String url : this.imp_trackers) {
                ImpressionTracker impressionTracker = ImpressionTracker.create(url, this.visibilityDetector, view.getContext(), new ImpressionTrackerListener(){

                    @Override
                    public void onImpressionTrackerFired() {
                        if (listener != null) {
                            listener.onAdImpression();
                        }
                    }
                });
                this.impressionTrackers.add(impressionTracker);
            }
            this.registeredView = view;
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    PrebidNativeAd.this.handleClick(v, listener);
                }
            });
            return true;
        }
        return false;
    }

    public boolean registerViewList(View container, List<View> viewList, final PrebidNativeAdEventListener listener) {
        if (container == null || viewList == null || viewList.isEmpty()) {
            return false;
        }
        if (!this.expired && container != null) {
            this.listener = listener;
            this.visibilityDetector = VisibilityDetector.create(container);
            if (this.visibilityDetector == null) {
                return false;
            }
            this.impressionTrackers = new ArrayList(this.imp_trackers.size());
            for (String url : this.imp_trackers) {
                ImpressionTracker impressionTracker = ImpressionTracker.create(url, this.visibilityDetector, container.getContext(), new ImpressionTrackerListener(){

                    @Override
                    public void onImpressionTrackerFired() {
                        if (listener != null) {
                            listener.onAdImpression();
                        }
                    }
                });
                this.impressionTrackers.add(impressionTracker);
            }
            this.registeredView = container;
            container.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    PrebidNativeAd.this.handleClick(v, listener);
                }
            });
            if (viewList != null && viewList.size() > 0) {
                for (View views : viewList) {
                    views.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            PrebidNativeAd.this.handleClick(v, listener);
                        }
                    });
                }
            }
            return true;
        }
        return false;
    }

    protected boolean registerPrebidNativeAdEventListener(PrebidNativeAdEventListener listener) {
        this.listener = listener;
        return true;
    }

    private boolean handleClick(View v, PrebidNativeAdEventListener listener) {
        if (this.clickUrl == null || this.clickUrl.isEmpty()) {
            return false;
        }
        if (this.openNativeIntent(this.clickUrl, v.getContext())) {
            if (listener != null) {
                listener.onAdClicked();
            }
            return true;
        }
        return false;
    }

    private boolean openNativeIntent(String url, Context context) {
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
        intent.setFlags(0x10000000);
        try {
            context.startActivity(intent);
            return true;
        }
        catch (ActivityNotFoundException e) {
            return false;
        }
    }
}

