/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.prebid.mobile.AdvertisingIDUtil;
import org.prebid.mobile.ExternalUserId;
import org.prebid.mobile.Host;
import org.prebid.mobile.PrebidServerSettings;

public class PrebidMobile {
    private static final int TIMEOUT_MILLIS = 2000;
    private static int timeoutMillis = 2000;
    static boolean timeoutMillisUpdated = false;
    @Nullable
    private static String storedAuctionResponse = "";
    private static boolean pbsDebug = false;
    @NonNull
    private static final Map<String, String> storedBidResponses = new LinkedHashMap<String, String>();
    private static String accountId = "";
    private static Host host = Host.CUSTOM;
    private static boolean shareGeoLocation = false;
    private static List<ExternalUserId> externalUserIds = new ArrayList<ExternalUserId>();
    private static HashMap<String, String> customHeaders = new HashMap();
    private static boolean assignNativeAssetID = false;
    private static WeakReference<Context> applicationContextWeak;

    public static int getTimeoutMillis() {
        return timeoutMillis;
    }

    public static void setTimeoutMillis(int timeoutMillis) {
        PrebidMobile.timeoutMillis = timeoutMillis;
    }

    private PrebidMobile() {
    }

    public static void setPrebidServerAccountId(String accountId) {
        PrebidMobile.accountId = accountId;
    }

    public static String getPrebidServerAccountId() {
        return accountId;
    }

    public static void setPrebidServerHost(Host host) {
        PrebidMobile.host = host;
        timeoutMillisUpdated = false;
        timeoutMillis = 2000;
    }

    public static Host getPrebidServerHost() {
        return host;
    }

    public static void setShareGeoLocation(boolean share) {
        shareGeoLocation = share;
    }

    public static boolean isShareGeoLocation() {
        return shareGeoLocation;
    }

    public static void setExternalUserIds(List<ExternalUserId> externalUserIds) {
        PrebidMobile.externalUserIds = externalUserIds;
    }

    public static List<ExternalUserId> getExternalUserIds() {
        return externalUserIds;
    }

    public static void setCustomHeaders(HashMap<String, String> customHeaders) {
        PrebidMobile.customHeaders = customHeaders;
    }

    public static HashMap<String, String> getCustomHeaders() {
        return customHeaders;
    }

    public static void setApplicationContext(Context context) {
        applicationContextWeak = new WeakReference<Context>(context);
        if (context != null) {
            AdvertisingIDUtil.retrieveAndSetAAID(context);
            PrebidServerSettings.update(context);
        }
    }

    public static Context getApplicationContext() {
        if (applicationContextWeak != null) {
            return (Context)applicationContextWeak.get();
        }
        return null;
    }

    public static void setStoredAuctionResponse(@NonNull String storedAuctionResponse) {
        PrebidMobile.storedAuctionResponse = storedAuctionResponse;
    }

    @Nullable
    public static String getStoredAuctionResponse() {
        return storedAuctionResponse;
    }

    public static void addStoredBidResponse(String bidder, String responseId) {
        storedBidResponses.put(bidder, responseId);
    }

    public static void clearStoredBidResponses() {
        storedBidResponses.clear();
    }

    @NonNull
    static Map<String, String> getStoredBidResponses() {
        return storedBidResponses;
    }

    public static boolean getPbsDebug() {
        return pbsDebug;
    }

    public static void setPbsDebug(boolean pbsDebug) {
        PrebidMobile.pbsDebug = pbsDebug;
    }

    public static boolean shouldAssignNativeAssetID() {
        return assignNativeAssetID;
    }

    public static void assignNativeAssetID(boolean assignNativeAssetID) {
        PrebidMobile.assignNativeAssetID = assignNativeAssetID;
    }
}

