/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile;

import androidx.annotation.NonNull;

public class NativeImage {
    private final int typeNumber;
    private final String url;

    public NativeImage(int typeNumber, @NonNull String url) {
        this.typeNumber = typeNumber;
        this.url = url;
    }

    public NativeImage(@NonNull Type type, @NonNull String url) {
        if (type == Type.CUSTOM) {
            throw new IllegalArgumentException("For CUSTOM type use constructor with typeNumber parameter.");
        }
        this.typeNumber = Type.getNumberFromType(type);
        this.url = url;
    }

    public int getTypeNumber() {
        return this.typeNumber;
    }

    @NonNull
    public String getUrl() {
        return this.url;
    }

    @NonNull
    public Type getType() {
        return Type.getTypeFromNumber(this.typeNumber);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        NativeImage that = (NativeImage)object;
        return this.typeNumber == that.typeNumber && this.url.equals(that.url);
    }

    public static enum Type {
        ICON,
        MAIN_IMAGE,
        CUSTOM;


        public static Type getTypeFromNumber(int typeNumber) {
            switch (typeNumber) {
                case 1: {
                    return ICON;
                }
                case 3: {
                    return MAIN_IMAGE;
                }
            }
            return CUSTOM;
        }

        public static int getNumberFromType(Type type) {
            switch (type) {
                case ICON: {
                    return 1;
                }
                case MAIN_IMAGE: {
                    return 3;
                }
            }
            return 0;
        }
    }
}

