/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile;

import androidx.annotation.NonNull;

public class NativeData {
    private final int typeNumber;
    private final String value;

    public NativeData(int typeNumber, @NonNull String value) {
        this.typeNumber = typeNumber;
        this.value = value;
    }

    public NativeData(Type type, @NonNull String value) {
        if (type == Type.CUSTOM) {
            throw new IllegalArgumentException("For CUSTOM type use constructor with typeNumber parameter.");
        }
        this.typeNumber = Type.getNumberFromType(type);
        this.value = value;
    }

    public int getTypeNumber() {
        return this.typeNumber;
    }

    @NonNull
    public String getValue() {
        return this.value;
    }

    @NonNull
    public Type getType() {
        return Type.getFromTypeNumber(this.typeNumber);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        NativeData that = (NativeData)object;
        return this.typeNumber == that.typeNumber && this.value.equals(that.value);
    }

    public static enum Type {
        SPONSORED_BY,
        DESCRIPTION,
        CALL_TO_ACTION,
        RATING,
        CUSTOM;


        public static Type getFromTypeNumber(int typeNumber) {
            switch (typeNumber) {
                case 1: {
                    return SPONSORED_BY;
                }
                case 2: {
                    return DESCRIPTION;
                }
                case 3: {
                    return RATING;
                }
                case 12: {
                    return CALL_TO_ACTION;
                }
            }
            return CUSTOM;
        }

        public static int getNumberFromType(Type type) {
            switch (type) {
                case SPONSORED_BY: {
                    return 1;
                }
                case DESCRIPTION: {
                    return 2;
                }
                case RATING: {
                    return 3;
                }
                case CALL_TO_ACTION: {
                    return 12;
                }
            }
            return 0;
        }
    }
}

