/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile;

import android.content.Context;
import org.prebid.mobile.ImpressionTrackerListener;
import org.prebid.mobile.SharedNetworkManager;
import org.prebid.mobile.VisibilityDetector;
import org.prebid.mobile.http.HTTPGet;
import org.prebid.mobile.http.HTTPResponse;

class ImpressionTracker {
    private String url;
    private VisibilityDetector visibilityDetector;
    private boolean fired = false;
    private Context context;
    private ImpressionListener listener;
    private ImpressionTrackerListener impressionTrackerListener;

    static ImpressionTracker create(String url, VisibilityDetector visibilityDetector, Context context, ImpressionTrackerListener impressionTrackerListener) {
        if (visibilityDetector == null) {
            return null;
        }
        ImpressionTracker impressionTracker = new ImpressionTracker(url, visibilityDetector, context, impressionTrackerListener);
        visibilityDetector.addVisibilityListener(impressionTracker.listener);
        return impressionTracker;
    }

    private ImpressionTracker(String url, VisibilityDetector visibilityDetector, Context context, ImpressionTrackerListener impressionTrackerListener) {
        this.url = url;
        this.visibilityDetector = visibilityDetector;
        this.listener = new ImpressionListener();
        this.context = context;
        this.impressionTrackerListener = impressionTrackerListener;
    }

    private synchronized void fire() {
        if (!this.fired) {
            SharedNetworkManager nm = SharedNetworkManager.getInstance(this.context);
            if (nm.isConnected(this.context)) {
                HTTPGet asyncTask = new HTTPGet(){

                    @Override
                    protected void onPostExecute(HTTPResponse response) {
                        if (ImpressionTracker.this.impressionTrackerListener != null) {
                            ImpressionTracker.this.impressionTrackerListener.onImpressionTrackerFired();
                        }
                    }

                    @Override
                    protected String getUrl() {
                        return ImpressionTracker.this.url;
                    }
                };
                asyncTask.execute();
                this.visibilityDetector.removeVisibilityListener(this.listener);
                this.listener = null;
            } else {
                nm.addURL(this.url, this.context, new ImpressionTrackerListener(){

                    @Override
                    public void onImpressionTrackerFired() {
                        if (ImpressionTracker.this.impressionTrackerListener != null) {
                            ImpressionTracker.this.impressionTrackerListener.onImpressionTrackerFired();
                        }
                    }
                });
            }
            this.fired = true;
        }
    }

    class ImpressionListener
    implements VisibilityDetector.VisibilityListener {
        long elapsedTime = 0L;

        ImpressionListener() {
        }

        @Override
        public void onVisibilityChanged(boolean visible) {
            this.elapsedTime = visible ? (this.elapsedTime += 250L) : 0L;
            if (this.elapsedTime >= 1000L) {
                ImpressionTracker.this.fire();
            }
        }
    }
}

