/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.prebid.mobile.LogUtil;

public class DataObject {
    @Nullable
    private String id;
    @Nullable
    private String name;
    @NonNull
    private ArrayList<SegmentObject> segments = new ArrayList();

    public JSONObject getJsonObject() {
        JSONObject result = new JSONObject();
        try {
            result.putOpt("id", (Object)this.id);
            result.putOpt("name", (Object)this.name);
            if (!this.segments.isEmpty()) {
                JSONArray segmentsJson = new JSONArray();
                for (SegmentObject segment : this.segments) {
                    segmentsJson.put((Object)segment.getJsonObject());
                }
                result.put("segment", (Object)segmentsJson);
            }
        }
        catch (JSONException exception) {
            LogUtil.e("DataObject", "Can't create json data content object.");
        }
        return result;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public void setId(@Nullable String id) {
        this.id = id;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(@Nullable String name) {
        this.name = name;
    }

    public void addSegment(@NonNull SegmentObject segmentObject) {
        this.segments.add(segmentObject);
    }

    @NonNull
    public ArrayList<SegmentObject> getSegments() {
        return this.segments;
    }

    public void setSegments(@NonNull ArrayList<SegmentObject> segments) {
        this.segments = segments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataObject that = (DataObject)o;
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return this.segments.equals(that.segments);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + this.segments.hashCode();
        return result;
    }

    public static class SegmentObject {
        @Nullable
        private String id;
        @Nullable
        private String name;
        @Nullable
        private String value;

        @Nullable
        public JSONObject getJsonObject() {
            JSONObject result = new JSONObject();
            try {
                result.putOpt("id", (Object)this.id);
                result.putOpt("name", (Object)this.name);
                result.putOpt("value", (Object)this.value);
            }
            catch (JSONException exception) {
                LogUtil.e("SegmentObject", "Can't create json segment object.");
            }
            return result;
        }

        @Nullable
        public String getId() {
            return this.id;
        }

        public void setId(@Nullable String id) {
            this.id = id;
        }

        @Nullable
        public String getName() {
            return this.name;
        }

        public void setName(@Nullable String name) {
            this.name = name;
        }

        @Nullable
        public String getValue() {
            return this.value;
        }

        public void setValue(@Nullable String value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SegmentObject that = (SegmentObject)o;
            if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
                return false;
            }
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            return this.value != null ? this.value.equals(that.value) : that.value == null;
        }

        public int hashCode() {
            int result = this.id != null ? this.id.hashCode() : 0;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }
    }
}

