/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.prebid.mobile.DataObject;
import org.prebid.mobile.LogUtil;

public class ContentObject {
    @Nullable
    private String id;
    @Nullable
    private Integer episode;
    @Nullable
    private String title;
    @Nullable
    private String series;
    @Nullable
    private String season;
    @Nullable
    private String artist;
    @Nullable
    private String genre;
    @Nullable
    private String album;
    @Nullable
    private String isrc;
    @Nullable
    private String url;
    @NonNull
    private ArrayList<String> categories = new ArrayList();
    @Nullable
    private Integer productionQuality;
    @Nullable
    private Integer context;
    @Nullable
    private String contentRating;
    @Nullable
    private String userRating;
    @Nullable
    private Integer qaMediaRating;
    @Nullable
    private String keywords;
    @Nullable
    private Integer liveStream;
    @Nullable
    private Integer sourceRelationship;
    @Nullable
    private Integer length;
    @Nullable
    private String language;
    @Nullable
    private Integer embeddable;
    @NonNull
    private ArrayList<DataObject> dataObjects = new ArrayList();
    @Nullable
    private ProducerObject producerObject;

    public JSONObject getJsonObject() {
        JSONObject result = new JSONObject();
        try {
            result.putOpt("id", (Object)this.id);
            result.putOpt("episode", (Object)this.episode);
            result.putOpt("title", (Object)this.title);
            result.putOpt("series", (Object)this.series);
            result.putOpt("season", (Object)this.season);
            result.putOpt("artist", (Object)this.artist);
            result.putOpt("genre", (Object)this.genre);
            result.putOpt("album", (Object)this.album);
            result.putOpt("isrc", (Object)this.isrc);
            result.putOpt("url", (Object)this.url);
            result.putOpt("prodq", (Object)this.productionQuality);
            result.putOpt("context", (Object)this.context);
            result.putOpt("contentrating", (Object)this.contentRating);
            result.putOpt("userrating", (Object)this.userRating);
            result.putOpt("qagmediarating", (Object)this.qaMediaRating);
            result.putOpt("keywords", (Object)this.keywords);
            result.putOpt("livestream", (Object)this.liveStream);
            result.putOpt("sourcerelationship", (Object)this.sourceRelationship);
            result.putOpt("len", (Object)this.length);
            result.putOpt("language", (Object)this.language);
            result.putOpt("embeddable", (Object)this.embeddable);
            if (this.producerObject != null) {
                result.putOpt("producer", (Object)this.producerObject.getJsonObject());
            }
            if (!this.categories.isEmpty()) {
                JSONArray jsonCategories = new JSONArray();
                for (String category : this.categories) {
                    jsonCategories.put((Object)category);
                }
                result.putOpt("cat", (Object)jsonCategories);
            }
            if (!this.dataObjects.isEmpty()) {
                JSONArray dataJson = new JSONArray();
                for (DataObject dataObject : this.dataObjects) {
                    dataJson.put((Object)dataObject.getJsonObject());
                }
                result.put("data", (Object)dataJson);
            }
            if (result.length() == 0) {
                return null;
            }
        }
        catch (JSONException exception) {
            LogUtil.e("ContentObject", "Can't create json result object.");
        }
        return result;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public void setId(@Nullable String id) {
        this.id = id;
    }

    @Nullable
    public Integer getEpisode() {
        return this.episode;
    }

    public void setEpisode(@Nullable Integer episode) {
        this.episode = episode;
    }

    @Nullable
    public String getTitle() {
        return this.title;
    }

    public void setTitle(@Nullable String title) {
        this.title = title;
    }

    @Nullable
    public String getSeries() {
        return this.series;
    }

    public void setSeries(@Nullable String series) {
        this.series = series;
    }

    @Nullable
    public String getSeason() {
        return this.season;
    }

    public void setSeason(@Nullable String season) {
        this.season = season;
    }

    @Nullable
    public String getArtist() {
        return this.artist;
    }

    public void setArtist(@Nullable String artist) {
        this.artist = artist;
    }

    @Nullable
    public String getGenre() {
        return this.genre;
    }

    public void setGenre(@Nullable String genre) {
        this.genre = genre;
    }

    @Nullable
    public String getAlbum() {
        return this.album;
    }

    public void setAlbum(@Nullable String album) {
        this.album = album;
    }

    @Nullable
    public String getIsrc() {
        return this.isrc;
    }

    public void setIsrc(@Nullable String isrc) {
        this.isrc = isrc;
    }

    @Nullable
    public String getUrl() {
        return this.url;
    }

    public void setUrl(@Nullable String url) {
        this.url = url;
    }

    public void addCategory(@NonNull String category) {
        this.categories.add(category);
    }

    @NonNull
    public ArrayList<String> getCategories() {
        return this.categories;
    }

    public void setCategories(@NonNull ArrayList<String> categories) {
        this.categories = categories;
    }

    @Nullable
    public Integer getProductionQuality() {
        return this.productionQuality;
    }

    public void setProductionQuality(@Nullable Integer productionQuality) {
        this.productionQuality = productionQuality;
    }

    @Nullable
    public Integer getContext() {
        return this.context;
    }

    public void setContext(@Nullable Integer context) {
        this.context = context;
    }

    @Nullable
    public String getContentRating() {
        return this.contentRating;
    }

    public void setContentRating(@Nullable String contentRating) {
        this.contentRating = contentRating;
    }

    @Nullable
    public String getUserRating() {
        return this.userRating;
    }

    public void setUserRating(@Nullable String userRating) {
        this.userRating = userRating;
    }

    @Nullable
    public Integer getQaMediaRating() {
        return this.qaMediaRating;
    }

    public void setQaMediaRating(@Nullable Integer qaMediaRating) {
        this.qaMediaRating = qaMediaRating;
    }

    @Nullable
    public String getKeywords() {
        return this.keywords;
    }

    public void setKeywords(@Nullable String keywords) {
        this.keywords = keywords;
    }

    @Nullable
    public Integer getLiveStream() {
        return this.liveStream;
    }

    public void setLiveStream(@Nullable Integer liveStream) {
        this.liveStream = liveStream;
    }

    @Nullable
    public Integer getSourceRelationship() {
        return this.sourceRelationship;
    }

    public void setSourceRelationship(@Nullable Integer sourceRelationship) {
        this.sourceRelationship = sourceRelationship;
    }

    @Nullable
    public Integer getLength() {
        return this.length;
    }

    public void setLength(@Nullable Integer length) {
        this.length = length;
    }

    @Nullable
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(@Nullable String language) {
        this.language = language;
    }

    @Nullable
    public Integer getEmbeddable() {
        return this.embeddable;
    }

    public void setEmbeddable(@Nullable Integer embeddable) {
        this.embeddable = embeddable;
    }

    public void addData(@NonNull DataObject dataObject) {
        this.dataObjects.add(dataObject);
    }

    @NonNull
    public ArrayList<DataObject> getDataList() {
        return this.dataObjects;
    }

    public void setDataList(@NonNull ArrayList<DataObject> dataObjects) {
        this.dataObjects = dataObjects;
    }

    public void clearDataList() {
        this.dataObjects.clear();
    }

    @Nullable
    public ProducerObject getProducer() {
        return this.producerObject;
    }

    public void setProducer(@Nullable ProducerObject producerObject) {
        this.producerObject = producerObject;
    }

    public static class ProducerObject {
        @Nullable
        private String id;
        @Nullable
        private String name;
        @NonNull
        private ArrayList<String> categories = new ArrayList();
        @Nullable
        private String domain;

        @Nullable
        public JSONObject getJsonObject() {
            JSONObject result = new JSONObject();
            try {
                result.putOpt("id", (Object)this.id);
                result.putOpt("name", (Object)this.name);
                result.putOpt("domain", (Object)this.domain);
                if (!this.categories.isEmpty()) {
                    JSONArray categoriesJson = new JSONArray();
                    for (String category : this.categories) {
                        categoriesJson.put((Object)category);
                    }
                    result.put("cat", (Object)categoriesJson);
                }
            }
            catch (JSONException exception) {
                LogUtil.e("ContentObject", "Can't create json producer content object.");
            }
            return result;
        }

        @Nullable
        public String getId() {
            return this.id;
        }

        public void setId(@Nullable String id) {
            this.id = id;
        }

        @Nullable
        public String getName() {
            return this.name;
        }

        public void setName(@Nullable String name) {
            this.name = name;
        }

        public void addCategory(@NonNull String category) {
            this.categories.add(category);
        }

        @NonNull
        public List<String> getCategories() {
            return this.categories;
        }

        public void setCategories(@NonNull ArrayList<String> categories) {
            this.categories = categories;
        }

        @Nullable
        public String getDomain() {
            return this.domain;
        }

        public void setDomain(@Nullable String domain) {
            this.domain = domain;
        }
    }
}

