/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.text.TextUtils;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.prebid.mobile.AdSize;
import org.prebid.mobile.AdType;
import org.prebid.mobile.BannerAdUnit;
import org.prebid.mobile.BannerBaseAdUnit;
import org.prebid.mobile.ContentObject;
import org.prebid.mobile.DataObject;
import org.prebid.mobile.DemandFetcher;
import org.prebid.mobile.Host;
import org.prebid.mobile.InterstitialAdUnit;
import org.prebid.mobile.LogUtil;
import org.prebid.mobile.NativeAdUnit;
import org.prebid.mobile.OnCompleteListener;
import org.prebid.mobile.OnCompleteListener2;
import org.prebid.mobile.PrebidMobile;
import org.prebid.mobile.RequestParams;
import org.prebid.mobile.ResultCode;
import org.prebid.mobile.Util;
import org.prebid.mobile.VideoAdUnit;
import org.prebid.mobile.VideoBaseAdUnit;
import org.prebid.mobile.tasksmanager.TasksManager;

public abstract class AdUnit {
    private static final int MIN_AUTO_REFRESH_PERIOD_MILLIS = 30000;
    private String configId;
    private AdType adType;
    private DemandFetcher fetcher;
    private int periodMillis;
    private final Map<String, Set<String>> contextDataDictionary;
    private final Set<String> contextKeywordsSet;
    private ContentObject content;
    private final ArrayList<DataObject> userDataObjects = new ArrayList();
    private String pbAdSlot;

    AdUnit(@NonNull String configId, @NonNull AdType adType) {
        this.configId = configId;
        this.adType = adType;
        this.periodMillis = 0;
        this.contextDataDictionary = new HashMap<String, Set<String>>();
        this.contextKeywordsSet = new HashSet<String>();
    }

    public void setAutoRefreshPeriodMillis(@IntRange(from=30000L) int periodMillis) {
        if (periodMillis < 30000) {
            LogUtil.w("periodMillis less then:30000");
            return;
        }
        this.periodMillis = periodMillis;
        if (this.fetcher != null) {
            this.fetcher.setPeriodMillis(periodMillis);
        }
    }

    public void resumeAutoRefresh() {
        LogUtil.v("Resuming auto refresh...");
        if (this.fetcher != null) {
            this.fetcher.start();
        }
    }

    public void stopAutoRefresh() {
        LogUtil.v("Stopping auto refresh...");
        if (this.fetcher != null) {
            this.fetcher.stop();
        }
    }

    public void fetchDemand(final @NonNull OnCompleteListener2 listener) {
        final HashMap keywordsMap = new HashMap();
        this.fetchDemand(keywordsMap, new OnCompleteListener(){

            @Override
            public void onComplete(final ResultCode resultCode) {
                TasksManager.getInstance().executeOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        listener.onComplete(resultCode, keywordsMap.size() != 0 ? Collections.unmodifiableMap(keywordsMap) : null);
                    }
                });
            }
        });
    }

    public void fetchDemand(@NonNull Object adObj, @NonNull OnCompleteListener listener) {
        Context context;
        if (TextUtils.isEmpty((CharSequence)PrebidMobile.getPrebidServerAccountId())) {
            LogUtil.e("Empty account id.");
            listener.onComplete(ResultCode.INVALID_ACCOUNT_ID);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.configId)) {
            LogUtil.e("Empty config id.");
            listener.onComplete(ResultCode.INVALID_CONFIG_ID);
            return;
        }
        if (PrebidMobile.getPrebidServerHost().equals((Object)Host.CUSTOM) && TextUtils.isEmpty((CharSequence)PrebidMobile.getPrebidServerHost().getHostUrl())) {
            LogUtil.e("Empty host url for custom Prebid Server host.");
            listener.onComplete(ResultCode.INVALID_HOST_URL);
            return;
        }
        HashSet<AdSize> sizes = null;
        if (this.adType == AdType.BANNER) {
            sizes = ((BannerAdUnit)this).getSizes();
            for (AdSize adSize : sizes) {
                if (adSize.getWidth() >= 0 && adSize.getHeight() >= 0) continue;
                listener.onComplete(ResultCode.INVALID_SIZE);
                return;
            }
        } else if (this.adType == AdType.VIDEO) {
            VideoAdUnit videoAdUnit = (VideoAdUnit)this;
            sizes = new HashSet(1);
            sizes.add(videoAdUnit.getAdSize());
            for (AdSize size : sizes) {
                if (size.getWidth() >= 0 && size.getHeight() >= 0) continue;
                listener.onComplete(ResultCode.INVALID_SIZE);
                return;
            }
        }
        AdSize minSizePerc = null;
        if (this instanceof InterstitialAdUnit) {
            InterstitialAdUnit interstitialAdUnit = (InterstitialAdUnit)this;
            minSizePerc = interstitialAdUnit.getMinSizePerc();
        }
        if ((context = PrebidMobile.getApplicationContext()) != null) {
            NetworkInfo activeNetworkInfo;
            ConnectivityManager conMgr = (ConnectivityManager)context.getSystemService("connectivity");
            if (!(conMgr == null || context.checkCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE") != 0 || (activeNetworkInfo = conMgr.getActiveNetworkInfo()) != null && activeNetworkInfo.isConnected())) {
                listener.onComplete(ResultCode.NETWORK_ERROR);
                return;
            }
        } else {
            LogUtil.e("Invalid context");
            listener.onComplete(ResultCode.INVALID_CONTEXT);
            return;
        }
        BannerBaseAdUnit.Parameters bannerParameters = null;
        if (this instanceof BannerBaseAdUnit) {
            BannerBaseAdUnit bannerBaseAdUnit = (BannerBaseAdUnit)this;
            bannerParameters = bannerBaseAdUnit.parameters;
        }
        VideoBaseAdUnit.Parameters videoParameters = null;
        if (this instanceof VideoBaseAdUnit) {
            VideoBaseAdUnit videoBaseAdUnit = (VideoBaseAdUnit)this;
            videoParameters = videoBaseAdUnit.parameters;
        }
        if (Util.supportedAdObject(adObj)) {
            this.fetcher = new DemandFetcher(adObj);
            RequestParams requestParams = new RequestParams(this.configId, this.adType, sizes, this.contextDataDictionary, this.contextKeywordsSet, minSizePerc, this.pbAdSlot, bannerParameters, videoParameters, this.content, this.userDataObjects);
            if (this.adType.equals((Object)AdType.NATIVE)) {
                requestParams.setNativeRequestParams(((NativeAdUnit)this).params);
            }
            this.fetcher.setPeriodMillis(this.periodMillis);
            this.fetcher.setRequestParams(requestParams);
            this.fetcher.setListener(listener);
            if (this.periodMillis >= 30000) {
                LogUtil.v("Start fetching bids with auto refresh millis: " + this.periodMillis);
            } else {
                LogUtil.v("Start a single fetching.");
            }
            this.fetcher.start();
        } else {
            listener.onComplete(ResultCode.INVALID_AD_OBJECT);
        }
    }

    public void addContextData(String key, String value) {
        Util.addValue(this.contextDataDictionary, key, value);
    }

    public void updateContextData(String key, Set<String> value) {
        this.contextDataDictionary.put(key, value);
    }

    public void removeContextData(String key) {
        this.contextDataDictionary.remove(key);
    }

    public void clearContextData() {
        this.contextDataDictionary.clear();
    }

    Map<String, Set<String>> getContextDataDictionary() {
        return this.contextDataDictionary;
    }

    public void addContextKeyword(String keyword) {
        this.contextKeywordsSet.add(keyword);
    }

    public void addContextKeywords(Set<String> keywords) {
        this.contextKeywordsSet.addAll(keywords);
    }

    public void setAppContent(ContentObject content) {
        this.content = content;
    }

    public ContentObject getAppContent() {
        return this.content;
    }

    public void addUserData(DataObject dataObject) {
        this.userDataObjects.add(dataObject);
    }

    public ArrayList<DataObject> getUserData() {
        return this.userDataObjects;
    }

    public void clearUserData() {
        this.userDataObjects.clear();
    }

    public void removeContextKeyword(String keyword) {
        this.contextKeywordsSet.remove(keyword);
    }

    public void clearContextKeywords() {
        this.contextKeywordsSet.clear();
    }

    Set<String> getContextKeywordsSet() {
        return this.contextKeywordsSet;
    }

    public String getPbAdSlot() {
        return this.pbAdSlot;
    }

    public void setPbAdSlot(String pbAdSlot) {
        this.pbAdSlot = pbAdSlot;
    }
}

