/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile.addendum;

import java.util.LinkedList;
import java.util.Queue;

public class LimitedQueueContainer<T> {
    private Queue<T> list = new LinkedList<T>();
    private final int limit;

    public LimitedQueueContainer(int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException("Illegal Limit:" + limit);
        }
        this.limit = limit;
    }

    void add(T t) {
        this.list.add(t);
        if (this.list.size() > this.limit) {
            this.list.poll();
        }
    }

    boolean isFull() {
        return this.list.size() == this.limit;
    }

    Queue<T> getList() {
        return this.list;
    }
}

