/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile.addendum;

import android.annotation.TargetApi;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ValueCallback;
import android.webkit.WebView;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.prebid.mobile.CacheManager;
import org.prebid.mobile.LogUtil;
import org.prebid.mobile.PrebidNativeAd;
import org.prebid.mobile.PrebidNativeAdListener;
import org.prebid.mobile.addendum.LimitedQueueContainer;
import org.prebid.mobile.addendum.Pair;
import org.prebid.mobile.addendum.PbFindSizeError;
import org.prebid.mobile.addendum.PbFindSizeErrorFactory;

public final class AdViewUtils {
    private static final String INNER_HTML_SCRIPT = "document.body.innerHTML";
    private static final String SIZE_VALUE_REGEX_EXPRESSION = "[0-9]+x[0-9]+";
    private static final String SIZE_OBJECT_REGEX_EXPRESSION = "hb_size\\W+[0-9]+x[0-9]+";
    private static final String GAM_VIEW_CLASS = "com.google.android.gms.ads.doubleclick.PublisherAdView";
    private static final String GAM_VIEW_CLASS_2 = "com.google.android.gms.ads.admanager.AdManagerAdView";
    private static final String GAM_CUSTOM_TEMPLATE_AD_CLASS = "com.google.android.gms.ads.formats.NativeCustomTemplateAd";
    private static final String GAM_CUSTOM_TEMPLATE_AD_CLASS_2 = "com.google.android.gms.ads.nativead.NativeCustomFormatAd";
    private static final String MOPUB_NATIVE_AD_CLASS = "com.mopub.nativeads.NativeAd";

    private AdViewUtils() {
    }

    public static void findPrebidCreativeSize(@Nullable View adView, PbFindSizeListener handler) {
        if (adView == null) {
            AdViewUtils.warnAndTriggerFailure(PbFindSizeErrorFactory.NO_WEB_VIEW, handler);
            return;
        }
        ArrayList<WebView> webViewList = new ArrayList<WebView>(2);
        AdViewUtils.recursivelyFindWebViewList(adView, webViewList);
        if (webViewList.size() == 0) {
            AdViewUtils.warnAndTriggerFailure(PbFindSizeErrorFactory.NO_WEB_VIEW, handler);
            return;
        }
        AdViewUtils.findSizeInWebViewListAsync(webViewList, handler);
    }

    static void triggerSuccess(WebView webView, Pair<Integer, Integer> adSize, PbFindSizeListener handler) {
        int width = (Integer)adSize.first;
        int height = (Integer)adSize.second;
        handler.success(width, height);
        AdViewUtils.fixZoomIn(webView, width, height);
    }

    static void fixZoomIn(final WebView webView, int expectedWidth, final int expectedHeight) {
        int minViewHeight = 10;
        int contentHeightDelayMillis = 100;
        int queueLimit = 5;
        final LimitedQueueContainer contentHeightQueue = new LimitedQueueContainer(queueLimit);
        final HashSet contentHeightSet = new HashSet(queueLimit);
        webView.post(new Runnable(){

            @Override
            public void run() {
                int webViewHeight = webView.getHeight();
                if (webViewHeight > 10) {
                    int webViewContentHeight = webView.getContentHeight();
                    if (webViewContentHeight < expectedHeight) {
                        LogUtil.d("fixZoomIn webViewContentHeight:" + webViewContentHeight);
                        contentHeightQueue.add(webViewContentHeight);
                        if (contentHeightQueue.isFull()) {
                            contentHeightSet.clear();
                            contentHeightSet.addAll(contentHeightQueue.getList());
                            if (contentHeightSet.size() == 1) {
                                AdViewUtils.setWebViewScale(webView, webViewHeight, webViewContentHeight);
                                return;
                            }
                        }
                        webView.postDelayed((Runnable)this, 100L);
                    } else {
                        AdViewUtils.setWebViewScale(webView, webViewHeight, webViewContentHeight);
                    }
                }
            }
        });
    }

    static void setWebViewScale(WebView webView, float webViewHeight, int webViewContentHeight) {
        int scale = (int)(webViewHeight / (float)webViewContentHeight * 100.0f + 1.0f);
        LogUtil.d("fixZoomIn WB Height:" + webViewHeight + " getContentHeight:" + webViewContentHeight + " scale:" + scale);
        webView.setInitialScale(scale);
    }

    static void warnAndTriggerFailure(Set<Pair<WebView, PbFindSizeError>> webViewErrorSet, PbFindSizeListener handler) {
        AdViewUtils.warnAndTriggerFailure(PbFindSizeErrorFactory.getCompositeFailureError(webViewErrorSet), handler);
    }

    static void warnAndTriggerFailure(PbFindSizeError error, PbFindSizeListener handler) {
        String description = error.getDescription();
        LogUtil.w(description);
        handler.failure(error);
    }

    @Nullable
    static void recursivelyFindWebViewList(@Nullable View view, List<WebView> webViewList) {
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            if (viewGroup instanceof WebView) {
                WebView webView = (WebView)viewGroup;
                webViewList.add(webView);
            } else {
                for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                    AdViewUtils.recursivelyFindWebViewList(viewGroup.getChildAt(i), webViewList);
                }
            }
        }
    }

    static void findSizeInWebViewListAsync(@Size(min=1L) List<WebView> webViewList, PbFindSizeListener handler) {
        int currentAndroidApi = Build.VERSION.SDK_INT;
        int necessaryAndroidApi = 19;
        if (currentAndroidApi >= necessaryAndroidApi) {
            LogUtil.d("webViewList size:" + webViewList.size());
            int lastIndex = webViewList.size() - 1;
            AdViewUtils.iterateWebViewListAsync(webViewList, lastIndex, handler);
        } else {
            AdViewUtils.warnAndTriggerFailure(PbFindSizeErrorFactory.getUnsupportedAndroidIpiError(currentAndroidApi, necessaryAndroidApi), handler);
        }
    }

    @TargetApi(value=19)
    static void iterateWebViewListAsync(final @Size(min=1L) List<WebView> webViewList, final int index, final PbFindSizeListener handler) {
        final WebView webView = webViewList.get(index);
        webView.evaluateJavascript(INNER_HTML_SCRIPT, (ValueCallback)new ValueCallback<String>(){
            private Set<Pair<WebView, PbFindSizeError>> errorSet = new LinkedHashSet<Pair<WebView, PbFindSizeError>>();

            private void processNextWebViewOrFail(PbFindSizeError error) {
                this.errorSet.add(new Pair<WebView, PbFindSizeError>(webView, error));
                int nextIndex = index - 1;
                if (nextIndex >= 0) {
                    AdViewUtils.iterateWebViewListAsync((List<WebView>)webViewList, nextIndex, handler);
                } else {
                    AdViewUtils.warnAndTriggerFailure(this.errorSet, handler);
                }
            }

            public void onReceiveValue(@Nullable String html) {
                Pair<Pair<Integer, Integer>, PbFindSizeError> pair = AdViewUtils.findSizeInHtml(html);
                Pair size = (Pair)pair.first;
                PbFindSizeError error = (PbFindSizeError)pair.second;
                if (size != null) {
                    AdViewUtils.triggerSuccess(webView, size, handler);
                } else {
                    this.processNextWebViewOrFail(error);
                }
            }
        });
    }

    static void iterateWebViewListAsync(final List<WebView> webViewList, final int index, final PrebidNativeAdListener listener) {
        WebView webView = webViewList.get(index);
        if (Build.VERSION.SDK_INT >= 19) {
            webView.evaluateJavascript(INNER_HTML_SCRIPT, (ValueCallback)new ValueCallback<String>(){

                private void processNextWebView() {
                    int nextIndex = index - 1;
                    if (nextIndex >= 0) {
                        AdViewUtils.iterateWebViewListAsync((List<WebView>)webViewList, nextIndex, listener);
                    } else {
                        listener.onPrebidNativeNotFound();
                    }
                }

                public void onReceiveValue(@Nullable String html) {
                    Pattern prebidPattern = Pattern.compile("\\%\\%Prebid\\%\\%.*\\%\\%Prebid\\%\\%");
                    Matcher m = prebidPattern.matcher(html);
                    if (m.find()) {
                        PrebidNativeAd ad;
                        String s = m.group();
                        String[] results = s.split("%%");
                        String cacheId = results[2];
                        if (CacheManager.isValid(cacheId) && (ad = AdViewUtils.createPrebidNativeAd(cacheId, listener)) != null) {
                            listener.onPrebidNativeLoaded(ad);
                            return;
                        }
                        listener.onPrebidNativeNotValid();
                    } else {
                        this.processNextWebView();
                    }
                }
            });
        } else if (listener != null) {
            listener.onPrebidNativeNotFound();
        }
    }

    private static PrebidNativeAd createPrebidNativeAd(String cacheId, PrebidNativeAdListener listener) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.prebid.mobile.PrebidNativeAd");
            Method method = clazz.getDeclaredMethod("create", String.class);
            method.setAccessible(true);
            return (PrebidNativeAd)method.invoke(null, cacheId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @NonNull
    static Pair<Pair<Integer, Integer>, PbFindSizeError> findSizeInHtml(@Nullable String html) {
        if (TextUtils.isEmpty((CharSequence)html)) {
            return new Pair<Object, PbFindSizeError>(null, PbFindSizeErrorFactory.NO_HTML);
        }
        String hbSizeObject = AdViewUtils.findHbSizeObject(html);
        if (hbSizeObject == null) {
            return new Pair<Object, PbFindSizeError>(null, PbFindSizeErrorFactory.NO_SIZE_OBJECT);
        }
        String hbSizeValue = AdViewUtils.findHbSizeValue(hbSizeObject);
        if (hbSizeValue == null) {
            return new Pair<Object, PbFindSizeError>(null, PbFindSizeErrorFactory.NO_SIZE_VALUE);
        }
        Pair<Integer, Integer> size = AdViewUtils.stringToSize(hbSizeValue);
        if (size == null) {
            return new Pair<Object, PbFindSizeError>(null, PbFindSizeErrorFactory.SIZE_UNPARSED);
        }
        return new Pair<Pair<Integer, Integer>, Object>(size, null);
    }

    @Nullable
    static String findHbSizeObject(String text) {
        return AdViewUtils.matchAndCheck(SIZE_OBJECT_REGEX_EXPRESSION, text);
    }

    @Nullable
    static String findHbSizeValue(String text) {
        return AdViewUtils.matchAndCheck(SIZE_VALUE_REGEX_EXPRESSION, text);
    }

    @NonNull
    static String[] matches(String regex, String text) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(text);
        ArrayList<String> allMatches = new ArrayList<String>();
        while (matcher.find()) {
            allMatches.add(matcher.group());
        }
        return allMatches.toArray(new String[0]);
    }

    @Nullable
    static String matchAndCheck(String regex, String text) {
        String[] matched = AdViewUtils.matches(regex, text);
        if (matched.length == 0) {
            return null;
        }
        String firstResult = matched[0];
        return firstResult;
    }

    @Nullable
    static Pair<Integer, Integer> stringToSize(String size) {
        int height;
        int width;
        String[] sizeArr = size.split("x");
        if (sizeArr.length != 2) {
            LogUtil.w(size + " has a wrong format");
            return null;
        }
        String widthString = sizeArr[0];
        String heightString = sizeArr[1];
        try {
            width = Integer.parseInt(widthString);
        }
        catch (NumberFormatException e) {
            LogUtil.w(size + "can not be converted to Size");
            return null;
        }
        try {
            height = Integer.parseInt(heightString);
        }
        catch (NumberFormatException e) {
            LogUtil.w(size + "can not be converted to Size");
            return null;
        }
        return new Pair<Integer, Integer>(width, height);
    }

    public static void findNative(@NonNull Object object, @NonNull PrebidNativeAdListener listener) {
        String objectClassName = object.getClass().getCanonicalName();
        if (GAM_VIEW_CLASS.equals(objectClassName) || GAM_VIEW_CLASS_2.equals(objectClassName)) {
            View adView = (View)object;
            AdViewUtils.findNativeInGAMPublisherAdView(adView, listener);
        } else if (MOPUB_NATIVE_AD_CLASS.equals(objectClassName)) {
            AdViewUtils.findNativeInMoPubNativeAd(object, listener);
        } else if (AdViewUtils.implementsInterface(object, GAM_CUSTOM_TEMPLATE_AD_CLASS) || AdViewUtils.implementsInterface(object, GAM_CUSTOM_TEMPLATE_AD_CLASS_2)) {
            AdViewUtils.findNativeInGAMCustomTemplateAd(object, listener);
        } else {
            listener.onPrebidNativeNotFound();
        }
    }

    private static boolean implementsInterface(@NonNull Object object, @NonNull String interfaceName) {
        for (Class<?> c : object.getClass().getInterfaces()) {
            LogUtil.d("Prebid", c.getCanonicalName());
            if (!c.getCanonicalName().equals(interfaceName)) continue;
            return true;
        }
        return false;
    }

    private static void findNativeInGAMCustomTemplateAd(@NonNull Object object, @NonNull PrebidNativeAdListener listener) {
        String isPrebid = (String)AdViewUtils.callMethodOnObject(object, "getText", "isPrebid");
        if ("1".equals(isPrebid)) {
            String cacheId = (String)AdViewUtils.callMethodOnObject(object, "getText", "hb_cache_id_local");
            PrebidNativeAd ad = AdViewUtils.createPrebidNativeAd(cacheId, listener);
            if (ad != null) {
                listener.onPrebidNativeLoaded(ad);
            } else {
                listener.onPrebidNativeNotValid();
            }
        } else {
            listener.onPrebidNativeNotFound();
        }
    }

    private static void findNativeInMoPubNativeAd(@NonNull Object object, @NonNull PrebidNativeAdListener listener) {
        Object baseNativeAd = AdViewUtils.callMethodOnObject(object, "getBaseNativeAd", new Object[0]);
        LogUtil.d("Prebid", "" + baseNativeAd);
        Boolean isPrebid = (Boolean)AdViewUtils.callMethodOnObject(baseNativeAd, "getExtra", "isPrebid");
        if (isPrebid != null && isPrebid.booleanValue()) {
            String cacheId = (String)AdViewUtils.callMethodOnObject(baseNativeAd, "getExtra", "hb_cache_id_local");
            if (CacheManager.isValid(cacheId)) {
                PrebidNativeAd ad = AdViewUtils.createPrebidNativeAd(cacheId, listener);
                if (ad != null) {
                    listener.onPrebidNativeLoaded(ad);
                    return;
                }
            } else {
                listener.onPrebidNativeNotValid();
            }
        } else {
            listener.onPrebidNativeNotFound();
        }
    }

    private static void findNativeInGAMPublisherAdView(@NonNull View adView, @NonNull PrebidNativeAdListener listener) {
        ArrayList<WebView> webViewList = new ArrayList<WebView>();
        AdViewUtils.recursivelyFindWebViewList(adView, webViewList);
        if (webViewList.size() == 0) {
            listener.onPrebidNativeNotFound();
        } else {
            AdViewUtils.iterateWebViewListAsync(webViewList, webViewList.size() - 1, listener);
        }
    }

    static Object callMethodOnObject(Object object, String methodName, Object ... params) {
        try {
            int len = params.length;
            Class[] classes = new Class[len];
            for (int i = 0; i < len; ++i) {
                classes[i] = params[i].getClass();
            }
            Method method = object.getClass().getMethod(methodName, classes);
            return method.invoke(object, params);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static interface PbFindSizeListener {
        public void success(int var1, int var2);

        public void failure(@NonNull PbFindSizeError var1);
    }
}

