/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.prebid.mobile.ExternalUserId;
import org.prebid.mobile.LogUtil;
import org.prebid.mobile.PbContextNullException;
import org.prebid.mobile.PrebidMobile;
import org.prebid.mobile.StorageUtils;
import org.prebid.mobile.Util;

public class TargetingParams {
    private static int yob = 0;
    private static GENDER gender = GENDER.UNKNOWN;
    private static String domain = "";
    private static String storeUrl = "";
    private static String bundleName = null;
    public static final String BIDDER_NAME_APP_NEXUS = "appnexus";
    public static final String BIDDER_NAME_RUBICON_PROJECT = "rubicon";
    private static final Set<String> accessControlList = new HashSet<String>();
    private static final Map<String, Set<String>> userDataMap = new HashMap<String, Set<String>>();
    private static final Set<String> userKeywordsSet = new HashSet<String>();
    private static final Map<String, Set<String>> contextDataDictionary = new HashMap<String, Set<String>>();
    private static final Set<String> contextKeywordsSet = new HashSet<String>();
    @Nullable
    private static String omidPartnerName;
    @Nullable
    private static String omidPartnerVersion;

    private TargetingParams() {
    }

    public static boolean isSubjectToCOPPA() {
        try {
            return StorageUtils.getPbCoppa();
        }
        catch (PbContextNullException ex) {
            LogUtil.e("Targeting", "can not get COPPA", ex);
            return false;
        }
    }

    public static void setSubjectToCOPPA(boolean isCoppa) {
        try {
            StorageUtils.setPbCoppa(isCoppa);
        }
        catch (PbContextNullException ex) {
            LogUtil.e("Targeting", "Coppa was not updated", ex);
        }
    }

    @Nullable
    public static Boolean isSubjectToGDPR() {
        Boolean gdprSubject = null;
        try {
            Boolean pbGdpr = StorageUtils.getPbGdprSubject();
            if (pbGdpr != null) {
                gdprSubject = pbGdpr;
            } else {
                Boolean iabGdpr = StorageUtils.getIabGdprSubject();
                if (iabGdpr != null) {
                    gdprSubject = iabGdpr;
                }
            }
        }
        catch (PbContextNullException ex) {
            LogUtil.e("Targeting", "can not get GDPR Subject", ex);
        }
        return gdprSubject;
    }

    public static void setSubjectToGDPR(@Nullable Boolean consent) {
        try {
            StorageUtils.setPbGdprSubject(consent);
        }
        catch (PbContextNullException ex) {
            LogUtil.e("Targeting", "GDPR Subject was not updated", ex);
        }
    }

    @Nullable
    public static String getGDPRConsentString() {
        String gdprConsent = null;
        try {
            String iabGdprConsent = StorageUtils.getIabGdprConsent();
            if (!TextUtils.isEmpty((CharSequence)iabGdprConsent)) {
                gdprConsent = iabGdprConsent;
            } else {
                String pbGdprConsent = StorageUtils.getPbGdprConsent();
                if (!TextUtils.isEmpty((CharSequence)pbGdprConsent)) {
                    gdprConsent = pbGdprConsent;
                }
            }
        }
        catch (PbContextNullException ex) {
            LogUtil.e("Targeting", "can not get GDPR Consent", ex);
        }
        return gdprConsent;
    }

    public static void setGDPRConsentString(@Nullable String string) {
        try {
            StorageUtils.setPbGdprConsent(string);
        }
        catch (PbContextNullException ex) {
            LogUtil.e("Targeting", "GDPR Consent was not updated", ex);
        }
    }

    public static void setPurposeConsents(@Nullable String purposeConsents) {
        try {
            StorageUtils.setPbPurposeConsents(purposeConsents);
        }
        catch (PbContextNullException ex) {
            LogUtil.e("Targeting", "GDPR Device access Consent was not updated", ex);
        }
    }

    public static String getPurposeConsents() {
        String savedPurposeConsents = null;
        try {
            String iabPurposeConsentsString = StorageUtils.getIabPurposeConsents();
            if (iabPurposeConsentsString != null) {
                savedPurposeConsents = iabPurposeConsentsString;
            } else {
                String pbPurposeConsentsString = StorageUtils.getPbPurposeConsents();
                if (pbPurposeConsentsString != null) {
                    savedPurposeConsents = pbPurposeConsentsString;
                }
            }
        }
        catch (PbContextNullException ex) {
            LogUtil.e("Targeting", "GDPR Device access Consent was not updated", ex);
        }
        return savedPurposeConsents;
    }

    public static List<ExternalUserId> fetchStoredExternalUserIds() {
        return StorageUtils.fetchStoredExternalUserIds();
    }

    public static ExternalUserId fetchStoredExternalUserId(@NonNull String source) {
        if (!TextUtils.isEmpty((CharSequence)source)) {
            return StorageUtils.fetchStoredExternalUserId(source);
        }
        return null;
    }

    public static void removeStoredExternalUserId(@NonNull String source) {
        if (!TextUtils.isEmpty((CharSequence)source)) {
            StorageUtils.removeStoredExternalUserId(source);
        }
    }

    public static void storeExternalUserId(ExternalUserId externalUserId) {
        if (externalUserId != null) {
            StorageUtils.storeExternalUserId(externalUserId);
        } else {
            LogUtil.e("Targeting", "External User ID can't be set as null");
        }
    }

    public static void clearStoredExternalUserIds() {
        StorageUtils.clearStoredExternalUserIds();
    }

    @Nullable
    public static Boolean getDeviceAccessConsent() {
        Boolean deviceAccessConsent = null;
        try {
            int deviceAccessConsentIndex = 0;
            deviceAccessConsent = TargetingParams.getPurposeConsent(deviceAccessConsentIndex);
        }
        catch (PbContextNullException ex) {
            LogUtil.e("Targeting", "cannot get Device access Consent", ex);
        }
        return deviceAccessConsent;
    }

    static Boolean getPurposeConsent(int index) {
        Boolean purposeConsent = null;
        String purposeConsents = TargetingParams.getPurposeConsents();
        if (purposeConsents != null) {
            char purposeConsentChar = purposeConsents.charAt(index);
            if (purposeConsentChar == '1') {
                purposeConsent = true;
            } else if (purposeConsentChar == '0') {
                purposeConsent = false;
            } else {
                LogUtil.w("invalid char:" + purposeConsent);
            }
        }
        return purposeConsent;
    }

    public static int getYearOfBirth() {
        return yob;
    }

    public static void setYearOfBirth(int yob) throws Exception {
        if (yob < 1900 || yob >= Calendar.getInstance().get(1)) {
            throw new Exception("Year of birth must be between 1900 and " + Calendar.getInstance().get(1));
        }
        TargetingParams.yob = yob;
    }

    public static GENDER getGender() {
        return gender;
    }

    public static void setGender(GENDER gender) {
        TargetingParams.gender = gender;
    }

    public static synchronized String getBundleName() {
        Context context;
        if (TextUtils.isEmpty((CharSequence)bundleName) && (context = PrebidMobile.getApplicationContext()) != null) {
            return context.getPackageName();
        }
        return bundleName;
    }

    public static synchronized void setBundleName(String bundleName) {
        TargetingParams.bundleName = bundleName;
    }

    public static synchronized void setDomain(String domain) {
        TargetingParams.domain = domain;
    }

    public static synchronized String getDomain() {
        return domain;
    }

    public static synchronized void setStoreUrl(String storeUrl) {
        TargetingParams.storeUrl = storeUrl;
    }

    public static synchronized String getStoreUrl() {
        return storeUrl;
    }

    public static void addBidderToAccessControlList(String bidderName) {
        accessControlList.add(bidderName);
    }

    public static void removeBidderFromAccessControlList(String bidderName) {
        accessControlList.remove(bidderName);
    }

    public static void clearAccessControlList() {
        accessControlList.clear();
    }

    static Set<String> getAccessControlList() {
        return accessControlList;
    }

    public static void addUserData(String key, String value) {
        Util.addValue(userDataMap, key, value);
    }

    public static void updateUserData(String key, Set<String> value) {
        userDataMap.put(key, value);
    }

    public static void removeUserData(String key) {
        userDataMap.remove(key);
    }

    public static void clearUserData() {
        userDataMap.clear();
    }

    static Map<String, Set<String>> getUserDataDictionary() {
        return userDataMap;
    }

    public static void addUserKeyword(String keyword) {
        userKeywordsSet.add(keyword);
    }

    public static void addUserKeywords(Set<String> keywords) {
        userKeywordsSet.addAll(keywords);
    }

    public static void removeUserKeyword(String keyword) {
        userKeywordsSet.remove(keyword);
    }

    public static void clearUserKeywords() {
        userKeywordsSet.clear();
    }

    static Set<String> getUserKeywordsSet() {
        return userKeywordsSet;
    }

    public static void addContextData(String key, String value) {
        Util.addValue(contextDataDictionary, key, value);
    }

    public static void updateContextData(String key, Set<String> value) {
        contextDataDictionary.put(key, value);
    }

    public static void removeContextData(String key) {
        contextDataDictionary.remove(key);
    }

    public static void clearContextData() {
        contextDataDictionary.clear();
    }

    static Map<String, Set<String>> getContextDataDictionary() {
        return contextDataDictionary;
    }

    public static void addContextKeyword(String keyword) {
        contextKeywordsSet.add(keyword);
    }

    public static void addContextKeywords(Set<String> keywords) {
        contextKeywordsSet.addAll(keywords);
    }

    public static void removeContextKeyword(String keyword) {
        contextKeywordsSet.remove(keyword);
    }

    public static void clearContextKeywords() {
        contextKeywordsSet.clear();
    }

    static Set<String> getContextKeywordsSet() {
        return contextKeywordsSet;
    }

    @Nullable
    public static String getOmidPartnerName() {
        return omidPartnerName;
    }

    public static void setOmidPartnerName(@Nullable String omidPartnerName) {
        TargetingParams.omidPartnerName = omidPartnerName;
    }

    @Nullable
    public static String getOmidPartnerVersion() {
        return omidPartnerVersion;
    }

    public static void setOmidPartnerVersion(@Nullable String omidPartnerVersion) {
        TargetingParams.omidPartnerVersion = omidPartnerVersion;
    }

    public static enum GENDER {
        FEMALE,
        MALE,
        UNKNOWN;

    }
}

