/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;
import org.prebid.mobile.ExternalUserId;
import org.prebid.mobile.PbContextNullException;
import org.prebid.mobile.PrebidMobile;

final class StorageUtils {
    static final String PB_COPPAKey = "Prebid_COPPA";
    static final String PBConsent_SubjectToGDPRKey = "Prebid_GDPR";
    static final String PBConsent_ConsentStringKey = "Prebid_GDPR_consent_strings";
    static final String PBConsent_PurposeConsents = "Prebid_GDPR_PurposeConsents";
    static final String IABConsent_SubjectToGDPRKey = "IABConsent_SubjectToGDPR";
    static final String IABConsent_ConsentStringKey = "IABConsent_ConsentString";
    static final String IABTCF_CONSENT_STRING = "IABTCF_TCString";
    static final String IABTCF_SUBJECT_TO_GDPR = "IABTCF_gdprApplies";
    static final String IABTCF_PurposeConsents = "IABTCF_PurposeConsents";
    static final String IABUSPrivacy_StringKey = "IABUSPrivacy_String";
    static final String PB_ExternalUserIdsKey = "PB_ExternalUserIdsKey";

    private StorageUtils() {
    }

    static boolean getPbCoppa() throws PbContextNullException {
        SharedPreferences pref = StorageUtils.getSharedPreferences();
        return pref.getBoolean(PB_COPPAKey, false);
    }

    static void setPbCoppa(boolean value) throws PbContextNullException {
        SharedPreferences pref = StorageUtils.getSharedPreferences();
        SharedPreferences.Editor editor = pref.edit();
        editor.putBoolean(PB_COPPAKey, value);
        editor.apply();
    }

    @Nullable
    static Boolean getPbGdprSubject() throws PbContextNullException {
        if (!StorageUtils.checkSharedPreferencesKey(PBConsent_SubjectToGDPRKey)) {
            return null;
        }
        SharedPreferences pref = StorageUtils.getSharedPreferences();
        return pref.getBoolean(PBConsent_SubjectToGDPRKey, false);
    }

    static void setPbGdprSubject(@Nullable Boolean value) throws PbContextNullException {
        SharedPreferences pref = StorageUtils.getSharedPreferences();
        SharedPreferences.Editor editor = pref.edit();
        if (value != null) {
            editor.putBoolean(PBConsent_SubjectToGDPRKey, value.booleanValue());
        } else {
            editor.remove(PBConsent_SubjectToGDPRKey);
        }
        editor.apply();
    }

    @Nullable
    static Boolean getIabGdprSubject() throws PbContextNullException {
        int gdprSubjectTcf2Default;
        Boolean gdprSubject = null;
        SharedPreferences pref = StorageUtils.getSharedPreferences();
        int gdprSubjectTcf2 = pref.getInt(IABTCF_SUBJECT_TO_GDPR, gdprSubjectTcf2Default = -1);
        if (gdprSubjectTcf2 != gdprSubjectTcf2Default) {
            if (gdprSubjectTcf2 == 1) {
                gdprSubject = true;
            } else if (gdprSubjectTcf2 == 0) {
                gdprSubject = false;
            }
        } else {
            String gdprSubjectTcf1 = pref.getString(IABConsent_SubjectToGDPRKey, null);
            if (gdprSubjectTcf1 != null) {
                if ("1".equals(gdprSubjectTcf1)) {
                    return true;
                }
                if ("0".equals(gdprSubjectTcf1)) {
                    return false;
                }
            }
        }
        return gdprSubject;
    }

    static String getPbGdprConsent() throws PbContextNullException {
        SharedPreferences pref = StorageUtils.getSharedPreferences();
        return pref.getString(PBConsent_ConsentStringKey, null);
    }

    static void setPbGdprConsent(@Nullable String value) throws PbContextNullException {
        SharedPreferences pref = StorageUtils.getSharedPreferences();
        SharedPreferences.Editor editor = pref.edit();
        if (value != null) {
            editor.putString(PBConsent_ConsentStringKey, value);
        } else {
            editor.remove(PBConsent_ConsentStringKey);
        }
        editor.apply();
    }

    @Nullable
    static String getIabGdprConsent() throws PbContextNullException {
        SharedPreferences pref = StorageUtils.getSharedPreferences();
        String gdprConsent = pref.getString(IABTCF_CONSENT_STRING, null);
        if (gdprConsent == null) {
            gdprConsent = pref.getString(IABConsent_ConsentStringKey, null);
        }
        return gdprConsent;
    }

    static void storeExternalUserId(ExternalUserId externalUserId) {
        StorageUtils.removeStoredExternalUserId(externalUserId.getSource());
        SharedPreferences pref = StorageUtils.getSharedPreferences();
        String externalUserIdString = pref.getString(PB_ExternalUserIdsKey, null);
        List<ExternalUserId> externalUidListFromJson = !TextUtils.isEmpty((CharSequence)externalUserIdString) ? ExternalUserId.getExternalUidListFromJson(externalUserIdString) : new ArrayList<ExternalUserId>();
        externalUidListFromJson.add(externalUserId);
        SharedPreferences.Editor editor = pref.edit();
        if (externalUserId != null) {
            editor.putString(PB_ExternalUserIdsKey, externalUidListFromJson.toString());
        }
        editor.apply();
    }

    static List<ExternalUserId> fetchStoredExternalUserIds() {
        SharedPreferences pref = StorageUtils.getSharedPreferences();
        String externalUserIds = pref.getString(PB_ExternalUserIdsKey, null);
        if (externalUserIds != null) {
            return ExternalUserId.getExternalUidListFromJson(externalUserIds);
        }
        return null;
    }

    static ExternalUserId fetchStoredExternalUserId(String source) {
        SharedPreferences pref = StorageUtils.getSharedPreferences();
        String externalUserIds = pref.getString(PB_ExternalUserIdsKey, null);
        if (!TextUtils.isEmpty((CharSequence)externalUserIds)) {
            List<ExternalUserId> externalUidListFromJson = ExternalUserId.getExternalUidListFromJson(externalUserIds);
            for (ExternalUserId externalUserId : externalUidListFromJson) {
                if (!externalUserId.getSource().equals(source)) continue;
                return externalUserId;
            }
        }
        return null;
    }

    static void removeStoredExternalUserId(String source) {
        SharedPreferences pref = StorageUtils.getSharedPreferences();
        String externalUserIds = pref.getString(PB_ExternalUserIdsKey, null);
        if (!TextUtils.isEmpty((CharSequence)externalUserIds)) {
            List<ExternalUserId> externalUidListFromJson = ExternalUserId.getExternalUidListFromJson(externalUserIds);
            ExternalUserId toBeRemoved = null;
            for (ExternalUserId externalUserId : externalUidListFromJson) {
                if (!externalUserId.getSource().equals(source)) continue;
                toBeRemoved = externalUserId;
                break;
            }
            if (toBeRemoved != null) {
                externalUidListFromJson.remove(toBeRemoved);
                if (externalUidListFromJson.isEmpty()) {
                    StorageUtils.clearStoredExternalUserIds();
                } else {
                    SharedPreferences.Editor editor = pref.edit();
                    editor.putString(PB_ExternalUserIdsKey, externalUidListFromJson.toString());
                    editor.apply();
                }
            }
        }
    }

    static void clearStoredExternalUserIds() {
        if (StorageUtils.fetchStoredExternalUserIds() != null) {
            SharedPreferences pref = StorageUtils.getSharedPreferences();
            SharedPreferences.Editor editor = pref.edit();
            editor.remove(PB_ExternalUserIdsKey);
            editor.apply();
        }
    }

    static void setPbPurposeConsents(@Nullable String purposeConsents) throws PbContextNullException {
        SharedPreferences pref = StorageUtils.getSharedPreferences();
        SharedPreferences.Editor editor = pref.edit();
        String key = PBConsent_PurposeConsents;
        if (purposeConsents != null) {
            editor.putString(key, purposeConsents);
        } else {
            editor.remove(key);
        }
        editor.apply();
    }

    @Nullable
    static String getPbPurposeConsents() {
        SharedPreferences pref = StorageUtils.getSharedPreferences();
        return pref.getString(PBConsent_PurposeConsents, null);
    }

    @Nullable
    static String getIabPurposeConsents() {
        SharedPreferences pref = StorageUtils.getSharedPreferences();
        return pref.getString(IABTCF_PurposeConsents, null);
    }

    @Nullable
    static String getIabCcpa() throws PbContextNullException {
        SharedPreferences pref = StorageUtils.getSharedPreferences();
        return pref.getString(IABUSPrivacy_StringKey, null);
    }

    private static SharedPreferences getSharedPreferences() throws PbContextNullException {
        Context context = PrebidMobile.getApplicationContext();
        if (context == null) {
            throw new PbContextNullException("Context is null.");
        }
        return PreferenceManager.getDefaultSharedPreferences((Context)context);
    }

    private static boolean checkSharedPreferencesKey(String key) throws PbContextNullException {
        SharedPreferences pref = StorageUtils.getSharedPreferences();
        return pref.contains(key);
    }
}

