/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Looper;
import android.widget.ImageView;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import org.prebid.mobile.LogUtil;
import org.prebid.mobile.tasksmanager.TasksManager;

public class DownloadImageTask {
    WeakReference<ImageView> imageRef;

    protected DownloadImageTask(ImageView image) {
        this.imageRef = new WeakReference<ImageView>(image);
    }

    protected void execute(final String url) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            TasksManager.getInstance().executeOnBackgroundThread(new Runnable(){

                @Override
                public void run() {
                    DownloadImageTask.this.fetchAndProcessImage(url);
                }
            });
        } else {
            this.fetchAndProcessImage(url);
        }
    }

    private void fetchAndProcessImage(String url) {
        Bitmap bitmap = null;
        try {
            InputStream in = new URL(url).openStream();
            bitmap = BitmapFactory.decodeStream((InputStream)in);
        }
        catch (Exception e) {
            LogUtil.e("Error", e.getMessage());
        }
        this.processImage(bitmap);
    }

    private void processImage(final Bitmap result) {
        TasksManager.getInstance().executeOnMainThread(new Runnable(){

            @Override
            public void run() {
                ImageView image = (ImageView)DownloadImageTask.this.imageRef.get();
                if (image != null) {
                    image.setImageBitmap(result);
                }
            }
        });
    }
}

