/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile;

import android.os.Handler;
import android.os.HandlerThread;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import java.util.HashMap;
import java.util.UUID;
import org.prebid.mobile.DemandAdapter;
import org.prebid.mobile.LogUtil;
import org.prebid.mobile.OnCompleteListener;
import org.prebid.mobile.PrebidServerAdapter;
import org.prebid.mobile.RequestParams;
import org.prebid.mobile.ResultCode;
import org.prebid.mobile.Util;
import org.prebid.mobile.tasksmanager.TasksManager;

class DemandFetcher {
    private STATE state = STATE.STOPPED;
    private int periodMillis = 0;
    private Object adObject;
    private OnCompleteListener listener;
    private Handler fetcherHandler;
    private RequestRunnable requestRunnable;
    private long lastFetchTime = -1L;
    private long timePausedAt = -1L;
    private RequestParams requestParams;

    DemandFetcher(@NonNull Object adObj) {
        this.adObject = adObj;
        HandlerThread fetcherThread = new HandlerThread("FetcherThread");
        fetcherThread.start();
        this.fetcherHandler = new Handler(fetcherThread.getLooper());
        this.requestRunnable = new RequestRunnable();
    }

    void setListener(OnCompleteListener listener) {
        this.listener = listener;
    }

    void setRequestParams(RequestParams requestParams) {
        this.requestParams = requestParams;
    }

    void setPeriodMillis(int periodMillis) {
        boolean periodChanged = this.periodMillis != periodMillis;
        this.periodMillis = periodMillis;
        if (periodChanged && !this.state.equals((Object)STATE.STOPPED)) {
            this.stop();
            this.start();
        }
    }

    private void stop() {
        this.requestRunnable.cancelRequest();
        this.fetcherHandler.removeCallbacks((Runnable)this.requestRunnable);
        this.timePausedAt = System.currentTimeMillis();
        this.state = STATE.STOPPED;
    }

    void start() {
        switch (this.state) {
            case STOPPED: {
                if (this.periodMillis <= 0) {
                    this.fetcherHandler.post((Runnable)this.requestRunnable);
                } else {
                    int msPeriod = this.periodMillis;
                    long stall = this.timePausedAt != -1L && this.lastFetchTime != -1L ? Math.min((long)msPeriod, Math.max(0L, (long)msPeriod - (this.timePausedAt - this.lastFetchTime))) : 0L;
                    this.fetcherHandler.postDelayed((Runnable)this.requestRunnable, stall * 1000L);
                }
                this.state = STATE.RUNNING;
                break;
            }
            case RUNNING: {
                if (this.periodMillis > 0) break;
                this.fetcherHandler.post((Runnable)this.requestRunnable);
                break;
            }
        }
    }

    void destroy() {
        if (this.state != STATE.DESTROYED) {
            this.adObject = null;
            this.listener = null;
            this.requestRunnable.cancelRequest();
            this.requestRunnable.destroy();
            this.fetcherHandler.removeCallbacks((Runnable)this.requestRunnable);
            if (this.fetcherHandler.getLooper() != null) {
                this.fetcherHandler.getLooper().quit();
            }
            this.requestRunnable = null;
            this.state = STATE.DESTROYED;
        }
    }

    @MainThread
    private void notifyListener(final ResultCode resultCode) {
        LogUtil.d("notifyListener:" + (Object)((Object)resultCode));
        if (this.listener != null) {
            TasksManager.getInstance().executeOnMainThread(new Runnable(){

                @Override
                public void run() {
                    if (DemandFetcher.this.listener != null) {
                        DemandFetcher.this.listener.onComplete(resultCode);
                    }
                    if (DemandFetcher.this.periodMillis <= 0) {
                        DemandFetcher.this.destroy();
                    }
                }
            });
        }
    }

    @VisibleForTesting
    Handler getHandler() {
        return this.fetcherHandler;
    }

    @VisibleForTesting
    Handler getDemandHandler() {
        RequestRunnable runnable = this.requestRunnable;
        return runnable.demandHandler;
    }

    class RequestRunnable
    implements Runnable {
        private DemandAdapter demandAdapter;
        private String auctionId;
        private Handler demandHandler;

        RequestRunnable() {
            HandlerThread demandThread = new HandlerThread("DemandThread");
            demandThread.start();
            this.demandHandler = new Handler(demandThread.getLooper());
            this.demandAdapter = new PrebidServerAdapter();
            this.auctionId = UUID.randomUUID().toString();
        }

        void cancelRequest() {
            this.demandAdapter.stopRequest(this.auctionId);
        }

        void destroy() {
            this.cancelRequest();
            this.demandHandler.removeCallbacksAndMessages(null);
            if (this.demandHandler.getLooper() != null) {
                this.demandHandler.getLooper().quit();
            }
        }

        @Override
        public void run() {
            this.auctionId = UUID.randomUUID().toString();
            DemandFetcher.this.lastFetchTime = System.currentTimeMillis();
            this.demandHandler.post(new Runnable(){

                @Override
                public void run() {
                    RequestRunnable.this.demandAdapter.requestDemand(DemandFetcher.this.requestParams, new DemandAdapter.DemandAdapterListener(){

                        @Override
                        @MainThread
                        public void onDemandReady(HashMap<String, String> demand, String auctionId) {
                            if (RequestRunnable.this.auctionId.equals(auctionId)) {
                                Util.apply(demand, DemandFetcher.this.adObject);
                                LogUtil.i("Successfully set the following keywords: " + demand.toString());
                                DemandFetcher.this.notifyListener(ResultCode.SUCCESS);
                            }
                        }

                        @Override
                        @MainThread
                        public void onDemandFailed(ResultCode resultCode, String auctionId) {
                            if (RequestRunnable.this.auctionId.equals(auctionId)) {
                                Util.apply(null, DemandFetcher.this.adObject);
                                LogUtil.i("Removed all used keywords from the ad object");
                                DemandFetcher.this.notifyListener(resultCode);
                            }
                        }
                    }, RequestRunnable.this.auctionId);
                }
            });
            if (DemandFetcher.this.periodMillis > 0) {
                DemandFetcher.this.fetcherHandler.postDelayed((Runnable)this, (long)DemandFetcher.this.periodMillis);
            }
        }
    }

    static enum STATE {
        STOPPED,
        RUNNING,
        DESTROYED;

    }
}

