/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile;

import android.os.Handler;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import java.util.HashMap;
import java.util.UUID;

public class CacheManager {
    private static final int NATIVE_AD_EXPIRY_TIMEOUT = 300000;
    private static HashMap<String, String> savedValues = new HashMap();
    private static HashMap<String, Long> expiryIntervalMap = new HashMap();
    private static HashMap<String, CacheExpiryListener> cacheExpiryListenerMap = new HashMap();
    private static Handler handler = new Handler();

    public static String save(String content) {
        if (!TextUtils.isEmpty((CharSequence)content)) {
            final String cacheId = "Prebid_" + UUID.randomUUID().toString();
            savedValues.put(cacheId, content);
            handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (cacheExpiryListenerMap.containsKey(cacheId)) {
                        ((CacheExpiryListener)cacheExpiryListenerMap.remove(cacheId)).onCacheExpired();
                    }
                    savedValues.remove(cacheId);
                }
            }, CacheManager.getExpiryInterval(cacheId));
            return cacheId;
        }
        return null;
    }

    private static long getExpiryInterval(String cacheId) {
        return expiryIntervalMap.containsKey(cacheId) ? expiryIntervalMap.get(cacheId) : 300000L;
    }

    public static boolean isValid(String cacheId) {
        return savedValues.keySet().contains(cacheId);
    }

    @VisibleForTesting
    public static void clear() {
        savedValues.clear();
        cacheExpiryListenerMap.clear();
        expiryIntervalMap.clear();
    }

    protected static String get(String cacheId) {
        return savedValues.remove(cacheId);
    }

    protected static void registerCacheExpiryListener(String cacheId, CacheExpiryListener expiryListener) {
        cacheExpiryListenerMap.put(cacheId, expiryListener);
    }

    public static void setExpiry(String cacheId, long exp) {
        expiryIntervalMap.put(cacheId, exp * 1000L);
    }

    static interface CacheExpiryListener {
        public void onCacheExpired();
    }
}

