/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile.tasksmanager;

import android.os.Handler;
import android.os.HandlerThread;
import androidx.annotation.VisibleForTesting;
import org.prebid.mobile.tasksmanager.CancellableExecutor;

public class BackgroundThreadExecutor
implements CancellableExecutor {
    private Handler handler;
    private boolean running = false;
    private final int HANDLER_COUNT = 3;
    private int index = 0;

    BackgroundThreadExecutor() {
        HandlerThread backgroundThread = new HandlerThread("BackgroundThread");
        backgroundThread.start();
        this.handler = new Handler(backgroundThread.getLooper());
        this.running = true;
    }

    @Override
    public void execute(Runnable runnable) {
        if (this.running) {
            this.handler.post(runnable);
        }
    }

    @Override
    public boolean cancel(Runnable runnable) {
        if (this.running) {
            this.handler.removeCallbacks(runnable);
            return true;
        }
        return false;
    }

    public void shutdown() {
        if (this.running) {
            this.handler.getLooper().quit();
            this.handler = null;
            this.running = false;
        }
    }

    public void startThread() {
        if (!this.running) {
            HandlerThread backgroundThread = new HandlerThread("BackgroundThread");
            backgroundThread.start();
            this.handler = new Handler(backgroundThread.getLooper());
            this.running = true;
        }
    }

    @VisibleForTesting
    public Handler getBackgroundHandler() {
        return this.handler;
    }
}

