/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile.http;

import android.os.Looper;
import androidx.annotation.MainThread;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;
import org.prebid.mobile.BidLog;
import org.prebid.mobile.LogUtil;
import org.prebid.mobile.PrebidMobile;
import org.prebid.mobile.ResultCode;
import org.prebid.mobile.http.NoContextException;
import org.prebid.mobile.http.TaskResult;
import org.prebid.mobile.tasksmanager.TasksManager;

public abstract class HTTPPost {
    static final String COOKIE_HEADER = "Cookie";

    public void execute() {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            TasksManager.getInstance().executeOnBackgroundThread(new Runnable(){

                @Override
                public void run() {
                    TaskResult<JSONObject> response = HTTPPost.this.makeHttpRequest();
                    HTTPPost.this.postResultOnMainThread(response);
                }
            });
        } else {
            TaskResult<JSONObject> response = this.makeHttpRequest();
            this.postResultOnMainThread(response);
        }
    }

    protected TaskResult<JSONObject> makeHttpRequest() {
        try {
            String existingCookie;
            long demandFetchStartTime = System.currentTimeMillis();
            BidLog.BidLogEntry entry = new BidLog.BidLogEntry();
            URL url = new URL(this.getUrl());
            entry.setRequestUrl(this.getUrl());
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Accept", "application/json");
            if (this.canIAccessDeviceData() && (existingCookie = this.getExistingCookie()) != null) {
                conn.setRequestProperty(COOKIE_HEADER, existingCookie);
            }
            conn.setRequestMethod("POST");
            conn.setConnectTimeout(PrebidMobile.getTimeoutMillis());
            OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream(), "UTF-8");
            JSONObject postData = this.getPostData();
            String postString = postData.toString();
            LogUtil.d("Sending request for auction " + this.getAuctionId() + " with post data: " + postString);
            wr.write(postString);
            wr.flush();
            entry.setRequestBody(postString);
            conn.connect();
            int httpResult = conn.getResponseCode();
            long demandFetchEndTime = System.currentTimeMillis();
            entry.setResponseCode(httpResult);
            if (httpResult == 200) {
                String line;
                StringBuilder builder = new StringBuilder();
                InputStream is = conn.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "utf-8"));
                while ((line = reader.readLine()) != null) {
                    builder.append(line);
                }
                reader.close();
                is.close();
                String result = builder.toString();
                entry.setResponse(result);
                JSONObject response = new JSONObject(result);
                this.httpCookieSync(conn.getHeaderFields());
                if (!this.isTimeoutMillisUpdated()) {
                    int tmaxRequest = -1;
                    try {
                        tmaxRequest = response.getJSONObject("ext").getInt("tmaxrequest");
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                    if (tmaxRequest >= 0) {
                        PrebidMobile.setTimeoutMillis(Math.min((int)(demandFetchEndTime - demandFetchStartTime) + tmaxRequest + 200, 2000));
                        this.setTimeoutMillisUpdated(true);
                    }
                }
                BidLog.getInstance().setLastEntry(entry);
                return new TaskResult<JSONObject>(response);
            }
            if (httpResult >= 400) {
                String line;
                StringBuilder builder = new StringBuilder();
                InputStream is = conn.getErrorStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "utf-8"));
                while ((line = reader.readLine()) != null) {
                    builder.append(line);
                }
                reader.close();
                is.close();
                String result = builder.toString();
                entry.setResponse(result);
                LogUtil.d("Getting response for auction " + this.getAuctionId() + ": " + result);
                Pattern storedRequestNotFound = Pattern.compile("^Invalid request: Stored Request with ID=\".*\" not found.");
                Pattern storedImpNotFound = Pattern.compile("^Invalid request: Stored Imp with ID=\".*\" not found.");
                Pattern invalidBannerSize = Pattern.compile("^Invalid request: Request imp\\[\\d\\].banner.format\\[\\d\\] must define non-zero \"h\" and \"w\" properties.");
                Pattern invalidInterstitialSize = Pattern.compile("Invalid request: Unable to set interstitial size list");
                Matcher m = storedRequestNotFound.matcher(result);
                Matcher m2 = invalidBannerSize.matcher(result);
                Matcher m3 = storedImpNotFound.matcher(result);
                Matcher m4 = invalidInterstitialSize.matcher(result);
                BidLog.getInstance().setLastEntry(entry);
                if (m.find() || result.contains("No stored request")) {
                    return new TaskResult<JSONObject>(ResultCode.INVALID_ACCOUNT_ID);
                }
                if (m3.find() || result.contains("No stored imp")) {
                    return new TaskResult<JSONObject>(ResultCode.INVALID_CONFIG_ID);
                }
                if (m2.find() || m4.find() || result.contains("Request imp[0].banner.format")) {
                    return new TaskResult<JSONObject>(ResultCode.INVALID_SIZE);
                }
                return new TaskResult<JSONObject>(ResultCode.PREBID_SERVER_ERROR);
            }
        }
        catch (MalformedURLException e) {
            return new TaskResult<JSONObject>(e);
        }
        catch (UnsupportedEncodingException e) {
            return new TaskResult<JSONObject>(e);
        }
        catch (SocketTimeoutException ex) {
            return new TaskResult<JSONObject>(ResultCode.TIMEOUT);
        }
        catch (IOException e) {
            return new TaskResult<JSONObject>(e);
        }
        catch (JSONException e) {
            return new TaskResult<JSONObject>((Exception)((Object)e));
        }
        catch (NoContextException ex) {
            return new TaskResult<JSONObject>(ResultCode.INVALID_CONTEXT);
        }
        catch (Exception e) {
            return new TaskResult<JSONObject>(e);
        }
        return new TaskResult<JSONObject>(new RuntimeException("ServerConnector exception"));
    }

    private void postResultOnMainThread(final TaskResult<JSONObject> result) {
        TasksManager.getInstance().executeOnMainThread(new Runnable(){

            @Override
            public void run() {
                HTTPPost.this.onPostExecute(result);
            }
        });
    }

    @MainThread
    protected abstract void onPostExecute(TaskResult<JSONObject> var1);

    protected abstract String getUrl();

    protected abstract void setTimeoutMillisUpdated(boolean var1);

    protected abstract boolean isTimeoutMillisUpdated();

    protected abstract String getAuctionId();

    protected abstract JSONObject getPostData() throws NoContextException;

    protected abstract boolean canIAccessDeviceData();

    protected abstract String getExistingCookie();

    protected abstract void httpCookieSync(Map<String, List<String>> var1);
}

