/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile;

import android.graphics.Rect;
import android.view.View;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.prebid.mobile.LogUtil;

class VisibilityDetector {
    static final long VISIBILITY_THROTTLE_MILLIS = 250L;
    private boolean scheduled = false;
    private View view;
    private ArrayList<VisibilityListener> listeners;
    private Runnable visibilityCheck;
    private ScheduledExecutorService tasker;
    private static final String TAG = "VisibilityDetector";
    private final int MIN_PERCENTAGE_VIEWED = 50;

    static VisibilityDetector create(View view) {
        if (view == null) {
            LogUtil.d(TAG, "Unable to check visibility");
            return null;
        }
        return new VisibilityDetector(view);
    }

    private VisibilityDetector(View view) {
        this.view = view;
        this.listeners = new ArrayList();
        this.scheduleVisibilityCheck();
    }

    void addVisibilityListener(VisibilityListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    boolean removeVisibilityListener(VisibilityListener listener) {
        return this.listeners.remove(listener);
    }

    void scheduleVisibilityCheck() {
        if (this.scheduled) {
            return;
        }
        this.scheduled = true;
        this.visibilityCheck = new Runnable(){

            @Override
            public void run() {
                block5: {
                    if (VisibilityDetector.this.listeners == null) break block5;
                    ArrayList<VisibilityListener> tempList = new ArrayList<VisibilityListener>();
                    for (VisibilityListener listener : VisibilityDetector.this.listeners) {
                        tempList.add(listener);
                    }
                    if (VisibilityDetector.this.isVisible()) {
                        for (VisibilityListener listener : tempList) {
                            listener.onVisibilityChanged(true);
                        }
                    } else {
                        for (VisibilityListener listener : tempList) {
                            listener.onVisibilityChanged(false);
                        }
                    }
                }
            }
        };
        this.tasker = Executors.newSingleThreadScheduledExecutor();
        this.tasker.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                VisibilityDetector.this.view.post(VisibilityDetector.this.visibilityCheck);
            }
        }, 0L, 250L, TimeUnit.MILLISECONDS);
    }

    boolean isVisible() {
        if (this.view == null || this.view.getVisibility() != 0 || this.view.getParent() == null) {
            return false;
        }
        Rect clippedArea = new Rect();
        if (!this.view.getGlobalVisibleRect(clippedArea)) {
            return false;
        }
        int visibleViewArea = clippedArea.height() * clippedArea.width();
        int totalArea = this.view.getHeight() * this.view.getWidth();
        if (totalArea <= 0) {
            return false;
        }
        return 100 * visibleViewArea >= 50 * totalArea;
    }

    void destroy() {
        if (this.tasker != null) {
            this.tasker.shutdownNow();
        }
        this.view.removeCallbacks(this.visibilityCheck);
        this.view = null;
        this.listeners = null;
    }

    static interface VisibilityListener {
        public void onVisibilityChanged(boolean var1);
    }
}

