/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile;

import android.content.Context;
import android.location.Location;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.CountDownTimer;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import androidx.annotation.MainThread;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.prebid.mobile.AdSize;
import org.prebid.mobile.AdType;
import org.prebid.mobile.AdvertisingIDUtil;
import org.prebid.mobile.BannerBaseAdUnit;
import org.prebid.mobile.BidLog;
import org.prebid.mobile.CacheManager;
import org.prebid.mobile.DemandAdapter;
import org.prebid.mobile.ExternalUserId;
import org.prebid.mobile.LogUtil;
import org.prebid.mobile.NativeAsset;
import org.prebid.mobile.NativeDataAsset;
import org.prebid.mobile.NativeEventTracker;
import org.prebid.mobile.NativeImageAsset;
import org.prebid.mobile.NativeRequestParams;
import org.prebid.mobile.NativeTitleAsset;
import org.prebid.mobile.PrebidMobile;
import org.prebid.mobile.PrebidServerSettings;
import org.prebid.mobile.RequestParams;
import org.prebid.mobile.ResultCode;
import org.prebid.mobile.Signals;
import org.prebid.mobile.StorageUtils;
import org.prebid.mobile.TargetingParams;
import org.prebid.mobile.Util;
import org.prebid.mobile.VideoBaseAdUnit;
import org.prebid.mobile.http.HTTPPost;
import org.prebid.mobile.http.NoContextException;
import org.prebid.mobile.http.TaskResult;
import org.prebid.mobile.tasksmanager.TasksManager;

class PrebidServerAdapter
implements DemandAdapter {
    private ArrayList<ServerConnector> serverConnectors = new ArrayList();

    PrebidServerAdapter() {
    }

    @Override
    public void requestDemand(RequestParams params, DemandAdapter.DemandAdapterListener listener, String auctionId) {
        ServerConnector connector = new ServerConnector(this, listener, params, auctionId);
        this.serverConnectors.add(connector);
        connector.execute();
    }

    @Override
    public void stopRequest(String auctionId) {
        ArrayList<ServerConnector> toRemove = new ArrayList<ServerConnector>();
        for (ServerConnector connector : this.serverConnectors) {
            if (!connector.getAuctionId().equals(auctionId)) continue;
            connector.destroy();
            toRemove.add(connector);
        }
        this.serverConnectors.removeAll(toRemove);
    }

    static class ServerConnector
    extends HTTPPost {
        private static final int TIMEOUT_COUNT_DOWN_INTERVAL = 500;
        private final WeakReference<PrebidServerAdapter> prebidServerAdapter;
        private final TimeoutCountDownTimer timeoutCountDownTimer;
        private final RequestParams requestParams;
        private final String auctionId;
        private DemandAdapter.DemandAdapterListener listener;
        private boolean timeoutFired;
        private final AdType adType;
        private boolean isCancelled;

        ServerConnector(PrebidServerAdapter prebidServerAdapter, DemandAdapter.DemandAdapterListener listener, RequestParams requestParams, String auctionId) {
            this.prebidServerAdapter = new WeakReference<PrebidServerAdapter>(prebidServerAdapter);
            this.listener = listener;
            this.requestParams = requestParams;
            this.auctionId = auctionId;
            this.timeoutCountDownTimer = new TimeoutCountDownTimer(PrebidMobile.getTimeoutMillis(), 500L);
            this.adType = requestParams.getAdType();
        }

        @Override
        @MainThread
        protected void onPostExecute(TaskResult<JSONObject> response) {
            this.processResult(response);
        }

        @Override
        public void execute() {
            this.timeoutCountDownTimer.start();
            super.execute();
        }

        @Override
        protected String getUrl() {
            return PrebidMobile.getPrebidServerHost().getHostUrl();
        }

        @Override
        protected void setTimeoutMillisUpdated(boolean b) {
            PrebidMobile.timeoutMillisUpdated = b;
        }

        @Override
        protected boolean isTimeoutMillisUpdated() {
            return PrebidMobile.timeoutMillisUpdated;
        }

        private void processResult(TaskResult<JSONObject> taskResult) {
            boolean containTopBid;
            HashMap<String, String> keywords;
            block15: {
                this.timeoutCountDownTimer.cancel();
                if (taskResult.getError() != null) {
                    taskResult.getError().printStackTrace();
                    this.notifyDemandFailed(ResultCode.PREBID_SERVER_ERROR);
                    this.removeThisTask();
                    return;
                }
                if (taskResult.getResultCode() != null) {
                    this.notifyDemandFailed(taskResult.getResultCode());
                    this.removeThisTask();
                    return;
                }
                JSONObject jsonObject = taskResult.getResult();
                keywords = new HashMap<String, String>();
                containTopBid = false;
                if (jsonObject != null) {
                    LogUtil.d("Getting response for auction " + this.getAuctionId() + ": " + jsonObject.toString());
                    try {
                        JSONArray seatbid = jsonObject.getJSONArray("seatbid");
                        if (seatbid == null) break block15;
                        for (int i = 0; i < seatbid.length(); ++i) {
                            JSONObject seat = seatbid.getJSONObject(i);
                            JSONArray bids = seat.getJSONArray("bid");
                            if (bids == null) continue;
                            for (int j = 0; j < bids.length(); ++j) {
                                String cacheId;
                                String key;
                                JSONObject bid = bids.getJSONObject(j);
                                JSONObject hb_key_values = null;
                                try {
                                    hb_key_values = bid.getJSONObject("ext").getJSONObject("prebid").getJSONObject("targeting");
                                }
                                catch (JSONException jSONException) {
                                    // empty catch block
                                }
                                if (hb_key_values == null) continue;
                                Iterator it = hb_key_values.keys();
                                boolean containBids = false;
                                while (it.hasNext()) {
                                    key = (String)it.next();
                                    if (key.equals("hb_cache_id")) {
                                        containTopBid = true;
                                    }
                                    if (!key.startsWith("hb_cache_id")) continue;
                                    containBids = true;
                                }
                                it = hb_key_values.keys();
                                if (!containBids) continue;
                                while (it.hasNext()) {
                                    key = (String)it.next();
                                    keywords.put(key, hb_key_values.getString(key));
                                }
                                if (!bid.getJSONObject("ext").getJSONObject("prebid").getString("type").equalsIgnoreCase("native") || (cacheId = CacheManager.save(bid.toString())) == null) continue;
                                if (bid.has("exp")) {
                                    Long exp = bid.optLong("exp");
                                    CacheManager.setExpiry(cacheId, exp);
                                }
                                keywords.put("hb_cache_id_local", cacheId);
                            }
                        }
                    }
                    catch (JSONException e) {
                        LogUtil.e("Error processing JSON response.");
                    }
                }
            }
            if (!keywords.isEmpty() && containTopBid) {
                this.notifyContainsTopBid(true);
                this.notifyDemandReady(keywords);
            } else {
                this.notifyContainsTopBid(false);
                this.notifyDemandFailed(ResultCode.NO_BIDS);
            }
            this.removeThisTask();
        }

        private void cancel() {
            this.isCancelled = true;
            if (this.timeoutFired) {
                TasksManager.getInstance().executeOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        ServerConnector.this.notifyDemandFailed(ResultCode.TIMEOUT);
                    }
                });
            } else {
                this.timeoutCountDownTimer.cancel();
            }
        }

        private void removeThisTask() {
            PrebidServerAdapter prebidServerAdapter = (PrebidServerAdapter)this.prebidServerAdapter.get();
            if (prebidServerAdapter == null) {
                return;
            }
            prebidServerAdapter.serverConnectors.remove(this);
        }

        @Override
        protected String getAuctionId() {
            return this.auctionId;
        }

        void destroy() {
            this.cancel();
            this.listener = null;
        }

        @MainThread
        void notifyDemandReady(HashMap<String, String> keywords) {
            if (this.listener == null) {
                return;
            }
            this.listener.onDemandReady(keywords, this.getAuctionId());
        }

        @MainThread
        void notifyDemandFailed(ResultCode code) {
            if (this.listener == null) {
                return;
            }
            this.listener.onDemandFailed(code, this.getAuctionId());
        }

        private void notifyContainsTopBid(boolean contains) {
            BidLog.BidLogEntry entry = BidLog.getInstance().getLastBid();
            if (entry != null) {
                entry.setContainsTopBid(contains);
            }
        }

        @Override
        protected void httpCookieSync(Map<String, List<String>> headers) {
            if (headers == null || headers.isEmpty()) {
                return;
            }
            CookieManager cm = CookieManager.getInstance();
            if (cm == null) {
                LogUtil.i("PrebidNewAPI", "Unable to find a CookieManager");
                return;
            }
            try {
                String existingUUID = this.getExistingCookie();
                for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                    String key = entry.getKey();
                    if (key == null || !key.equalsIgnoreCase("Set-cookie") && !key.equalsIgnoreCase("Set-cookie2")) continue;
                    for (String cookieStr : entry.getValue()) {
                        if (TextUtils.isEmpty((CharSequence)cookieStr) || !cookieStr.contains("uuid2") || existingUUID != null && cookieStr.contains(existingUUID)) continue;
                        cm.setCookie("http://prebid.adnxs.com", cookieStr);
                        if (Build.VERSION.SDK_INT < 21) {
                            CookieSyncManager.createInstance((Context)PrebidMobile.getApplicationContext());
                            CookieSyncManager csm = CookieSyncManager.getInstance();
                            if (csm == null) {
                                LogUtil.i("Unable to find a CookieSyncManager");
                                return;
                            }
                            csm.sync();
                            continue;
                        }
                        cm.flush();
                    }
                }
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        protected String getExistingCookie() {
            try {
                String wvcookie;
                CookieSyncManager.createInstance((Context)PrebidMobile.getApplicationContext());
                CookieManager cm = CookieManager.getInstance();
                if (cm != null && !TextUtils.isEmpty((CharSequence)(wvcookie = cm.getCookie("http://prebid.adnxs.com")))) {
                    String[] existingCookies;
                    for (String cookie : existingCookies = wvcookie.split("; ")) {
                        if (cookie == null || !cookie.contains("uuid2")) continue;
                        return cookie;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        @Override
        protected JSONObject getPostData() throws NoContextException {
            JSONObject postData = new JSONObject();
            try {
                JSONObject objectWithoutEmptyValues;
                String id = UUID.randomUUID().toString();
                postData.put("id", (Object)id);
                postData.put("source", (Object)this.getSource(id));
                postData.put("imp", (Object)this.getImp());
                postData.put("device", (Object)this.getDeviceObject());
                postData.put("app", (Object)this.getAppObject());
                postData.put("user", (Object)this.getUserObject());
                postData.put("regs", (Object)this.getRegsObject());
                postData.put("ext", (Object)this.getRequestExtData());
                if (PrebidMobile.getPbsDebug()) {
                    postData.put("test", 1);
                }
                if ((objectWithoutEmptyValues = Util.getObjectWithoutEmptyValues(postData)) != null) {
                    postData = objectWithoutEmptyValues;
                    JSONObject prebid = postData.getJSONObject("ext").getJSONObject("prebid");
                    JSONObject cache = new JSONObject();
                    JSONObject bids = new JSONObject();
                    cache.put("bids", (Object)bids);
                    if (this.adType.equals((Object)AdType.VIDEO) || this.adType.equals((Object)AdType.VIDEO_INTERSTITIAL) || this.adType.equals((Object)AdType.REWARDED_VIDEO)) {
                        cache.put("vastxml", (Object)bids);
                    }
                    prebid.put("cache", (Object)cache);
                    JSONObject targetingEmpty = new JSONObject();
                    prebid.put("targeting", (Object)targetingEmpty);
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return postData;
        }

        private JSONObject getSource(String id) throws JSONException {
            JSONObject source = new JSONObject();
            source.put("tid", (Object)id);
            JSONObject ext = new JSONObject();
            ext.put("omidpn", (Object)TargetingParams.getOmidPartnerName());
            ext.put("omidpv", (Object)TargetingParams.getOmidPartnerVersion());
            source.put("ext", (Object)ext);
            return source;
        }

        private JSONObject getRequestExtData() {
            JSONObject ext = new JSONObject();
            JSONObject prebid = new JSONObject();
            try {
                JSONObject storedRequest = new JSONObject();
                storedRequest.put("id", (Object)PrebidMobile.getPrebidServerAccountId());
                prebid.put("storedrequest", (Object)storedRequest);
                JSONObject data = new JSONObject().put("bidders", (Object)new JSONArray(TargetingParams.getAccessControlList()));
                prebid.put("data", (Object)data);
                ext.put("prebid", (Object)prebid);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            return ext;
        }

        private JSONArray getImp() throws NoContextException {
            JSONArray impConfigs = new JSONArray();
            try {
                List<Integer> apiList;
                Object parameters;
                JSONObject imp = new JSONObject();
                JSONObject ext = new JSONObject();
                imp.put("id", (Object)"PrebidMobile");
                imp.put("secure", 1);
                if (this.adType.equals((Object)AdType.INTERSTITIAL) || this.adType.equals((Object)AdType.VIDEO_INTERSTITIAL) || this.adType.equals((Object)AdType.REWARDED_VIDEO)) {
                    imp.put("instl", 1);
                }
                if (this.adType.equals((Object)AdType.BANNER) || this.adType.equals((Object)AdType.INTERSTITIAL)) {
                    JSONObject banner = new JSONObject();
                    JSONArray format = new JSONArray();
                    if (this.adType.equals((Object)AdType.BANNER)) {
                        for (AdSize size : this.requestParams.getAdSizes()) {
                            format.put((Object)new JSONObject().put("w", size.getWidth()).put("h", size.getHeight()));
                        }
                    } else if (this.adType.equals((Object)AdType.INTERSTITIAL)) {
                        Context context = PrebidMobile.getApplicationContext();
                        if (context != null) {
                            format.put((Object)new JSONObject().put("w", context.getResources().getConfiguration().screenWidthDp).put("h", context.getResources().getConfiguration().screenHeightDp));
                        } else {
                            throw new NoContextException();
                        }
                    }
                    banner.put("format", (Object)format);
                    parameters = this.requestParams.getBannerParameters();
                    if (parameters != null) {
                        apiList = Util.convertCollection(((BannerBaseAdUnit.Parameters)parameters).getApi(), new Util.Function1<Integer, Signals.Api>(){

                            @Override
                            public Integer apply(Signals.Api element) {
                                return element.value;
                            }
                        });
                        banner.put("api", (Object)new JSONArray(apiList));
                    }
                    imp.put("banner", (Object)banner);
                } else if (this.adType.equals((Object)AdType.NATIVE)) {
                    JSONObject nativeObj = new JSONObject();
                    JSONObject request = new JSONObject();
                    JSONArray assets = new JSONArray();
                    NativeRequestParams params = this.requestParams.getNativeRequestParams();
                    if (params.getContextType() != null) {
                        request.put(NativeRequestParams.CONTEXT, params.getContextType().getID());
                    }
                    if (params.getContextsubtype() != null) {
                        request.put(NativeRequestParams.CONTEXT_SUB_TYPE, params.getContextsubtype().getID());
                    }
                    if (params.getPlacementType() != null) {
                        request.put(NativeRequestParams.PLACEMENT_TYPE, params.getPlacementType().getID());
                    }
                    request.put(NativeRequestParams.PLACEMENT_COUNT, params.getPlacementCount());
                    request.put(NativeRequestParams.SEQ, params.getSeq());
                    request.put(NativeRequestParams.A_URL_SUPPORT, params.isAUrlSupport() ? 1 : 0);
                    request.put(NativeRequestParams.D_URL_SUPPORT, params.isDUrlSupport() ? 1 : 0);
                    if (!params.getEventTrackers().isEmpty()) {
                        JSONArray trackers = new JSONArray();
                        for (NativeEventTracker tracker : params.getEventTrackers()) {
                            JSONObject trackerObject = new JSONObject();
                            trackerObject.put(NativeRequestParams.EVENT, tracker.getEvent().getID());
                            JSONArray methodsArray = new JSONArray();
                            for (NativeEventTracker.EVENT_TRACKING_METHOD method : tracker.getMethods()) {
                                methodsArray.put(method.getID());
                            }
                            trackerObject.put(NativeRequestParams.METHODS, (Object)methodsArray);
                            trackerObject.put(NativeRequestParams.EXT, tracker.getExtObject());
                            trackers.put((Object)trackerObject);
                        }
                        request.put(NativeRequestParams.EVENT_TRACKERS, (Object)trackers);
                    }
                    request.put(NativeRequestParams.PRIVACY, params.isPrivacy() ? 1 : 0);
                    request.put(NativeRequestParams.EXT, params.getExt());
                    if (!params.getAssets().isEmpty()) {
                        int idCount = 1;
                        for (NativeAsset asset : params.getAssets()) {
                            switch (asset.getType()) {
                                case TITLE: {
                                    NativeTitleAsset titleAsset = (NativeTitleAsset)asset;
                                    JSONObject assetObj = new JSONObject();
                                    JSONObject title = new JSONObject();
                                    title.put(NativeRequestParams.LENGTH, titleAsset.getLen());
                                    if (titleAsset.getTitleExt() != null) {
                                        title.put(NativeRequestParams.EXT, titleAsset.getTitleExt());
                                    }
                                    assetObj.put(NativeRequestParams.TITLE, (Object)title);
                                    assetObj.put(NativeRequestParams.REQUIRED, titleAsset.isRequired() ? 1 : 0);
                                    assetObj.put(NativeRequestParams.EXT, titleAsset.getAssetExt());
                                    if (PrebidMobile.shouldAssignNativeAssetID()) {
                                        assetObj.put("id", idCount++);
                                    }
                                    assets.put((Object)assetObj);
                                    break;
                                }
                                case IMAGE: {
                                    NativeImageAsset imageAsset = (NativeImageAsset)asset;
                                    JSONObject assetObj = new JSONObject();
                                    JSONObject image = new JSONObject();
                                    image.put(NativeRequestParams.TYPE, imageAsset.getImageType().getID());
                                    if (imageAsset.getImageExt() != null) {
                                        image.put(NativeRequestParams.EXT, imageAsset.getImageExt());
                                    }
                                    if (imageAsset.getHMin() > 0 && imageAsset.getWMin() > 0) {
                                        image.put(NativeRequestParams.WIDTH_MIN, imageAsset.getWMin());
                                        image.put(NativeRequestParams.HEIGHT_MIN, imageAsset.getHMin());
                                    }
                                    if (imageAsset.getH() > 0 && imageAsset.getW() > 0) {
                                        image.put(NativeRequestParams.WIDTH, imageAsset.getW());
                                        image.put(NativeRequestParams.HEIGHT, imageAsset.getH());
                                    }
                                    if (!imageAsset.getMimes().isEmpty()) {
                                        JSONArray imageMimesArray = new JSONArray();
                                        for (String mime : imageAsset.getMimes()) {
                                            imageMimesArray.put((Object)mime);
                                        }
                                        image.put(NativeRequestParams.MIMES, (Object)imageMimesArray);
                                    }
                                    assetObj.put(NativeRequestParams.IMAGE, (Object)image);
                                    assetObj.put(NativeRequestParams.REQUIRED, imageAsset.isRequired() ? 1 : 0);
                                    assetObj.put(NativeRequestParams.EXT, imageAsset.getAssetExt());
                                    if (PrebidMobile.shouldAssignNativeAssetID()) {
                                        assetObj.put("id", idCount++);
                                    }
                                    assets.put((Object)assetObj);
                                    break;
                                }
                                case DATA: {
                                    NativeDataAsset dataAsset = (NativeDataAsset)asset;
                                    JSONObject assetObj = new JSONObject();
                                    JSONObject data = new JSONObject();
                                    data.put(NativeRequestParams.TYPE, dataAsset.getDataType().getID());
                                    if (dataAsset.getLen() > 0) {
                                        data.put(NativeRequestParams.LENGTH, dataAsset.getLen());
                                    }
                                    if (dataAsset.getDataExt() != null) {
                                        data.put(NativeRequestParams.EXT, dataAsset.getDataExt());
                                    }
                                    assetObj.put(NativeRequestParams.DATA, (Object)data);
                                    assetObj.put(NativeRequestParams.REQUIRED, dataAsset.isRequired() ? 1 : 0);
                                    assetObj.put(NativeRequestParams.EXT, dataAsset.getAssetExt());
                                    if (PrebidMobile.shouldAssignNativeAssetID()) {
                                        assetObj.put("id", idCount++);
                                    }
                                    assets.put((Object)assetObj);
                                }
                            }
                        }
                    }
                    request.put(NativeRequestParams.ASSETS, (Object)assets);
                    request.put(NativeRequestParams.VERSION, (Object)NativeRequestParams.SUPPORTED_VERSION);
                    nativeObj.put(NativeRequestParams.REQUEST, (Object)request.toString());
                    nativeObj.put(NativeRequestParams.VERSION, (Object)NativeRequestParams.SUPPORTED_VERSION);
                    imp.put(NativeRequestParams.NATIVE, (Object)nativeObj);
                } else if (this.adType.equals((Object)AdType.VIDEO) || this.adType.equals((Object)AdType.VIDEO_INTERSTITIAL) || this.adType.equals((Object)AdType.REWARDED_VIDEO)) {
                    JSONObject video = new JSONObject();
                    Integer placementValue = null;
                    parameters = this.requestParams.getVideoParameters();
                    if (parameters != null) {
                        Signals.Placement placement;
                        apiList = Util.convertCollection(((VideoBaseAdUnit.Parameters)parameters).getApi(), new Util.Function1<Integer, Signals.Api>(){

                            @Override
                            public Integer apply(Signals.Api element) {
                                return element.value;
                            }
                        });
                        List<Integer> playbackMethodList = Util.convertCollection(((VideoBaseAdUnit.Parameters)parameters).getPlaybackMethod(), new Util.Function1<Integer, Signals.PlaybackMethod>(){

                            @Override
                            public Integer apply(Signals.PlaybackMethod element) {
                                return element.value;
                            }
                        });
                        List<Integer> protocolList = Util.convertCollection(((VideoBaseAdUnit.Parameters)parameters).getProtocols(), new Util.Function1<Integer, Signals.Protocols>(){

                            @Override
                            public Integer apply(Signals.Protocols element) {
                                return element.value;
                            }
                        });
                        Integer startDelayValue = null;
                        Signals.StartDelay startDelay = ((VideoBaseAdUnit.Parameters)parameters).getStartDelay();
                        if (startDelay != null) {
                            startDelayValue = startDelay.value;
                        }
                        if ((placement = ((VideoBaseAdUnit.Parameters)parameters).getPlacement()) != null) {
                            placementValue = placement.value;
                        }
                        video.put("api", (Object)new JSONArray(apiList));
                        video.put("maxbitrate", (Object)((VideoBaseAdUnit.Parameters)parameters).getMaxBitrate());
                        video.put("minbitrate", (Object)((VideoBaseAdUnit.Parameters)parameters).getMinBitrate());
                        video.put("maxduration", (Object)((VideoBaseAdUnit.Parameters)parameters).getMaxDuration());
                        video.put("minduration", (Object)((VideoBaseAdUnit.Parameters)parameters).getMinDuration());
                        video.put("mimes", (Object)new JSONArray(((VideoBaseAdUnit.Parameters)parameters).getMimes()));
                        video.put("playbackmethod", (Object)new JSONArray((Collection)playbackMethodList));
                        video.put("protocols", (Object)new JSONArray(protocolList));
                        video.put("startdelay", (Object)startDelayValue);
                    }
                    Integer placementValueDefault = null;
                    if (this.adType.equals((Object)AdType.VIDEO)) {
                        for (AdSize size : this.requestParams.getAdSizes()) {
                            video.put("w", size.getWidth());
                            video.put("h", size.getHeight());
                        }
                    } else if (this.adType.equals((Object)AdType.VIDEO_INTERSTITIAL) || this.adType.equals((Object)AdType.REWARDED_VIDEO)) {
                        Context context = PrebidMobile.getApplicationContext();
                        if (context != null) {
                            video.put("w", context.getResources().getConfiguration().screenWidthDp);
                            video.put("h", context.getResources().getConfiguration().screenHeightDp);
                        }
                        placementValueDefault = 5;
                    }
                    if (placementValue == null) {
                        placementValue = placementValueDefault;
                    }
                    video.put("placement", (Object)placementValue);
                    video.put("linearity", 1);
                    imp.put("video", (Object)video);
                }
                JSONObject prebid = new JSONObject();
                ext.put("prebid", (Object)prebid);
                JSONObject context = new JSONObject();
                JSONObject contextData = Util.toJson(this.requestParams.getContextDataDictionary());
                JSONObject data = new JSONObject(contextData.toString());
                data.put("adslot", (Object)this.requestParams.getPbAdSlot());
                context.put("data", (Object)data);
                context.put("keywords", (Object)TextUtils.join((CharSequence)",", this.requestParams.getContextKeywordsSet()));
                ext.put("context", (Object)context);
                JSONObject storedrequest = new JSONObject();
                prebid.put("storedrequest", (Object)storedrequest);
                storedrequest.put("id", (Object)this.requestParams.getConfigId());
                if (!TextUtils.isEmpty((CharSequence)PrebidMobile.getStoredAuctionResponse())) {
                    JSONObject storedAuctionResponse = new JSONObject();
                    prebid.put("storedauctionresponse", (Object)storedAuctionResponse);
                    storedAuctionResponse.put("id", (Object)PrebidMobile.getStoredAuctionResponse());
                }
                if (!PrebidMobile.getStoredBidResponses().isEmpty()) {
                    JSONArray bidResponseArray = new JSONArray();
                    prebid.put("storedbidresponse", (Object)bidResponseArray);
                    for (String bidder : PrebidMobile.getStoredBidResponses().keySet()) {
                        String bidId = PrebidMobile.getStoredBidResponses().get(bidder);
                        if (TextUtils.isEmpty((CharSequence)bidder) || TextUtils.isEmpty((CharSequence)bidId)) continue;
                        JSONObject storedBid = new JSONObject();
                        storedBid.put("bidder", (Object)bidder);
                        storedBid.put("id", (Object)bidId);
                        bidResponseArray.put((Object)storedBid);
                    }
                }
                if (this.adType.equals((Object)AdType.REWARDED_VIDEO)) {
                    prebid.put("is_rewarded_inventory", 1);
                }
                imp.put("ext", (Object)ext);
                impConfigs.put((Object)imp);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return impConfigs;
        }

        private JSONObject getDeviceObject() {
            JSONObject device;
            block24: {
                device = new JSONObject();
                try {
                    NetworkInfo wifi;
                    String networkOperator;
                    Context context;
                    if (!TextUtils.isEmpty((CharSequence)PrebidServerSettings.deviceMake)) {
                        device.put("make", (Object)PrebidServerSettings.deviceMake);
                    }
                    if (!TextUtils.isEmpty((CharSequence)PrebidServerSettings.deviceModel)) {
                        device.put("model", (Object)PrebidServerSettings.deviceModel);
                    }
                    if (!TextUtils.isEmpty((CharSequence)PrebidServerSettings.userAgent)) {
                        device.put("ua", (Object)PrebidServerSettings.userAgent);
                    }
                    device.put("lmt", AdvertisingIDUtil.isLimitAdTracking() ? 1 : 0);
                    if (this.canIAccessDeviceData() && !AdvertisingIDUtil.isLimitAdTracking() && !TextUtils.isEmpty((CharSequence)AdvertisingIDUtil.getAAID())) {
                        device.put("ifa", (Object)AdvertisingIDUtil.getAAID());
                    }
                    device.put("os", (Object)"android");
                    device.put("osv", (Object)String.valueOf(Build.VERSION.SDK_INT));
                    if (!TextUtils.isEmpty((CharSequence)Locale.getDefault().getLanguage())) {
                        device.put("language", (Object)Locale.getDefault().getLanguage());
                    }
                    if (this.adType.equals((Object)AdType.INTERSTITIAL)) {
                        Integer minSizePercWidth = null;
                        Integer minSizePercHeight = null;
                        AdSize minSizePerc = this.requestParams.getMinSizePerc();
                        if (minSizePerc != null) {
                            minSizePercWidth = minSizePerc.getWidth();
                            minSizePercHeight = minSizePerc.getHeight();
                        }
                        JSONObject deviceExt = new JSONObject();
                        JSONObject deviceExtPrebid = new JSONObject();
                        JSONObject deviceExtPrebidInstl = new JSONObject();
                        device.put("ext", (Object)deviceExt);
                        deviceExt.put("prebid", (Object)deviceExtPrebid);
                        deviceExtPrebid.put("interstitial", (Object)deviceExtPrebidInstl);
                        deviceExtPrebidInstl.put("minwidthperc", (Object)minSizePercWidth);
                        deviceExtPrebidInstl.put("minheightperc", (Object)minSizePercHeight);
                        device.put("ext", (Object)deviceExt);
                    }
                    if ((context = PrebidMobile.getApplicationContext()) == null) break block24;
                    device.put("w", context.getResources().getConfiguration().screenWidthDp);
                    device.put("h", context.getResources().getConfiguration().screenHeightDp);
                    device.put("pxratio", (double)context.getResources().getDisplayMetrics().density);
                    TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
                    if (!(PrebidServerSettings.getMCC() >= 0 && PrebidServerSettings.getMNC() >= 0 || TextUtils.isEmpty((CharSequence)(networkOperator = telephonyManager.getNetworkOperator())))) {
                        try {
                            PrebidServerSettings.setMCC(Integer.parseInt(networkOperator.substring(0, 3)));
                            PrebidServerSettings.setMNC(Integer.parseInt(networkOperator.substring(3)));
                        }
                        catch (Exception e) {
                            PrebidServerSettings.setMCC(-1);
                            PrebidServerSettings.setMNC(-1);
                        }
                    }
                    if (PrebidServerSettings.getMCC() > 0 && PrebidServerSettings.getMNC() > 0) {
                        device.put("mccmnc", (Object)String.format(Locale.ENGLISH, "%d-%d", PrebidServerSettings.getMCC(), PrebidServerSettings.getMNC()));
                    }
                    if (PrebidServerSettings.getCarrierName() == null) {
                        try {
                            PrebidServerSettings.setCarrierName(telephonyManager.getNetworkOperatorName());
                        }
                        catch (SecurityException ex) {
                            PrebidServerSettings.setCarrierName("");
                        }
                    }
                    if (!TextUtils.isEmpty((CharSequence)PrebidServerSettings.getCarrierName())) {
                        device.put("carrier", (Object)PrebidServerSettings.getCarrierName());
                    }
                    int connection_type = 0;
                    ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
                    NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
                    if (activeNetwork != null && activeNetwork.isConnected() && (wifi = cm.getNetworkInfo(1)) != null) {
                        connection_type = wifi.isConnected() ? 1 : 2;
                    }
                    device.put("connectiontype", connection_type);
                    if (PrebidMobile.isShareGeoLocation()) {
                        if (context.checkCallingOrSelfPermission("android.permission.ACCESS_FINE_LOCATION") == 0 || context.checkCallingOrSelfPermission("android.permission.ACCESS_COARSE_LOCATION") == 0) {
                            Location lastLocation = null;
                            LocationManager lm = (LocationManager)context.getSystemService("location");
                            for (String provider_name : lm.getProviders(true)) {
                                Location l = lm.getLastKnownLocation(provider_name);
                                if (l == null) continue;
                                if (lastLocation == null) {
                                    lastLocation = l;
                                    continue;
                                }
                                if (l.getTime() <= 0L || lastLocation.getTime() <= 0L || l.getTime() <= lastLocation.getTime()) continue;
                                lastLocation = l;
                            }
                            JSONObject geo = new JSONObject();
                            if (lastLocation != null) {
                                Double lat = lastLocation.getLatitude();
                                Double lon = lastLocation.getLongitude();
                                geo.put("lat", (Object)lat);
                                geo.put("lon", (Object)lon);
                                Integer locDataPrecision = Math.round(lastLocation.getAccuracy());
                                Integer locDataAge = (int)Math.max(0L, System.currentTimeMillis() - lastLocation.getTime());
                                geo.put("lastfix", (Object)locDataAge);
                                geo.put("accuracy", (Object)locDataPrecision);
                                device.put("geo", (Object)geo);
                            }
                        } else {
                            LogUtil.w("Location permissions ACCESS_COARSE_LOCATION and/or ACCESS_FINE_LOCATION aren\\'t set in the host app. This may affect demand.");
                        }
                    }
                }
                catch (JSONException e) {
                    LogUtil.d("PrebidServerAdapter getDeviceObject() " + e.getMessage());
                }
            }
            return device;
        }

        private JSONObject getAppObject() {
            JSONObject app = new JSONObject();
            try {
                if (!TextUtils.isEmpty((CharSequence)TargetingParams.getBundleName())) {
                    app.put("bundle", (Object)TargetingParams.getBundleName());
                }
                if (!TextUtils.isEmpty((CharSequence)PrebidServerSettings.pkgVersion)) {
                    app.put("ver", (Object)PrebidServerSettings.pkgVersion);
                }
                if (!TextUtils.isEmpty((CharSequence)PrebidServerSettings.appName)) {
                    app.put("name", (Object)PrebidServerSettings.appName);
                }
                if (!TextUtils.isEmpty((CharSequence)TargetingParams.getDomain())) {
                    app.put("domain", (Object)TargetingParams.getDomain());
                }
                if (!TextUtils.isEmpty((CharSequence)TargetingParams.getStoreUrl())) {
                    app.put("storeurl", (Object)TargetingParams.getStoreUrl());
                }
                if (this.requestParams.getContent() != null) {
                    app.put("content", (Object)this.getContentObject());
                }
                JSONObject publisher = new JSONObject();
                publisher.put("id", (Object)PrebidMobile.getPrebidServerAccountId());
                app.put("publisher", (Object)publisher);
                JSONObject prebid = new JSONObject();
                prebid.put("source", (Object)"prebid-mobile");
                prebid.put("version", (Object)PrebidServerSettings.sdk_version);
                JSONObject ext = new JSONObject();
                ext.put("prebid", (Object)prebid);
                ext.put("data", (Object)Util.toJson(TargetingParams.getContextDataDictionary()));
                app.put("ext", (Object)ext);
                app.put("keywords", (Object)TextUtils.join((CharSequence)",", TargetingParams.getContextKeywordsSet()));
            }
            catch (JSONException e) {
                LogUtil.d("PrebidServerAdapter getAppObject() " + e.getMessage());
            }
            return app;
        }

        private JSONObject getContentObject() throws JSONException {
            JSONObject contentJSON = new JSONObject();
            if (this.requestParams.getContent().getUrl() != null) {
                contentJSON.put("url", (Object)this.requestParams.getContent().getUrl());
            }
            return contentJSON;
        }

        private JSONObject getUserObject() {
            JSONObject user = new JSONObject();
            try {
                if (TargetingParams.getYearOfBirth() > 0) {
                    user.put("yob", TargetingParams.getYearOfBirth());
                }
                TargetingParams.GENDER gender = TargetingParams.getGender();
                String g = "O";
                switch (gender) {
                    case FEMALE: {
                        g = "F";
                        break;
                    }
                    case MALE: {
                        g = "M";
                        break;
                    }
                    case UNKNOWN: {
                        g = "O";
                    }
                }
                user.put("gender", (Object)g);
                String globalUserKeywordString = TextUtils.join((CharSequence)",", TargetingParams.getUserKeywordsSet());
                user.put("keywords", (Object)globalUserKeywordString);
                JSONObject ext = new JSONObject();
                Boolean isSubjectToGDPR = TargetingParams.isSubjectToGDPR();
                if (Boolean.TRUE.equals(isSubjectToGDPR)) {
                    ext.put("consent", (Object)TargetingParams.getGDPRConsentString());
                }
                ext.put("data", (Object)Util.toJson(TargetingParams.getUserDataDictionary()));
                ext.put("eids", (Object)this.getExternalUserIdArray());
                user.put("ext", (Object)ext);
            }
            catch (JSONException e) {
                LogUtil.d("PrebidServerAdapter getUserObject() " + e.getMessage());
            }
            return user;
        }

        private JSONArray getExternalUserIdArray() {
            JSONArray transformedUserIdArray = new JSONArray();
            List<ExternalUserId> externalUserIds = PrebidMobile.getExternalUserIds();
            if (externalUserIds == null || externalUserIds.isEmpty()) {
                externalUserIds = TargetingParams.fetchStoredExternalUserIds();
            }
            try {
                if (externalUserIds != null && !externalUserIds.isEmpty()) {
                    for (ExternalUserId externaluserId : externalUserIds) {
                        if (externaluserId.getSource() == null || externaluserId.getSource().length() == 0 || externaluserId.getIdentifier() == null || externaluserId.getIdentifier().length() == 0) {
                            return null;
                        }
                        JSONObject transformedUserIdObject = new JSONObject();
                        transformedUserIdObject.put("source", (Object)externaluserId.getSource());
                        JSONArray uidArray = new JSONArray();
                        JSONObject uidObject = new JSONObject();
                        uidObject.put("id", (Object)externaluserId.getIdentifier());
                        if (externaluserId.getAtype() != null) {
                            uidObject.put("atype", (Object)externaluserId.getAtype());
                        }
                        if (externaluserId.getExt() != null) {
                            JSONObject extObject = new JSONObject(externaluserId.getExt());
                            uidObject.put("ext", (Object)extObject);
                        }
                        uidArray.put((Object)uidObject);
                        transformedUserIdObject.put("uids", (Object)uidArray);
                        transformedUserIdArray.put((Object)transformedUserIdObject);
                    }
                }
            }
            catch (JSONException e) {
                LogUtil.d("PrebidServerAdapter getExternalUserIdArray() " + e.getMessage());
            }
            return transformedUserIdArray;
        }

        private JSONObject getRegsObject() {
            JSONObject regs = new JSONObject();
            try {
                JSONObject ext = new JSONObject();
                Boolean isSubjectToGDPR = TargetingParams.isSubjectToGDPR();
                if (TargetingParams.isSubjectToCOPPA()) {
                    regs.put("coppa", 1);
                }
                if (Boolean.TRUE.equals(isSubjectToGDPR)) {
                    ext.put("gdpr", 1);
                }
                ext.put("us_privacy", (Object)StorageUtils.getIabCcpa());
                regs.put("ext", (Object)ext);
            }
            catch (JSONException e) {
                LogUtil.d("PrebidServerAdapter getRegsObject() " + e.getMessage());
            }
            return regs;
        }

        @Override
        protected boolean canIAccessDeviceData() {
            boolean setDeviceId = false;
            Boolean gdprApplies = TargetingParams.isSubjectToGDPR();
            Boolean deviceAccessConsent = TargetingParams.getDeviceAccessConsent();
            if (deviceAccessConsent == null && (gdprApplies == null || Boolean.FALSE.equals(gdprApplies)) || Boolean.TRUE.equals(deviceAccessConsent)) {
                setDeviceId = true;
            }
            return setDeviceId;
        }

        class TimeoutCountDownTimer
        extends CountDownTimer {
            public TimeoutCountDownTimer(long millisInFuture, long countDownInterval) {
                super(millisInFuture, countDownInterval);
            }

            public void onTick(long millisUntilFinished) {
                if (ServerConnector.this.isCancelled) {
                    this.cancel();
                }
            }

            public void onFinish() {
                if (ServerConnector.this.isCancelled) {
                    return;
                }
                ServerConnector.this.timeoutFired = true;
                ServerConnector.this.cancel();
            }
        }
    }
}

