/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile;

import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ExternalUserId {
    private String source;
    private String identifier;
    private Integer atype;
    private Map<String, Object> ext;

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public Integer getAtype() {
        return this.atype;
    }

    public void setAtype(Integer atype) {
        this.atype = atype;
    }

    public Map<String, Object> getExt() {
        return this.ext;
    }

    public void setExt(Map<String, Object> ext) {
        this.ext = ext;
    }

    public ExternalUserId(@NonNull String source, @NonNull String identifier, Integer atype, Map<String, Object> ext) {
        this.source = source;
        this.identifier = identifier;
        this.atype = atype;
        this.ext = ext;
    }

    public String toString() {
        JSONObject transformedUserIdObject = new JSONObject();
        try {
            transformedUserIdObject.put("source", (Object)this.getSource());
            transformedUserIdObject.put("id", (Object)this.getIdentifier());
            transformedUserIdObject.put("atype", (Object)this.getAtype());
            if (this.getExt() != null && !this.getExt().isEmpty()) {
                JSONObject extObject = new JSONObject(this.getExt());
                transformedUserIdObject.put("ext", (Object)extObject);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return transformedUserIdObject.toString();
    }

    static List<ExternalUserId> getExternalUidListFromJson(String list) {
        ArrayList<ExternalUserId> externalUserIdList = new ArrayList<ExternalUserId>();
        try {
            JSONArray jsonArr = new JSONArray(list);
            for (int i = 0; i < jsonArr.length(); ++i) {
                if (ExternalUserId.getExternalUidFromJson(jsonArr.getJSONObject(i).toString()) == null) continue;
                externalUserIdList.add(ExternalUserId.getExternalUidFromJson(jsonArr.getJSONObject(i).toString()));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return externalUserIdList;
    }

    static ExternalUserId getExternalUidFromJson(String json) {
        ExternalUserId extUId = null;
        try {
            JSONObject jsonObject = new JSONObject(json);
            String source = jsonObject.has("source") ? jsonObject.optString("source") : null;
            String id = jsonObject.has("id") ? jsonObject.optString("id") : null;
            Integer aType = jsonObject.has("atype") ? Integer.valueOf(jsonObject.optInt("atype")) : null;
            HashMap<String, String> ext = null;
            JSONObject extObj = jsonObject.optJSONObject("ext");
            if (extObj != null) {
                Iterator it = extObj.keys();
                while (it.hasNext()) {
                    ext = new HashMap<String, String>();
                    String key = (String)it.next();
                    ext.put(key, extObj.getString(key));
                }
            }
            extUId = new ExternalUserId(source, id, aType, ext);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return extUId;
    }
}

