/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Looper;
import android.text.TextUtils;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.prebid.mobile.tasksmanager.TasksManager;

class AdvertisingIDUtil {
    private static String aaid = null;
    private static boolean limitAdTracking = false;
    private static STATE state = STATE.NOT_FETCHED;

    AdvertisingIDUtil() {
    }

    static synchronized String getAAID() {
        return aaid;
    }

    static synchronized boolean isLimitAdTracking() {
        return limitAdTracking;
    }

    private static synchronized void setAAID(String aaid) {
        AdvertisingIDUtil.aaid = aaid;
    }

    private static synchronized void setLimitAdTracking(boolean limitAdTracking) {
        AdvertisingIDUtil.limitAdTracking = limitAdTracking;
    }

    @SuppressLint(value={"ObsoleteSdkInt"})
    static void retrieveAndSetAAID(Context context) {
        if (STATE.FETCHED.equals((Object)state) || STATE.FETCHING.equals((Object)state) || context == null) {
            return;
        }
        AAIDTask getAAIDTask = new AAIDTask(context);
        getAAIDTask.execute();
    }

    private static class AAIDTask {
        private static final String cAdvertisingIdClientName = "com.google.android.gms.ads.identifier.AdvertisingIdClient";
        private static final String cAdvertisingIdClientInfoName = "com.google.android.gms.ads.identifier.AdvertisingIdClient$Info";
        private WeakReference<Context> context;

        private AAIDTask(Context context) {
            this.context = new WeakReference<Context>(context);
        }

        protected void execute() {
            if (Looper.myLooper() == Looper.getMainLooper()) {
                TasksManager.getInstance().executeOnBackgroundThread(new Runnable(){

                    @Override
                    public void run() {
                        AAIDTask.this.fetchAAID();
                    }
                });
            } else {
                this.fetchAAID();
            }
        }

        private void fetchAAID() {
            state = STATE.FETCHING;
            try {
                Context callcontext = (Context)this.context.get();
                if (callcontext != null) {
                    Class<?> cInfo = Class.forName(cAdvertisingIdClientInfoName);
                    Class<?> cClient = Class.forName(cAdvertisingIdClientName);
                    Method mGetAdvertisingIdInfo = cClient.getMethod("getAdvertisingIdInfo", Context.class);
                    Method mGetId = cInfo.getMethod("getId", new Class[0]);
                    Method mIsLimitAdTrackingEnabled = cInfo.getMethod("isLimitAdTrackingEnabled", new Class[0]);
                    Object adInfoObject = cInfo.cast(mGetAdvertisingIdInfo.invoke(null, callcontext));
                    aaid = (String)mGetId.invoke(adInfoObject, new Object[0]);
                    limitAdTracking = (Boolean)mIsLimitAdTrackingEnabled.invoke(adInfoObject, new Object[0]);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (ClassCastException classCastException) {
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (limitAdTracking || TextUtils.isEmpty((CharSequence)aaid)) {
                state = STATE.FETCHED_BUT_LIMIT_TARGETING;
            } else {
                state = STATE.FETCHED;
            }
        }
    }

    private static enum STATE {
        NOT_FETCHED,
        FETCHING,
        FETCHED_BUT_LIMIT_TARGETING,
        FETCHED;

    }
}

