/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.hub.net;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.praxislive.base.AbstractAsyncControl;
import org.praxislive.core.Call;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.ComponentType;
import org.praxislive.core.Control;
import org.praxislive.core.ControlAddress;
import org.praxislive.core.Packet;
import org.praxislive.core.PacketRouter;
import org.praxislive.core.Protocol;
import org.praxislive.core.Root;
import org.praxislive.core.Value;
import org.praxislive.core.services.RootFactoryService;
import org.praxislive.core.services.Service;
import org.praxislive.core.types.PMap;
import org.praxislive.core.types.PReference;
import org.praxislive.hub.BasicCoreRoot;
import org.praxislive.hub.Hub;
import org.praxislive.hub.net.ChildLauncher;
import org.praxislive.hub.net.FileServer;
import org.praxislive.hub.net.HubConfiguration;
import org.praxislive.hub.net.ProxyClientRoot;
import org.praxislive.hub.net.ProxyInfo;
import org.praxislive.hub.net.Utils;
import org.praxislive.hub.net.internal.HubConfigurationService;

class NetworkCoreRoot
extends BasicCoreRoot {
    static final int TIMEOUT = Integer.getInteger("praxis.hub.network.timeout", 60);
    private static final String PROXY_PREFIX = "_sys_proxy_";
    private final Hub.Accessor hubAccess;
    private final List<ProxyData> proxies;
    private final List<Class<? extends Service>> services;
    private final ChildLauncher childLauncher;
    private final Map<String, String> remotes;
    private EventLoopGroup clientEventLoopGroup;
    private HubConfiguration configuration;
    private FileServer fileServer;

    NetworkCoreRoot(Hub.Accessor hubAccess, List<Root> exts, List<Class<? extends Service>> services, ChildLauncher childLauncher, HubConfiguration configuration) {
        super(hubAccess, exts);
        this.hubAccess = hubAccess;
        this.services = services;
        this.childLauncher = childLauncher;
        this.configuration = configuration;
        this.proxies = new ArrayList<ProxyData>();
        this.remotes = new HashMap<String, String>();
    }

    protected void buildControlMap(Map<String, Control> ctrls) {
        ctrls.put("add-root", (Control)new AddRootControl());
        ctrls.put("remove-root", (Control)new RemoveRootControl());
        ctrls.put("hub-configure", new HubConfigurationControl());
        super.buildControlMap(ctrls);
    }

    protected void buildServiceMap(Map<Class<? extends Service>, ComponentAddress> srvs) {
        super.buildServiceMap(srvs);
        srvs.put(HubConfigurationService.class, this.getAddress());
    }

    protected void starting() {
        if (this.configuration != null) {
            this.configure();
        }
    }

    protected void terminating() {
        super.terminating();
        if (this.fileServer != null) {
            this.fileServer.stop();
            this.fileServer = null;
        }
    }

    private void ensureConfigured() {
        if (this.configuration == null) {
            this.configuration = HubConfiguration.fromMap(PMap.EMPTY);
            this.configure();
        }
    }

    private void configure() {
        List<ProxyInfo> proxyInfo = this.configuration.proxies();
        if (proxyInfo.isEmpty()) {
            return;
        }
        this.clientEventLoopGroup = new NioEventLoopGroup();
        boolean requireServer = this.configuration.isFileServerEnabled() && proxyInfo.stream().anyMatch(p -> !p.isLocal());
        FileServer.Info serverInfo = requireServer ? this.activateFileServer() : null;
        for (int i = 0; i < proxyInfo.size(); ++i) {
            String id = PROXY_PREFIX + (i + 1);
            ProxyInfo info = proxyInfo.get(i);
            try {
                Root.Controller ctrl = this.installRoot(id, (Root)new ProxyClientRoot(info, this.clientEventLoopGroup, this.services, this.childLauncher, serverInfo));
                info.services().forEach(cls -> {
                    ComponentAddress address = ComponentAddress.of((String)("/" + id + "/services/" + Protocol.Type.of((Class)cls).name()));
                    this.hubAccess.registerService(cls, address);
                });
                this.proxies.add(new ProxyData(info, ComponentAddress.of((String)("/" + id)), ctrl));
                continue;
            }
            catch (Exception ex) {
                System.getLogger(NetworkCoreRoot.class.getName()).log(System.Logger.Level.ERROR, "", (Throwable)ex);
            }
        }
        this.proxies.forEach(pd -> this.startRoot(pd.address().rootID(), pd.controller()));
    }

    private FileServer.Info activateFileServer() {
        try {
            this.fileServer = new FileServer(Utils.getUserDirectory().toPath(), Utils.getFileServerPort());
            return this.fileServer.start();
        }
        catch (IOException ex) {
            System.getLogger(NetworkCoreRoot.class.getName()).log(System.Logger.Level.ERROR, "", (Throwable)ex);
            this.fileServer = null;
            return null;
        }
    }

    private class AddRootControl
    extends AbstractAsyncControl {
        private AddRootControl() {
        }

        protected Call processInvoke(Call call) throws Exception {
            NetworkCoreRoot.this.ensureConfigured();
            List args = call.args();
            if (args.size() < 2) {
                throw new IllegalArgumentException("Invalid arguments");
            }
            String id = ((Value)args.get(0)).toString();
            if (!ComponentAddress.isValidID((String)id)) {
                throw new IllegalArgumentException("Invalid Component ID");
            }
            ComponentType type = (ComponentType)ComponentType.from((Value)((Value)args.get(1))).orElseThrow(() -> new IllegalArgumentException("Invalid Component type"));
            ComponentAddress proxy = NetworkCoreRoot.this.proxies.stream().filter(p -> p.info().matches(id, type)).map(p -> p.address()).findFirst().orElse(null);
            if (proxy != null) {
                ControlAddress to = ControlAddress.of((ComponentAddress)proxy, (String)"add-root");
                return Call.create((ControlAddress)to, (ControlAddress)call.to(), (long)call.time(), (List)args);
            }
            ControlAddress to = ControlAddress.of((ComponentAddress)NetworkCoreRoot.this.findService(RootFactoryService.class), (String)"new-root-instance");
            return Call.create((ControlAddress)to, (ControlAddress)call.to(), (long)call.time(), (Value)((Value)args.get(1)));
        }

        protected Call processResponse(Call call) throws Exception {
            Call active = this.getActiveCall();
            String id = ((Value)active.args().get(0)).toString();
            String source = call.from().component().rootID();
            if (source.startsWith(NetworkCoreRoot.PROXY_PREFIX)) {
                Root.Controller ctrl = NetworkCoreRoot.this.getHubAccessor().getRootController(source);
                NetworkCoreRoot.this.getHubAccessor().registerRootController(id, ctrl);
                NetworkCoreRoot.this.remotes.put(id, source);
            } else {
                List args = call.args();
                if (args.size() < 1) {
                    throw new IllegalArgumentException("Invalid response");
                }
                Root r = (Root)PReference.from((Value)((Value)args.get(0))).flatMap(ref -> ref.as(Root.class)).orElseThrow();
                NetworkCoreRoot.this.startRoot(id, NetworkCoreRoot.this.installRoot(id, r));
            }
            return active.reply();
        }
    }

    private class RemoveRootControl
    extends AbstractAsyncControl {
        private RemoveRootControl() {
        }

        protected Call processInvoke(Call call) throws Exception {
            String id = ((Value)call.args().get(0)).toString();
            String remoteProxy = NetworkCoreRoot.this.remotes.get(id);
            if (remoteProxy != null) {
                ControlAddress to = ControlAddress.of((ComponentAddress)ComponentAddress.of((String)("/" + remoteProxy)), (String)"remove-root");
                return Call.create((ControlAddress)to, (ControlAddress)call.to(), (long)call.time(), (List)call.args());
            }
            NetworkCoreRoot.this.uninstallRoot(id);
            return call.reply();
        }

        protected Call processResponse(Call call) throws Exception {
            Call active = this.getActiveCall();
            String id = ((Value)active.args().get(0)).toString();
            NetworkCoreRoot.this.getHubAccessor().unregisterRootController(id);
            NetworkCoreRoot.this.remotes.remove(id);
            return active.reply();
        }
    }

    private class HubConfigurationControl
    implements Control {
        private HubConfigurationControl() {
        }

        public void call(Call call, PacketRouter router) throws Exception {
            if (call.isRequest()) {
                if (NetworkCoreRoot.this.configuration != null) {
                    throw new IllegalStateException("Hub Configuration already fixed");
                }
                NetworkCoreRoot.this.configuration = HubConfiguration.fromMap((PMap)PMap.from((Value)((Value)call.args().get(0))).orElseThrow());
                NetworkCoreRoot.this.configure();
                if (call.isReplyRequired()) {
                    router.route((Packet)call.reply());
                }
            }
        }
    }

    private record ProxyData(ProxyInfo info, ComponentAddress address, Root.Controller controller) {
    }
}

