/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.hub.net;

import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.praxislive.core.Call;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.ControlAddress;
import org.praxislive.core.Protocol;
import org.praxislive.core.services.Service;
import org.praxislive.core.services.ServiceUnavailableException;
import org.praxislive.core.types.PError;
import org.praxislive.hub.net.Message;

abstract class MessageDispatcher {
    private static final System.Logger LOG = System.getLogger(MessageDispatcher.class.getName());
    static final String SYS_PREFIX = "/_sys";
    private final Map<Integer, SentCallInfo> sentCalls = new LinkedHashMap<Integer, SentCallInfo>();
    private final Map<Integer, ReceivedMessageInfo> receivedMessages = new HashMap<Integer, ReceivedMessageInfo>();

    MessageDispatcher() {
    }

    abstract void dispatchMessage(SocketAddress var1, Message var2) throws Exception;

    abstract void dispatchCall(Call var1);

    abstract String getRemoteSysPrefix();

    abstract SocketAddress getPrimaryRemoteAddress();

    abstract long getTime();

    abstract ComponentAddress findService(Class<? extends Service> var1) throws ServiceUnavailableException;

    void handleMessage(SocketAddress sender, Message msg) {
        try {
            if (msg instanceof Message.Send) {
                Message.Send sendMsg = (Message.Send)msg;
                this.handleSendMessage(sender, sendMsg);
            } else if (msg instanceof Message.Service) {
                Message.Service serviceMsg = (Message.Service)msg;
                this.handleServiceMessage(sender, serviceMsg);
            } else if (msg instanceof Message.Reply) {
                Message.Reply replyMsg = (Message.Reply)msg;
                this.handleReplyMessage(sender, replyMsg);
            } else if (msg instanceof Message.Error) {
                Message.Error errorMsg = (Message.Error)msg;
                this.handleErrorMessage(sender, errorMsg);
            }
        }
        catch (Exception e) {
            if (msg instanceof Message.Send || msg instanceof Message.Service) {
                try {
                    this.dispatchMessage(sender, new Message.Error(msg.matchID(), List.of(PError.of((Exception)e))));
                }
                catch (Exception ex) {
                    LOG.log(System.Logger.Level.WARNING, "Unable to dispatch error message", (Throwable)ex);
                }
            }
            LOG.log(System.Logger.Level.WARNING, "Unable to handle message", (Throwable)e);
        }
    }

    void handleCall(Call call) {
        if (call.isRequest()) {
            this.handleInvokeCall(call);
        } else {
            this.handleResponseCall(call);
        }
    }

    void handleServiceCall(Call call, String serviceName, String serviceControl) {
        this.handleServiceCallImpl(call, serviceName, serviceControl);
    }

    void purge(long time, TimeUnit unit) {
        long ago = unit.toNanos(time);
        long now = this.getTime();
        Iterator<SentCallInfo> itr = this.sentCalls.values().iterator();
        while (itr.hasNext()) {
            SentCallInfo info = itr.next();
            if (now - info.localCallTime() < ago) {
                LOG.log(System.Logger.Level.TRACE, "No calls to purge");
                break;
            }
            itr.remove();
            LOG.log(System.Logger.Level.TRACE, "Purging call\n{0}", info.localCall());
            Call err = info.localCall().error(PError.of((String)"Timeout"));
            this.dispatchCall(err);
        }
    }

    private void handleSendMessage(SocketAddress sender, Message.Send msg) throws Exception {
        ControlAddress to = msg.to();
        ControlAddress from = msg.from();
        Object fromString = from.toString();
        if (((String)fromString).startsWith(SYS_PREFIX)) {
            fromString = this.getRemoteSysPrefix() + (String)fromString;
            from = ControlAddress.parse((String)fromString);
        }
        Call call = Call.create((ControlAddress)to, (ControlAddress)from, (long)this.getTime(), msg.args());
        this.dispatchCall(call);
        this.receivedMessages.put(call.matchID(), new ReceivedMessageInfo(msg, sender));
    }

    private void handleServiceMessage(SocketAddress sender, Message.Service msg) throws Exception {
        Class service = Protocol.Type.fromName((String)msg.service()).map(Protocol.Type::asClass).filter(Service.class::isAssignableFrom).map(cls -> cls).orElseThrow(ServiceUnavailableException::new);
        ComponentAddress serviceAddress = this.findService(service);
        ControlAddress to = ControlAddress.of((ComponentAddress)serviceAddress, (String)msg.control());
        ControlAddress from = msg.from();
        Object fromString = from.toString();
        if (((String)fromString).startsWith(SYS_PREFIX)) {
            fromString = this.getRemoteSysPrefix() + (String)fromString;
            from = ControlAddress.parse((String)fromString);
        }
        Call call = Call.create((ControlAddress)to, (ControlAddress)from, (long)this.getTime(), msg.args());
        this.dispatchCall(call);
        this.receivedMessages.put(call.matchID(), new ReceivedMessageInfo(msg, sender));
    }

    private void handleReplyMessage(SocketAddress sender, Message.Reply msg) throws Exception {
        SentCallInfo info = this.sentCalls.remove(msg.matchID());
        if (info == null) {
            LOG.log(System.Logger.Level.DEBUG, "Unexpected message response\n{0}", msg);
            return;
        }
        Call call = info.localCall().reply(msg.args());
        this.dispatchCall(call);
    }

    private void handleErrorMessage(SocketAddress sender, Message.Error msg) throws Exception {
        SentCallInfo info = this.sentCalls.remove(msg.matchID());
        if (info == null) {
            LOG.log(System.Logger.Level.DEBUG, "Unexpected message response\n{0}", msg);
            return;
        }
        Call call = info.localCall().error(msg.args());
        this.dispatchCall(call);
    }

    private void handleInvokeCall(Call call) {
        ControlAddress to = call.to();
        String toString = to.toString();
        if (toString.startsWith(this.getRemoteSysPrefix())) {
            toString = toString.substring(this.getRemoteSysPrefix().length());
            to = ControlAddress.of((String)toString);
        }
        try {
            this.dispatchMessage(this.getPrimaryRemoteAddress(), new Message.Send(call.matchID(), to, call.from(), call.args()));
            this.sentCalls.put(call.matchID(), new SentCallInfo(call, this.getTime()));
        }
        catch (Exception ex) {
            this.dispatchCall(call.error(PError.of((Exception)ex)));
        }
    }

    private void handleServiceCallImpl(Call call, String serviceName, String serviceControl) {
        try {
            this.dispatchMessage(this.getPrimaryRemoteAddress(), new Message.Service(call.matchID(), serviceName, serviceControl, call.from(), call.args()));
            this.sentCalls.put(call.matchID(), new SentCallInfo(call, this.getTime()));
        }
        catch (Exception ex) {
            this.dispatchCall(call.error(PError.of((Exception)ex)));
        }
    }

    private void handleResponseCall(Call call) {
        ReceivedMessageInfo info = this.receivedMessages.remove(call.matchID());
        if (info == null) {
            LOG.log(System.Logger.Level.DEBUG, "Unexpected call response\n{0}", call);
            return;
        }
        Record msg = call.isError() ? new Message.Error(info.message().matchID(), call.args()) : new Message.Reply(info.message().matchID(), call.args());
        try {
            this.dispatchMessage(info.sender(), (Message)((Object)msg));
        }
        catch (Exception ex) {
            LOG.log(System.Logger.Level.WARNING, "Unable to send response", (Throwable)ex);
        }
    }

    private record SentCallInfo(Call localCall, long localCallTime) {
    }

    private record ReceivedMessageInfo(Message message, SocketAddress sender) {
    }
}

