/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.hub.net;

import com.amazon.ion.IonReader;
import com.amazon.ion.IonSystem;
import com.amazon.ion.IonType;
import com.amazon.ion.IonWriter;
import com.amazon.ion.SymbolTable;
import com.amazon.ion.system.IonSystemBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.praxislive.core.ControlAddress;
import org.praxislive.core.Value;
import org.praxislive.core.types.PArray;
import org.praxislive.core.types.PBoolean;
import org.praxislive.core.types.PBytes;
import org.praxislive.core.types.PError;
import org.praxislive.core.types.PMap;
import org.praxislive.core.types.PNumber;
import org.praxislive.core.types.PString;
import org.praxislive.hub.net.Message;

class IonCodec {
    private static final IonCodec DEFAULT = new IonCodec();
    private static final String SEND = "Send";
    private static final String SERVICE = "Service";
    private static final String REPLY = "Reply";
    private static final String ERROR = "Error";
    private static final String SYSTEM = "System";
    private static final String TYPE_MAP = "Map";
    private static final String TYPE_ARRAY = "Array";
    private static final String FIELD_MATCH_ID = "matchID";
    private static final String FIELD_TO = "to";
    private static final String FIELD_FROM = "from";
    private static final String FIELD_ARGS = "args";
    private static final String FIELD_QUIET = "quiet";
    private static final String FIELD_SERVICE = "service";
    private static final String FIELD_CONTROL = "control";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_DATA = "data";
    private final IonSystem system = IonSystemBuilder.standard().build();

    private IonCodec() {
    }

    void readMessages(InputStream in, Consumer<Message> out) throws IOException {
        try (IonReader reader = this.system.newReader(in);){
            IonType type;
            while ((type = reader.next()) != null) {
                out.accept(this.readMessage(reader));
            }
        }
    }

    List<Message> readMessages(byte[] data) throws IOException {
        ArrayList<Message> list = new ArrayList<Message>();
        try (ByteArrayInputStream input = new ByteArrayInputStream(data);){
            this.readMessages(input, list::add);
        }
        return list;
    }

    void writeMessages(List<Message> messages, OutputStream out) throws IOException {
        try (IonWriter writer = this.system.newBinaryWriter(out, new SymbolTable[0]);){
            for (Message message : messages) {
                if (message instanceof Message.Send) {
                    Message.Send send = (Message.Send)message;
                    this.writeSend(writer, send);
                    continue;
                }
                if (message instanceof Message.Service) {
                    Message.Service service = (Message.Service)message;
                    this.writeService(writer, service);
                    continue;
                }
                if (message instanceof Message.Reply) {
                    Message.Reply reply = (Message.Reply)message;
                    this.writeReply(writer, reply);
                    continue;
                }
                if (message instanceof Message.Error) {
                    Message.Error error = (Message.Error)message;
                    this.writeError(writer, error);
                    continue;
                }
                if (!(message instanceof Message.System)) continue;
                Message.System sys = (Message.System)message;
                this.writeSystem(writer, sys);
            }
        }
    }

    byte[] writeMessages(List<Message> messages) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.writeMessages(messages, bos);
        return bos.toByteArray();
    }

    private Message readMessage(IonReader reader) throws IOException {
        if (reader.getType() != IonType.STRUCT) {
            throw new IOException("Not an Ion Struct");
        }
        String[] annotations = reader.getTypeAnnotations();
        if (annotations.length != 1) {
            throw new IOException("Invalid annotations on message struct");
        }
        try {
            return switch (annotations[0]) {
                case SEND -> this.readSendMessage(reader);
                case SERVICE -> this.readServiceMessage(reader);
                case REPLY -> this.readReplyMessage(reader);
                case ERROR -> this.readErrorMessage(reader);
                case SYSTEM -> this.readSystemMessage(reader);
                default -> throw new IOException("Unknown message type");
            };
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    private Message.Send readSendMessage(IonReader reader) throws Exception {
        IonType type;
        Integer matchID = null;
        ControlAddress to = null;
        ControlAddress from = null;
        List<Value> args = List.of();
        PMap data = PMap.EMPTY;
        reader.stepIn();
        while ((type = reader.next()) != null) {
            switch (reader.getFieldName()) {
                case "matchID": {
                    matchID = reader.intValue();
                    break;
                }
                case "to": {
                    to = ControlAddress.of((String)reader.stringValue());
                    break;
                }
                case "from": {
                    from = ControlAddress.of((String)reader.stringValue());
                    break;
                }
                case "args": {
                    args = this.readValues(reader);
                    break;
                }
                case "data": {
                    data = this.readMap(reader);
                }
            }
        }
        reader.stepOut();
        return new Message.Send(matchID, to, from, args, data);
    }

    private Message.Service readServiceMessage(IonReader reader) throws Exception {
        IonType type;
        Integer matchID = null;
        String service = null;
        String control = null;
        ControlAddress from = null;
        List<Value> args = List.of();
        PMap data = PMap.EMPTY;
        reader.stepIn();
        while ((type = reader.next()) != null) {
            switch (reader.getFieldName()) {
                case "matchID": {
                    matchID = reader.intValue();
                    break;
                }
                case "service": {
                    service = reader.stringValue();
                    break;
                }
                case "control": {
                    control = reader.stringValue();
                    break;
                }
                case "from": {
                    from = ControlAddress.of((String)reader.stringValue());
                    break;
                }
                case "args": {
                    args = this.readValues(reader);
                    break;
                }
                case "data": {
                    data = this.readMap(reader);
                }
            }
        }
        reader.stepOut();
        return new Message.Service(matchID, service, control, from, args, data);
    }

    private Message.Reply readReplyMessage(IonReader reader) throws Exception {
        IonType type;
        Integer matchID = null;
        List<Value> args = List.of();
        PMap data = PMap.EMPTY;
        reader.stepIn();
        while ((type = reader.next()) != null) {
            switch (reader.getFieldName()) {
                case "matchID": {
                    matchID = reader.intValue();
                    break;
                }
                case "args": {
                    args = this.readValues(reader);
                    break;
                }
                case "data": {
                    data = this.readMap(reader);
                }
            }
        }
        reader.stepOut();
        return new Message.Reply(matchID, args, data);
    }

    private Message.Error readErrorMessage(IonReader reader) throws Exception {
        IonType type;
        Integer matchID = null;
        List<Value> args = List.of();
        PMap data = PMap.EMPTY;
        reader.stepIn();
        while ((type = reader.next()) != null) {
            switch (reader.getFieldName()) {
                case "matchID": {
                    matchID = reader.intValue();
                    break;
                }
                case "args": {
                    args = this.readValues(reader);
                    break;
                }
                case "data": {
                    data = this.readMap(reader);
                }
            }
        }
        reader.stepOut();
        return new Message.Error(matchID, args, data);
    }

    private Message.System readSystemMessage(IonReader reader) throws Exception {
        IonType type;
        Integer matchID = null;
        String msgType = null;
        PMap data = PMap.EMPTY;
        reader.stepIn();
        while ((type = reader.next()) != null) {
            switch (reader.getFieldName()) {
                case "matchID": {
                    matchID = reader.intValue();
                    break;
                }
                case "type": {
                    msgType = reader.stringValue();
                    break;
                }
                case "data": {
                    data = this.readMap(reader);
                }
            }
        }
        reader.stepOut();
        return new Message.System(matchID, msgType, data);
    }

    private List<Value> readValues(IonReader reader) throws Exception {
        if (reader.getType() != IonType.LIST) {
            throw new IllegalArgumentException("Not a list");
        }
        ArrayList<Value> list = new ArrayList<Value>();
        reader.stepIn();
        while (reader.next() != null) {
            list.add(this.readValue(reader));
        }
        reader.stepOut();
        return list;
    }

    private Value readValue(IonReader reader) throws Exception {
        return switch (reader.getType()) {
            case IonType.BLOB -> PBytes.valueOf((byte[])reader.newBytes());
            case IonType.BOOL -> PBoolean.of((boolean)reader.booleanValue());
            case IonType.FLOAT -> PNumber.of((double)reader.doubleValue());
            case IonType.INT -> PNumber.of((int)reader.intValue());
            case IonType.LIST -> {
                String[] annotations = reader.getTypeAnnotations();
                if (this.isMap(annotations)) {
                    yield this.readMapValue(annotations, reader);
                }
                yield PArray.of(this.readValues(reader));
            }
            default -> PString.of((String)reader.stringValue());
        };
    }

    private boolean isMap(String[] annotations) {
        for (String annotation : annotations) {
            if (!TYPE_MAP.equals(annotation)) continue;
            return true;
        }
        return false;
    }

    private Value readMapValue(String[] annotations, IonReader reader) throws Exception {
        Value.Type type = null;
        if (annotations.length > 1) {
            for (String annotation : annotations) {
                Value.Type vt;
                if (TYPE_MAP.equals(annotation) || (vt = (Value.Type)Value.Type.fromName((String)annotation).orElse(null)) == null || PError.class != vt.asClass() && !PMap.MapBasedValue.class.isAssignableFrom(vt.asClass())) continue;
                type = vt;
                break;
            }
        }
        PMap map = this.readMap(reader);
        if (type != null) {
            Value v = ((Optional)type.converter().apply(map)).orElse(null);
            return v == null ? map : v;
        }
        return map;
    }

    private PMap readMap(IonReader reader) throws Exception {
        if (reader.getType() != IonType.LIST) {
            throw new IllegalArgumentException("Not a list");
        }
        PMap.Builder b = PMap.builder();
        reader.stepIn();
        while (reader.next() != null) {
            String key = reader.stringValue();
            reader.next();
            Value value = this.readValue(reader);
            b.put(key, value);
        }
        reader.stepOut();
        return b.build();
    }

    private void writeValues(IonWriter writer, List<Value> values) throws IOException {
        writer.stepIn(IonType.LIST);
        for (Value value : values) {
            this.writeValue(writer, value);
        }
        writer.stepOut();
    }

    private void writeValue(IonWriter writer, Value value) throws IOException {
        if (value instanceof PNumber) {
            PNumber n = (PNumber)value;
            this.writeNumber(writer, n);
        } else if (value instanceof PArray) {
            PArray a = (PArray)value;
            this.writeArray(writer, a);
        } else if (value instanceof PBytes) {
            PBytes b = (PBytes)value;
            this.writeBytes(writer, b);
        } else if (value instanceof PBoolean) {
            PBoolean b = (PBoolean)value;
            writer.writeBool(b.value());
        } else if (value instanceof PMap) {
            PMap m = (PMap)value;
            this.writeMap(writer, m, TYPE_MAP);
        } else if (value instanceof PError) {
            PError e = (PError)value;
            this.writeMap(writer, e.dataMap(), ERROR, TYPE_MAP);
        } else if (value instanceof PMap.MapBasedValue) {
            PMap.MapBasedValue v = (PMap.MapBasedValue)value;
            this.writeMap(writer, v.dataMap(), v.type().name(), TYPE_MAP);
        } else {
            writer.writeString(value.toString());
        }
    }

    private void writeNumber(IonWriter writer, PNumber number) throws IOException {
        if (number.isInteger()) {
            writer.writeInt((long)number.toIntValue());
        } else {
            writer.writeFloat(number.value());
        }
    }

    private void writeMap(IonWriter writer, PMap map, String ... annotations) throws IOException {
        writer.setTypeAnnotations(annotations);
        writer.stepIn(IonType.LIST);
        for (String key : map.keys()) {
            writer.writeString(key);
            this.writeValue(writer, map.get(key));
        }
        writer.stepOut();
    }

    private void writeArray(IonWriter writer, PArray array) throws IOException {
        writer.setTypeAnnotations(new String[]{TYPE_ARRAY});
        writer.stepIn(IonType.LIST);
        for (Value value : array) {
            this.writeValue(writer, value);
        }
        writer.stepOut();
    }

    private void writeBytes(IonWriter writer, PBytes bytes) throws IOException {
        byte[] tmp = new byte[bytes.size()];
        bytes.read(tmp);
        writer.writeBlob(tmp);
    }

    private void writeSend(IonWriter writer, Message.Send message) throws IOException {
        PMap data;
        writer.addTypeAnnotation(SEND);
        writer.stepIn(IonType.STRUCT);
        writer.setFieldName(FIELD_MATCH_ID);
        writer.writeInt((long)message.matchID());
        writer.setFieldName(FIELD_TO);
        writer.writeString(message.to().toString());
        writer.setFieldName(FIELD_FROM);
        writer.writeString(message.from().toString());
        List<Value> args = message.args();
        if (!args.isEmpty()) {
            writer.setFieldName(FIELD_ARGS);
            this.writeValues(writer, message.args());
        }
        if (!(data = message.data()).isEmpty()) {
            writer.setFieldName(FIELD_DATA);
            this.writeMap(writer, message.data(), new String[0]);
        }
        writer.stepOut();
    }

    private void writeService(IonWriter writer, Message.Service message) throws IOException {
        PMap data;
        writer.addTypeAnnotation(SERVICE);
        writer.stepIn(IonType.STRUCT);
        writer.setFieldName(FIELD_MATCH_ID);
        writer.writeInt((long)message.matchID());
        writer.setFieldName(FIELD_SERVICE);
        writer.writeString(message.service());
        writer.setFieldName(FIELD_CONTROL);
        writer.writeString(message.control());
        writer.setFieldName(FIELD_FROM);
        writer.writeString(message.from().toString());
        List<Value> args = message.args();
        if (!args.isEmpty()) {
            writer.setFieldName(FIELD_ARGS);
            this.writeValues(writer, message.args());
        }
        if (!(data = message.data()).isEmpty()) {
            writer.setFieldName(FIELD_DATA);
            this.writeMap(writer, message.data(), new String[0]);
        }
        writer.stepOut();
    }

    private void writeReply(IonWriter writer, Message.Reply message) throws IOException {
        PMap data;
        writer.addTypeAnnotation(REPLY);
        writer.stepIn(IonType.STRUCT);
        writer.setFieldName(FIELD_MATCH_ID);
        writer.writeInt((long)message.matchID());
        List<Value> args = message.args();
        if (!args.isEmpty()) {
            writer.setFieldName(FIELD_ARGS);
            this.writeValues(writer, message.args());
        }
        if (!(data = message.data()).isEmpty()) {
            writer.setFieldName(FIELD_DATA);
            this.writeMap(writer, message.data(), new String[0]);
        }
        writer.stepOut();
    }

    private void writeError(IonWriter writer, Message.Error message) throws IOException {
        PMap data;
        writer.addTypeAnnotation(ERROR);
        writer.stepIn(IonType.STRUCT);
        writer.setFieldName(FIELD_MATCH_ID);
        writer.writeInt((long)message.matchID());
        List<Value> args = message.args();
        if (!args.isEmpty()) {
            writer.setFieldName(FIELD_ARGS);
            this.writeValues(writer, message.args());
        }
        if (!(data = message.data()).isEmpty()) {
            writer.setFieldName(FIELD_DATA);
            this.writeMap(writer, message.data(), new String[0]);
        }
        writer.stepOut();
    }

    private void writeSystem(IonWriter writer, Message.System message) throws IOException {
        writer.addTypeAnnotation(SYSTEM);
        writer.stepIn(IonType.STRUCT);
        writer.setFieldName(FIELD_MATCH_ID);
        writer.writeInt((long)message.matchID());
        writer.setFieldName(FIELD_TYPE);
        writer.writeString(message.type());
        PMap data = message.data();
        if (!data.isEmpty()) {
            writer.setFieldName(FIELD_DATA);
            this.writeMap(writer, message.data(), new String[0]);
        }
        writer.stepOut();
    }

    static IonCodec getDefault() {
        return DEFAULT;
    }
}

