/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.hub.net;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.praxislive.core.Value;
import org.praxislive.core.types.PMap;
import org.praxislive.hub.net.DefaultProxyInfo;
import org.praxislive.hub.net.ProxyInfo;

public final class HubConfiguration {
    private static final String KEY_FILESERVER = "enable-fileserver";
    private static final String KEY_PROXIES = "proxies";
    private final boolean fileServer;
    private final List<ProxyInfo> proxies;

    private HubConfiguration(Builder builder) {
        this.fileServer = builder.fileServer;
        this.proxies = List.copyOf(builder.proxies);
    }

    public boolean isFileServerEnabled() {
        return this.fileServer;
    }

    public List<ProxyInfo> proxies() {
        return this.proxies;
    }

    public static HubConfiguration fromMap(PMap configuration) {
        Builder builder = HubConfiguration.builder();
        builder.enableFileServer(configuration.getBoolean(KEY_FILESERVER, false));
        Value value = configuration.get(KEY_PROXIES);
        if (value == null) {
            value = PMap.EMPTY;
        }
        PMap proxyMap = (PMap)PMap.from((Value)value).orElseThrow(IllegalArgumentException::new);
        proxyMap.keys().forEach(id -> builder.proxy(DefaultProxyInfo.fromMap((PMap)PMap.from((Value)proxyMap.get(id)).orElseThrow(IllegalArgumentException::new))));
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final List<ProxyInfo> proxies = new ArrayList<ProxyInfo>();
        private boolean fileServer;

        private Builder() {
        }

        public Builder enableFileServer(boolean enable) {
            this.fileServer = enable;
            return this;
        }

        public Builder proxy(ProxyInfo proxy) {
            this.proxies.add(Objects.requireNonNull(proxy));
            return this;
        }

        public HubConfiguration build() {
            return new HubConfiguration(this);
        }
    }
}

