/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.hub.net;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.praxislive.base.AbstractRoot;
import org.praxislive.core.Call;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.Control;
import org.praxislive.core.ExecutionContext;
import org.praxislive.core.Packet;
import org.praxislive.core.PacketRouter;
import org.praxislive.core.Protocol;
import org.praxislive.core.Value;
import org.praxislive.core.services.RootManagerService;
import org.praxislive.core.services.Service;
import org.praxislive.core.services.ServiceUnavailableException;
import org.praxislive.core.services.Services;
import org.praxislive.core.types.PArray;
import org.praxislive.core.types.PError;
import org.praxislive.core.types.PMap;
import org.praxislive.core.types.PString;
import org.praxislive.hub.net.ChildLauncher;
import org.praxislive.hub.net.ChildRegistry;
import org.praxislive.hub.net.FileServer;
import org.praxislive.hub.net.IonDecoder;
import org.praxislive.hub.net.IonEncoder;
import org.praxislive.hub.net.Message;
import org.praxislive.hub.net.MessageDispatcher;
import org.praxislive.hub.net.NetworkCoreRoot;
import org.praxislive.hub.net.ProxyInfo;
import org.praxislive.hub.net.Utils;

class ProxyClientRoot
extends AbstractRoot {
    private static final System.Logger LOG = System.getLogger(ProxyClientRoot.class.getName());
    private final ProxyInfo proxyInfo;
    private final EventLoopGroup eventLoopGroup;
    private final List<Class<? extends Service>> exposedServices;
    private final ChildLauncher childLauncher;
    private final FileServer.Info fileServerInfo;
    private final Dispatcher dispatcher;
    private final Control addRootControl;
    private final Control removeRootControl;
    private Channel clientChannel;
    private long lastPurgeTime;
    private Process execProcess;
    private SocketAddress socketAddress;
    private String remoteSysPrefix;

    ProxyClientRoot(ProxyInfo proxyInfo, EventLoopGroup eventLoopGroup, List<Class<? extends Service>> exposedServices, ChildLauncher childLauncher, FileServer.Info fileServerInfo) {
        this.proxyInfo = proxyInfo;
        this.eventLoopGroup = eventLoopGroup;
        this.exposedServices = exposedServices;
        this.childLauncher = childLauncher;
        this.fileServerInfo = fileServerInfo;
        this.dispatcher = new Dispatcher();
        this.addRootControl = new RootControl(true);
        this.removeRootControl = new RootControl(false);
    }

    protected void activating() {
        this.lastPurgeTime = this.getExecutionContext().getTime();
        this.remoteSysPrefix = this.getAddress().toString() + "/_remote";
        this.setRunning();
    }

    protected void terminating() {
        super.terminating();
        if (this.clientChannel != null) {
            this.clientChannel.writeAndFlush(List.of(new Message.System(0, "GOODBYE", PMap.EMPTY)));
        }
        this.dispose();
        try {
            this.eventLoopGroup.shutdownGracefully(100L, 100L, TimeUnit.MILLISECONDS).sync();
        }
        catch (Exception ex) {
            LOG.log(System.Logger.Level.WARNING, "Error closing down proxy client", (Throwable)ex);
        }
        this.destroyChild();
    }

    protected void processCall(Call call, PacketRouter router) {
        if (this.getState() != AbstractRoot.State.ACTIVE_RUNNING) {
            if (call.isReplyRequired()) {
                router.route((Packet)call.error(PError.of((String)"Terminated")));
            }
            return;
        }
        ComponentAddress address = this.getAddress();
        ComponentAddress toComponent = call.to().component();
        if (toComponent.equals((Object)address)) {
            try {
                switch (call.to().controlID()) {
                    case "add-root": {
                        this.addRootControl.call(call, router);
                        break;
                    }
                    case "remove-root": {
                        this.removeRootControl.call(call, router);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
            catch (Exception ex) {
                router.route((Packet)call.error(PError.of((Exception)ex)));
            }
            return;
        }
        if (this.clientChannel == null) {
            this.connect();
            if (this.clientChannel == null) {
                this.getRouter().route((Packet)call.error(PError.of((String)"")));
                return;
            }
        }
        if (toComponent.rootID().equals(address.rootID()) && toComponent.depth() == 3 && "services".equals(toComponent.componentID(1))) {
            this.dispatcher.handleServiceCall(call, toComponent.componentID(2), call.to().controlID());
        } else {
            this.dispatcher.handleCall(call);
        }
    }

    protected void update() {
        ExecutionContext source = this.getExecutionContext();
        if (source.getTime() - this.lastPurgeTime > TimeUnit.SECONDS.toNanos(1L)) {
            this.dispatcher.purge(NetworkCoreRoot.TIMEOUT, TimeUnit.SECONDS);
            this.lastPurgeTime = source.getTime();
        }
    }

    private void connect() {
        try {
            this.checkAndExecChild();
            CountDownLatch helloLatch = new CountDownLatch(1);
            final Receiver receiver = new Receiver(helloLatch);
            Bootstrap bootstrap = new Bootstrap();
            ((Bootstrap)((Bootstrap)bootstrap.group(this.eventLoopGroup)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer(this){

                protected void initChannel(Channel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new IonEncoder(), new IonDecoder(), receiver});
                }
            });
            this.clientChannel = bootstrap.connect(this.socketAddress).sync().channel();
            this.clientChannel.writeAndFlush(List.of(new Message.System(0, "HELLO", this.buildHLOParams()))).sync();
            if (helloLatch.await(10L, TimeUnit.SECONDS)) {
                LOG.log(System.Logger.Level.DEBUG, "/HLO received OK");
            } else {
                LOG.log(System.Logger.Level.ERROR, "Unable to connect");
                this.dispose();
            }
        }
        catch (Exception ex) {
            LOG.log(System.Logger.Level.ERROR, "Unable to connect", (Throwable)ex);
            this.dispose();
        }
    }

    private void handleMessages(List<Message> messages) {
        for (Message msg : messages) {
            if (!this.handleMessage(msg)) break;
        }
    }

    private boolean handleMessage(Message message) {
        if (message instanceof Message.System) {
            Message.System systemMessage = (Message.System)message;
            return switch (systemMessage.type()) {
                case "HELLO-OK" -> this.handleHelloOKMessage(systemMessage);
                case "HELLO-ERROR" -> this.handleHelloErrorMessage(systemMessage);
                default -> {
                    LOG.log(System.Logger.Level.WARNING, "Unexpected system message {0}", systemMessage);
                    yield true;
                }
            };
        }
        this.dispatcher.handleMessage(this.socketAddress, message);
        return true;
    }

    private boolean handleHelloOKMessage(Message.System helloOK) {
        return true;
    }

    private boolean handleHelloErrorMessage(Message.System helloError) {
        return false;
    }

    private void checkAndExecChild() throws Exception {
        if (this.execProcess != null) {
            if (this.execProcess.isAlive()) {
                LOG.log(System.Logger.Level.INFO, "Child process already running");
                return;
            }
            throw new IllegalStateException("Child process terminated");
        }
        ProxyInfo.Exec exec = this.proxyInfo.exec().orElse(null);
        if (exec == null) {
            this.socketAddress = this.proxyInfo.socketAddress();
            return;
        }
        String cmd = exec.command().orElse(null);
        if (cmd == null) {
            if (this.childLauncher == null) {
                throw new IllegalStateException("No child launcher for exec");
            }
        } else {
            throw new UnsupportedOperationException("Only default command supported at present");
        }
        ChildLauncher.Info childInfo = this.childLauncher.launch(exec.javaOptions(), exec.arguments());
        this.execProcess = childInfo.handle();
        this.socketAddress = childInfo.address();
        ChildRegistry.INSTANCE.add(this.execProcess);
    }

    private PMap buildHLOParams() {
        PMap.Builder params = PMap.builder();
        params.put("remote-services", (Value)this.buildServices());
        if (!this.proxyInfo.isLocal()) {
            params.put("master-user-directory", Utils.getUserDirectory().toURI().toString());
            if (this.fileServerInfo != null) {
                params.put("file-server-port", this.fileServerInfo.port());
            }
        }
        return params.build();
    }

    private PArray buildServices() {
        return (PArray)this.exposedServices.stream().map(Protocol.Type::of).map(Protocol.Type::name).map(PString::of).collect(PArray.collector());
    }

    private void dispose() {
        if (this.clientChannel != null) {
            this.clientChannel.close();
            this.clientChannel = null;
        }
        this.dispatcher.purge(0L, TimeUnit.NANOSECONDS);
    }

    private void destroyChild() {
        if (this.execProcess != null) {
            boolean exited = false;
            try {
                this.execProcess.destroy();
                exited = this.execProcess.waitFor(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!exited) {
                this.execProcess.destroyForcibly();
                try {
                    this.execProcess.waitFor(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException ex) {
                    LOG.log(System.Logger.Level.ERROR, "Child process won't quit", (Throwable)ex);
                }
            }
            ChildRegistry.INSTANCE.remove(this.execProcess);
            this.execProcess = null;
        }
    }

    private class Dispatcher
    extends MessageDispatcher {
        private Dispatcher() {
        }

        @Override
        void dispatchCall(Call call) {
            ProxyClientRoot.this.getRouter().route((Packet)call);
        }

        @Override
        void dispatchMessage(SocketAddress remote, Message msg) throws Exception {
            if (!remote.equals(ProxyClientRoot.this.socketAddress)) {
                throw new IllegalArgumentException("Unknown remote address");
            }
            ProxyClientRoot.this.clientChannel.writeAndFlush(List.of(msg));
        }

        @Override
        ComponentAddress findService(Class<? extends Service> service) throws ServiceUnavailableException {
            return (ComponentAddress)ProxyClientRoot.this.getLookup().find(Services.class).flatMap(sm -> sm.locateAll(service).filter(cmp -> !cmp.rootID().equals(ProxyClientRoot.this.getAddress().rootID())).findFirst()).orElseThrow(() -> new ServiceUnavailableException(service.toString()));
        }

        @Override
        SocketAddress getPrimaryRemoteAddress() {
            return ProxyClientRoot.this.socketAddress;
        }

        @Override
        long getTime() {
            return ProxyClientRoot.this.getExecutionContext().getTime();
        }

        @Override
        String getRemoteSysPrefix() {
            assert (ProxyClientRoot.this.remoteSysPrefix != null);
            return ProxyClientRoot.this.remoteSysPrefix;
        }
    }

    private class RootControl
    implements Control {
        private final String service = Protocol.Type.of(RootManagerService.class).name();
        private final String serviceControl;

        private RootControl(boolean add) {
            this.serviceControl = add ? "add-root" : "remove-root";
        }

        public void call(Call call, PacketRouter router) throws Exception {
            if (call.isRequest()) {
                if (ProxyClientRoot.this.clientChannel != null) {
                    ProxyClientRoot.this.dispatcher.handleServiceCall(call, this.service, this.serviceControl);
                } else {
                    ProxyClientRoot.this.connect();
                    if (ProxyClientRoot.this.clientChannel != null) {
                        ProxyClientRoot.this.dispatcher.handleServiceCall(call, this.service, this.serviceControl);
                    } else {
                        router.route((Packet)call.error(PError.of((String)"Couldn't connect to client")));
                    }
                }
            }
        }
    }

    private class Receiver
    extends SimpleChannelInboundHandler<List<Message>> {
        private CountDownLatch hloLatch;

        private Receiver(CountDownLatch hloLatch) {
            this.hloLatch = hloLatch;
        }

        protected void channelRead0(ChannelHandlerContext ctx, List<Message> msg) throws Exception {
            if (this.hloLatch != null) {
                this.hloLatch.countDown();
                this.hloLatch = null;
            }
            ProxyClientRoot.this.invokeLater(() -> ProxyClientRoot.this.handleMessages(msg));
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            ProxyClientRoot.this.invokeLater(() -> ProxyClientRoot.this.dispose());
        }
    }
}

