/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.hub.net;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Pattern;

class FileServer {
    private final Path allowedRoot;
    private final int port;
    private Channel serverChannel;
    private EventLoopGroup eventLoopGroup;

    FileServer(Path allowedRoot) {
        this(allowedRoot, 0);
    }

    FileServer(Path allowedRoot, int port) {
        if (!allowedRoot.isAbsolute() || !Files.isDirectory(allowedRoot, new LinkOption[0])) {
            throw new IllegalArgumentException();
        }
        this.allowedRoot = allowedRoot;
        this.port = port;
    }

    synchronized Info start() throws IOException {
        if (this.eventLoopGroup != null) {
            throw new IllegalStateException("File server not restartable");
        }
        this.eventLoopGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap bootstrap = new ServerBootstrap();
            ((ServerBootstrap)bootstrap.group(this.eventLoopGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer(){

                protected void initChannel(Channel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new HttpServerCodec(), new HttpObjectAggregator(65536), new ChunkedWriteHandler(), new Handler(FileServer.this.allowedRoot)});
                }
            });
            this.serverChannel = bootstrap.bind(this.port).sync().channel();
            return new Info(((InetSocketAddress)this.serverChannel.localAddress()).getPort());
        }
        catch (Exception ex) {
            if (this.eventLoopGroup != null) {
                this.eventLoopGroup.shutdownGracefully();
            }
            throw new IOException();
        }
    }

    synchronized void stop() {
        if (this.serverChannel != null) {
            this.serverChannel.close();
        }
        if (this.eventLoopGroup != null) {
            this.eventLoopGroup.shutdownGracefully();
        }
    }

    record Info(int port) {
    }

    private static class Handler
    extends SimpleChannelInboundHandler<FullHttpRequest> {
        private static final String HTTP_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
        private static final String HTTP_DATE_GMT_TIMEZONE = "GMT";
        private static final int HTTP_CACHE_SECONDS = 60;
        private final Path allowedRoot;
        private FullHttpRequest request;
        private static final Pattern ALLOWED_FILE_NAME = Pattern.compile("[^-\\._]?[^<>&\\\"]*");

        private Handler(Path allowedRoot) {
            this.allowedRoot = allowedRoot;
        }

        public void channelRead0(ChannelHandlerContext ctx, FullHttpRequest request) throws Exception {
            RandomAccessFile raf;
            long fileLastModifiedSeconds;
            SimpleDateFormat dateFormatter;
            Date ifModifiedSinceDate;
            long ifModifiedSinceDateSeconds;
            this.request = request;
            if (!request.decoderResult().isSuccess()) {
                this.sendError(ctx, HttpResponseStatus.BAD_REQUEST);
                return;
            }
            if (!HttpMethod.GET.equals((Object)request.method())) {
                this.sendError(ctx, HttpResponseStatus.METHOD_NOT_ALLOWED);
                return;
            }
            boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)request);
            String uri = request.uri();
            Path path = Path.of(new URI("file:///").resolve(new URI(uri).getRawPath())).toRealPath(new LinkOption[0]);
            if (path == null || !path.startsWith(this.allowedRoot)) {
                this.sendError(ctx, HttpResponseStatus.FORBIDDEN);
                return;
            }
            if (Files.isHidden(path) || !Files.exists(path, new LinkOption[0])) {
                this.sendError(ctx, HttpResponseStatus.NOT_FOUND);
                return;
            }
            if (Files.isDirectory(path, new LinkOption[0])) {
                if (uri.endsWith("/")) {
                    this.sendListing(ctx, path, uri);
                } else {
                    this.sendRedirect(ctx, uri + "/");
                }
                return;
            }
            if (!Files.isRegularFile(path, new LinkOption[0])) {
                this.sendError(ctx, HttpResponseStatus.FORBIDDEN);
                return;
            }
            String ifModifiedSince = request.headers().get((CharSequence)HttpHeaderNames.IF_MODIFIED_SINCE);
            if (ifModifiedSince != null && !ifModifiedSince.isEmpty() && (ifModifiedSinceDateSeconds = (ifModifiedSinceDate = (dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US)).parse(ifModifiedSince)).getTime() / 1000L) == (fileLastModifiedSeconds = path.toFile().lastModified() / 1000L)) {
                this.sendNotModified(ctx);
                return;
            }
            File file = path.toFile();
            try {
                raf = new RandomAccessFile(file, "r");
            }
            catch (FileNotFoundException ignore) {
                this.sendError(ctx, HttpResponseStatus.NOT_FOUND);
                return;
            }
            long fileLength = raf.length();
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            HttpUtil.setContentLength((HttpMessage)response, (long)fileLength);
            Handler.setContentTypeHeader((HttpResponse)response, file);
            Handler.setDateAndCacheHeaders((HttpResponse)response, file);
            if (!keepAlive) {
                response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
            } else if (request.protocolVersion().equals((Object)HttpVersion.HTTP_1_0)) {
                response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            }
            ctx.write((Object)response);
            ChannelFuture sendFileFuture = ctx.write((Object)new DefaultFileRegion(raf.getChannel(), 0L, fileLength), (ChannelPromise)ctx.newProgressivePromise());
            ChannelFuture lastContentFuture = ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
            if (!keepAlive) {
                lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            cause.printStackTrace();
            if (ctx.channel().isActive()) {
                this.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
            }
        }

        private void sendListing(ChannelHandlerContext ctx, Path dir, String dirPath) {
            StringBuilder buf = new StringBuilder().append("<!DOCTYPE html>\r\n").append("<html><head><meta charset='utf-8' /><title>").append("Listing of: ").append(dirPath).append("</title></head><body>\r\n").append("<h3>Listing of: ").append(dirPath).append("</h3>\r\n").append("<ul>").append("<li><a href=\"../\">..</a></li>\r\n");
            File[] files = dir.toFile().listFiles();
            if (files != null) {
                for (File f : files) {
                    String name;
                    if (f.isHidden() || !f.canRead() || !ALLOWED_FILE_NAME.matcher(name = f.getName()).matches()) continue;
                    buf.append("<li><a href=\"").append(name).append("\">").append(name).append("</a></li>\r\n");
                }
            }
            buf.append("</ul></body></html>\r\n");
            ByteBuf buffer = ctx.alloc().buffer(buf.length());
            buffer.writeCharSequence((CharSequence)buf.toString(), CharsetUtil.UTF_8);
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, buffer);
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html; charset=UTF-8");
            this.sendAndCleanupConnection(ctx, (FullHttpResponse)response);
        }

        private void sendRedirect(ChannelHandlerContext ctx, String newUri) {
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FOUND, Unpooled.EMPTY_BUFFER);
            response.headers().set((CharSequence)HttpHeaderNames.LOCATION, (Object)newUri);
            this.sendAndCleanupConnection(ctx, (FullHttpResponse)response);
        }

        private void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.copiedBuffer((CharSequence)("Failure: " + String.valueOf(status) + "\r\n"), (Charset)CharsetUtil.UTF_8));
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain; charset=UTF-8");
            this.sendAndCleanupConnection(ctx, (FullHttpResponse)response);
        }

        private void sendNotModified(ChannelHandlerContext ctx) {
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_MODIFIED, Unpooled.EMPTY_BUFFER);
            Handler.setDateHeader((FullHttpResponse)response);
            this.sendAndCleanupConnection(ctx, (FullHttpResponse)response);
        }

        private void sendAndCleanupConnection(ChannelHandlerContext ctx, FullHttpResponse response) {
            FullHttpRequest request = this.request;
            boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)request);
            HttpUtil.setContentLength((HttpMessage)response, (long)response.content().readableBytes());
            if (!keepAlive) {
                response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
            } else if (request.protocolVersion().equals((Object)HttpVersion.HTTP_1_0)) {
                response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            }
            ChannelFuture flushPromise = ctx.writeAndFlush((Object)response);
            if (!keepAlive) {
                flushPromise.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }

        private static void setDateHeader(FullHttpResponse response) {
            SimpleDateFormat dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US);
            dateFormatter.setTimeZone(TimeZone.getTimeZone(HTTP_DATE_GMT_TIMEZONE));
            GregorianCalendar time = new GregorianCalendar();
            response.headers().set((CharSequence)HttpHeaderNames.DATE, (Object)dateFormatter.format(time.getTime()));
        }

        private static void setDateAndCacheHeaders(HttpResponse response, File fileToCache) {
            SimpleDateFormat dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US);
            dateFormatter.setTimeZone(TimeZone.getTimeZone(HTTP_DATE_GMT_TIMEZONE));
            GregorianCalendar time = new GregorianCalendar();
            response.headers().set((CharSequence)HttpHeaderNames.DATE, (Object)dateFormatter.format(time.getTime()));
            ((Calendar)time).add(13, 60);
            response.headers().set((CharSequence)HttpHeaderNames.EXPIRES, (Object)dateFormatter.format(time.getTime()));
            response.headers().set((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)"private, max-age=60");
            response.headers().set((CharSequence)HttpHeaderNames.LAST_MODIFIED, (Object)dateFormatter.format(new Date(fileToCache.lastModified())));
        }

        private static void setContentTypeHeader(HttpResponse response, File file) {
        }
    }
}

