/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.hub.net;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.praxislive.core.Call;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.Packet;
import org.praxislive.core.PacketRouter;
import org.praxislive.core.Protocol;
import org.praxislive.core.Root;
import org.praxislive.core.Value;
import org.praxislive.core.services.Service;
import org.praxislive.core.services.ServiceUnavailableException;
import org.praxislive.core.services.Services;
import org.praxislive.core.types.PArray;
import org.praxislive.core.types.PMap;
import org.praxislive.core.types.PResource;
import org.praxislive.hub.Hub;
import org.praxislive.hub.net.CIDRUtils;
import org.praxislive.hub.net.ChildLauncher;
import org.praxislive.hub.net.HubConfiguration;
import org.praxislive.hub.net.IonDecoder;
import org.praxislive.hub.net.IonEncoder;
import org.praxislive.hub.net.Message;
import org.praxislive.hub.net.MessageDispatcher;
import org.praxislive.hub.net.NetworkCoreFactory;
import org.praxislive.hub.net.NetworkCoreRoot;
import org.praxislive.hub.net.Utils;

class ServerCoreRoot
extends NetworkCoreRoot {
    private static final System.Logger LOG = System.getLogger(ServerCoreRoot.class.getName());
    private final InetSocketAddress localAddress;
    private final CIDRUtils clientValidator;
    private final Dispatcher dispatcher;
    private final ResourceResolver resourceResolver;
    private final Map<SocketAddress, Channel> connections;
    private EventLoopGroup eventLoopGroup;
    private Channel serverChannel;
    private SocketAddress parent;
    private long lastPurgeTime;
    private URI remoteUserDir;
    private URI remoteFileServer;
    private CompletableFuture<NetworkCoreFactory.Info> futureInfo;
    private String remoteSysPrefix;

    ServerCoreRoot(Hub.Accessor hubAccess, List<Root> exts, List<Class<? extends Service>> services, ChildLauncher childLauncher, HubConfiguration configuration, InetSocketAddress address, CIDRUtils clientValidator, CompletableFuture<NetworkCoreFactory.Info> futureInfo) {
        super(hubAccess, exts, services, childLauncher, configuration);
        this.localAddress = address;
        this.clientValidator = clientValidator;
        this.dispatcher = new Dispatcher();
        this.resourceResolver = new ResourceResolver();
        this.futureInfo = futureInfo;
        this.connections = new ConcurrentHashMap<SocketAddress, Channel>();
    }

    @Override
    protected void starting() {
        this.remoteSysPrefix = this.getAddress().toString() + "/_remote";
        this.eventLoopGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap bootstrap = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)bootstrap.group(this.eventLoopGroup).channel(NioServerSocketChannel.class)).localAddress((SocketAddress)this.localAddress)).childHandler((ChannelHandler)new ChannelInitializer(){

                protected void initChannel(Channel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new IonEncoder(), new IonDecoder(), new Receiver()});
                }
            });
            this.serverChannel = bootstrap.bind().sync().channel();
            if (this.futureInfo != null) {
                this.futureInfo.complete(new NetworkCoreFactory.Info(this.serverChannel.localAddress()));
                this.futureInfo = null;
            }
        }
        catch (Exception ex) {
            LOG.log(System.Logger.Level.ERROR, "Error starting server", (Throwable)ex);
            if (this.futureInfo != null) {
                this.futureInfo.completeExceptionally(ex);
                this.futureInfo = null;
            }
            this.forceTermination();
            throw new RuntimeException(ex);
        }
        super.starting();
    }

    @Override
    protected void terminating() {
        super.terminating();
        try {
            if (this.serverChannel != null) {
                this.serverChannel.close();
            }
            if (this.eventLoopGroup != null) {
                this.eventLoopGroup.shutdownGracefully(100L, 100L, TimeUnit.MILLISECONDS).sync();
            }
        }
        catch (Exception ex) {
            LOG.log(System.Logger.Level.WARNING, "Error shutting down server", (Throwable)ex);
        }
        finally {
            this.serverChannel = null;
            this.eventLoopGroup = null;
            this.parent = null;
        }
    }

    protected void processCall(Call call, PacketRouter router) {
        ComponentAddress address = this.getAddress();
        ComponentAddress toComponent = call.to().component();
        if (toComponent.equals((Object)address)) {
            super.processCall(call, router);
        } else if (toComponent.rootID().equals(address.rootID()) && toComponent.depth() == 3 && "services".equals(toComponent.componentID(1))) {
            this.dispatcher.handleServiceCall(call, toComponent.componentID(2), call.to().controlID());
        } else {
            this.dispatcher.handleCall(call);
        }
    }

    PResource.Resolver getResourceResolver() {
        return this.resourceResolver;
    }

    protected void update() {
        super.update();
        long time = this.getExecutionContext().getTime();
        if (time - this.lastPurgeTime > TimeUnit.SECONDS.toNanos(1L)) {
            LOG.log(System.Logger.Level.TRACE, "Triggering dispatcher purge");
            this.dispatcher.purge(10L, TimeUnit.SECONDS);
            this.lastPurgeTime = time;
        }
    }

    private void handleMessages(SocketAddress sender, List<Message> messages) {
        for (Message msg : messages) {
            if (!this.handleMessage(sender, msg)) break;
        }
    }

    private boolean handleMessage(SocketAddress sender, Message message) {
        Message.System sysMsg;
        if (!(this.parent != null && this.parent.equals(sender) || message instanceof Message.System && "HELLO".equals((sysMsg = (Message.System)message).type()))) {
            LOG.log(System.Logger.Level.WARNING, "Received unexpected message from {0}", sender);
            return false;
        }
        if (message instanceof Message.System) {
            Message.System systemMessage = (Message.System)message;
            return switch (systemMessage.type()) {
                case "HELLO" -> this.handleHello(sender, systemMessage);
                case "GOODBYE" -> this.handleGoodbye(sender, systemMessage);
                default -> {
                    LOG.log(System.Logger.Level.WARNING, "Unexpected system message {0}", systemMessage);
                    yield true;
                }
            };
        }
        this.dispatcher.handleMessage(sender, message);
        return true;
    }

    private boolean handleHello(SocketAddress sender, Message.System helloMessage) {
        if (this.parent != null) {
            if (this.parent.equals(sender)) {
                LOG.log(System.Logger.Level.DEBUG, "Duplicate Hello message from {0}", sender);
                return true;
            }
            LOG.log(System.Logger.Level.ERROR, "Unexpected Hello message from {0}", sender);
            return false;
        }
        try {
            if (this.validate(sender) && this.handleHelloData(sender, helloMessage.data())) {
                this.connections.get(sender).writeAndFlush(List.of(new Message.System(helloMessage.matchID(), "HELLO-OK", PMap.EMPTY)));
                this.parent = sender;
                return true;
            }
        }
        catch (Exception ex) {
            LOG.log(System.Logger.Level.ERROR, "Error during hello handling", (Throwable)ex);
        }
        return false;
    }

    private boolean handleGoodbye(SocketAddress sender, Message.System goodbyeMessage) {
        if (this.parent != null && this.parent.equals(sender)) {
            this.parent = null;
            this.forceTermination();
        }
        return false;
    }

    private boolean validate(SocketAddress sender) {
        if (this.clientValidator == null) {
            return true;
        }
        if (sender instanceof InetSocketAddress) {
            InetSocketAddress inet = (InetSocketAddress)sender;
            try {
                return this.clientValidator.isInRange(inet.getHostString());
            }
            catch (UnknownHostException ex) {
                LOG.log(System.Logger.Level.ERROR, "Unable to validate connection", (Throwable)ex);
            }
        }
        return false;
    }

    private boolean handleHelloData(SocketAddress sender, PMap data) {
        try {
            int fileServerPort;
            PArray services;
            String masterUserDir = data.getString("master-user-directory", null);
            if (masterUserDir != null) {
                this.remoteUserDir = URI.create(masterUserDir);
            }
            if (!(services = PArray.parse((String)data.getString("remote-services", ""))).isEmpty()) {
                for (Value serviceName : services) {
                    try {
                        Class service = Protocol.Type.fromName((String)serviceName.toString()).map(Protocol.Type::asClass).filter(Service.class::isAssignableFrom).orElseThrow(ClassNotFoundException::new);
                        ComponentAddress serviceAddress = ComponentAddress.of((String)(String.valueOf(this.getAddress()) + "/services/" + String.valueOf(serviceName)));
                        this.getHubAccessor().registerService(service, serviceAddress);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        LOG.log(System.Logger.Level.DEBUG, "Service {0} not known.", serviceName);
                    }
                }
            }
            if ((fileServerPort = data.getInt("file-server-port", 0)) > 0) {
                this.remoteFileServer = URI.create("http://" + ((InetSocketAddress)sender).getAddress().getHostAddress() + ":" + fileServerPort);
            }
            return true;
        }
        catch (Exception ex) {
            LOG.log(System.Logger.Level.ERROR, "Error configuring hello parameters", (Throwable)ex);
            return false;
        }
    }

    private class Dispatcher
    extends MessageDispatcher {
        private Dispatcher() {
        }

        @Override
        void dispatchCall(Call call) {
            ServerCoreRoot.this.getRouter().route((Packet)call);
        }

        @Override
        void dispatchMessage(SocketAddress remote, Message msg) {
            ServerCoreRoot.this.connections.get(remote).writeAndFlush(List.of(msg));
        }

        @Override
        ComponentAddress findService(Class<? extends Service> service) throws ServiceUnavailableException {
            return (ComponentAddress)ServerCoreRoot.this.getLookup().find(Services.class).flatMap(sm -> sm.locateAll(service).filter(cmp -> !cmp.rootID().equals(ServerCoreRoot.this.getAddress().rootID()) || cmp.depth() == 1).findFirst()).orElseThrow(() -> new ServiceUnavailableException(service.toString()));
        }

        @Override
        SocketAddress getPrimaryRemoteAddress() {
            return ServerCoreRoot.this.parent;
        }

        @Override
        long getTime() {
            return ServerCoreRoot.this.getExecutionContext().getTime();
        }

        @Override
        String getRemoteSysPrefix() {
            assert (ServerCoreRoot.this.remoteSysPrefix != null);
            return ServerCoreRoot.this.remoteSysPrefix;
        }
    }

    private class ResourceResolver
    implements PResource.Resolver {
        private ResourceResolver() {
        }

        public List<URI> resolve(PResource resource) {
            URI dir = ServerCoreRoot.this.remoteUserDir;
            URI srv = ServerCoreRoot.this.remoteFileServer;
            URI res = resource.value();
            if (dir == null && srv == null) {
                return Collections.singletonList(res);
            }
            if (!"file".equals(res.getScheme())) {
                return Collections.singletonList(res);
            }
            ArrayList<URI> uris = new ArrayList<URI>(2);
            if (dir != null) {
                uris.add(Utils.getUserDirectory().toURI().resolve(dir.relativize(res)));
            }
            if (srv != null) {
                uris.add(srv.resolve(res.getRawPath()));
            }
            return uris;
        }
    }

    private class Receiver
    extends SimpleChannelInboundHandler<List<Message>> {
        private Receiver() {
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            super.channelActive(ctx);
            ServerCoreRoot.this.connections.put(ctx.channel().remoteAddress(), ctx.channel());
        }

        protected void channelRead0(ChannelHandlerContext ctx, List<Message> msgs) throws Exception {
            SocketAddress address = ctx.channel().remoteAddress();
            ServerCoreRoot.this.invokeLater(() -> ServerCoreRoot.this.handleMessages(address, msgs));
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            super.channelInactive(ctx);
            ServerCoreRoot.this.connections.remove(ctx.channel().remoteAddress(), ctx.channel());
        }
    }
}

