/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.hub.net;

import java.util.List;
import java.util.Objects;
import org.praxislive.core.ControlAddress;
import org.praxislive.core.Value;
import org.praxislive.core.types.PMap;

sealed interface Message {
    public int matchID();

    public PMap data();

    public record System(int matchID, String type, PMap data) implements Message
    {
        static final String HELLO = "HELLO";
        static final String HELLO_OK = "HELLO-OK";
        static final String HELLO_ERROR = "HELLO-ERROR";
        static final String GOODBYE = "GOODBYE";

        public System {
            Objects.requireNonNull(type);
            Objects.requireNonNull(data);
        }
    }

    public record Error(int matchID, List<Value> args, PMap data) implements Message
    {
        public Error {
            args = List.copyOf(args);
            Objects.requireNonNull(data);
        }

        public Error(int matchID, List<Value> args) {
            this(matchID, args, PMap.EMPTY);
        }
    }

    public record Reply(int matchID, List<Value> args, PMap data) implements Message
    {
        public Reply {
            args = List.copyOf(args);
            Objects.requireNonNull(data);
        }

        public Reply(int matchID, List<Value> args) {
            this(matchID, args, PMap.EMPTY);
        }
    }

    public record Service(int matchID, String service, String control, ControlAddress from, List<Value> args, PMap data) implements Message
    {
        public Service {
            Objects.requireNonNull(service);
            Objects.requireNonNull(control);
            Objects.requireNonNull(from);
            args = List.copyOf(args);
            Objects.requireNonNull(data);
        }

        public Service(int matchID, String service, String control, ControlAddress from, List<Value> args) {
            this(matchID, service, control, from, args, PMap.EMPTY);
        }
    }

    public record Send(int matchID, ControlAddress to, ControlAddress from, List<Value> args, PMap data) implements Message
    {
        public Send {
            Objects.requireNonNull(to);
            Objects.requireNonNull(from);
            args = List.copyOf(args);
            Objects.requireNonNull(data);
        }

        public Send(int matchID, ControlAddress to, ControlAddress from, List<Value> args) {
            this(matchID, to, from, args, PMap.EMPTY);
        }
    }
}

