/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.hub.net.internal;

import java.util.List;
import java.util.Map;
import org.praxislive.core.Call;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.ControlAddress;
import org.praxislive.core.Value;
import org.praxislive.core.services.ServiceUnavailableException;
import org.praxislive.core.services.Services;
import org.praxislive.hub.net.internal.HubConfigurationService;
import org.praxislive.script.Command;
import org.praxislive.script.CommandInstaller;
import org.praxislive.script.Env;
import org.praxislive.script.ExecutionException;
import org.praxislive.script.Namespace;
import org.praxislive.script.StackFrame;
import org.praxislive.script.impl.AbstractSingleCallFrame;

public class HubNetCommands
implements CommandInstaller {
    private static final ConfigurationCommand HUB_CONFIGURE = new ConfigurationCommand();

    public void install(Map<String, Command> commands) {
        commands.put("hub", HUB_CONFIGURE);
        commands.put("hub-configure", HUB_CONFIGURE);
    }

    private static final class ConfigurationCommand
    implements Command {
        private ConfigurationCommand() {
        }

        public StackFrame createStackFrame(Namespace namespace, List<Value> args) throws ExecutionException {
            return new AbstractSingleCallFrame(namespace, args){

                protected Call createCall(Env env, List<Value> args) throws Exception {
                    ComponentAddress service = (ComponentAddress)env.getLookup().find(Services.class).flatMap(sm -> sm.locate(HubConfigurationService.class)).orElseThrow(ServiceUnavailableException::new);
                    ControlAddress to = ControlAddress.of((ComponentAddress)service, (String)"hub-configure");
                    return Call.create((ControlAddress)to, (ControlAddress)env.getAddress(), (long)env.getTime(), args);
                }
            };
        }
    }
}

