/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.hub.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.praxislive.core.Call;
import org.praxislive.core.Clock;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.ControlAddress;
import org.praxislive.core.ExecutionContext;
import org.praxislive.core.Packet;
import org.praxislive.core.PacketRouter;
import org.praxislive.core.Root;
import org.praxislive.core.services.LogService;
import org.praxislive.core.services.Service;
import org.praxislive.core.types.PMap;
import org.praxislive.core.types.PResource;
import org.praxislive.hub.Hub;
import org.praxislive.hub.net.CIDRUtils;
import org.praxislive.hub.net.ChildLauncher;
import org.praxislive.hub.net.HubConfiguration;
import org.praxislive.hub.net.NetworkCoreFactory;
import org.praxislive.hub.net.NetworkCoreRoot;
import org.praxislive.hub.net.OSCDispatcher;
import org.praxislive.hub.net.PraxisPacketCodec;
import org.praxislive.hub.net.Utils;
import org.praxislive.internal.osc.OSCListener;
import org.praxislive.internal.osc.OSCMessage;
import org.praxislive.internal.osc.OSCPacket;
import org.praxislive.internal.osc.OSCPacketCodec;
import org.praxislive.internal.osc.OSCServer;

class ServerCoreRoot
extends NetworkCoreRoot {
    private static final Logger LOG = Logger.getLogger(ServerCoreRoot.class.getName());
    private final String SERVER_SYS_PREFIX = "/_remote";
    private final InetSocketAddress address;
    private final CIDRUtils clientValidator;
    private final PraxisPacketCodec codec;
    private final Dispatcher dispatcher;
    private final ResourceResolver resourceResolver;
    private OSCServer server;
    private SocketAddress master;
    private long lastPurgeTime;
    private URI remoteUserDir;
    private URI remoteFileServer;
    private CompletableFuture<NetworkCoreFactory.Info> futureInfo;

    ServerCoreRoot(Hub.Accessor hubAccess, List<Root> exts, List<Class<? extends Service>> services, ChildLauncher childLauncher, HubConfiguration configuration, InetSocketAddress address, CIDRUtils clientValidator, CompletableFuture<NetworkCoreFactory.Info> futureInfo) {
        super(hubAccess, exts, services, childLauncher, configuration);
        this.address = address;
        this.clientValidator = clientValidator;
        this.codec = new PraxisPacketCodec();
        this.dispatcher = new Dispatcher(this.codec);
        this.resourceResolver = new ResourceResolver();
        this.futureInfo = futureInfo;
    }

    @Override
    protected void starting() {
        try {
            this.server = OSCServer.newUsing((OSCPacketCodec)this.codec, (String)"tcp", (InetSocketAddress)this.address);
            this.server.setBufferSize(65536);
            this.server.addOSCListener(new OSCListener(){

                public void messageReceived(final OSCMessage msg, final SocketAddress sender, final long time) {
                    ServerCoreRoot.this.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ServerCoreRoot.this.messageReceived(msg, sender, time);
                        }
                    });
                }
            });
            this.server.start();
            if (this.futureInfo != null) {
                this.futureInfo.complete(new NetworkCoreFactory.Info(this.server.getLocalAddress()));
                this.futureInfo = null;
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ServerCoreRoot.class.getName()).log(Level.SEVERE, null, ex);
            if (this.futureInfo != null) {
                this.futureInfo.completeExceptionally(ex);
                this.futureInfo = null;
            }
            this.forceTermination();
            throw new RuntimeException(ex);
        }
        ((ExecutionContext)this.getLookup().find(ExecutionContext.class).orElseThrow(IllegalStateException::new)).addClockListener(new ExecutionContext.ClockListener(){

            public void tick(ExecutionContext source) {
                ServerCoreRoot.this.tick(source);
            }
        });
        super.starting();
    }

    @Override
    protected void terminating() {
        super.terminating();
        try {
            if (this.server != null) {
                this.server.stop();
                this.server.dispose();
            }
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, "", ex);
        }
        finally {
            this.server = null;
        }
    }

    protected void processCall(Call call, PacketRouter router) {
        if (call.to().component().equals((Object)this.getAddress())) {
            super.processCall(call, router);
        } else {
            this.dispatcher.handleCall(call);
        }
    }

    PResource.Resolver getResourceResolver() {
        return this.resourceResolver;
    }

    private void tick(ExecutionContext source) {
        if (source.getTime() - this.lastPurgeTime > TimeUnit.SECONDS.toNanos(1L)) {
            this.dispatcher.purge(10L, TimeUnit.SECONDS);
            this.lastPurgeTime = source.getTime();
        }
    }

    private void messageReceived(OSCMessage msg, SocketAddress sender, long time) {
        if (!(this.master != null && this.master.equals(sender) || "/HLO".equals(msg.getName()))) {
            LOG.log(Level.WARNING, "Received unexpected message from {0}", sender);
            return;
        }
        switch (msg.getName()) {
            case "/HLO": {
                this.handleHLO(sender, msg);
                break;
            }
            case "/BYE": {
                this.master = null;
                this.forceTermination();
                break;
            }
            default: {
                this.dispatcher.handleMessage(msg, time);
            }
        }
    }

    private void handleHLO(SocketAddress sender, OSCMessage msg) {
        if (this.validate(sender) && this.handleHLOParams((InetSocketAddress)sender, msg)) {
            this.master = sender;
            try {
                this.server.send((OSCPacket)new OSCMessage("/HLO", new Object[]{"OK"}), sender);
            }
            catch (IOException ex) {
                Logger.getLogger(ServerCoreRoot.class.getName()).log(Level.SEVERE, null, ex);
                this.master = null;
            }
        }
    }

    private boolean validate(SocketAddress sender) {
        if (this.clientValidator == null) {
            return true;
        }
        if (sender instanceof InetSocketAddress) {
            InetSocketAddress inet = (InetSocketAddress)sender;
            try {
                return this.clientValidator.isInRange(inet.getHostString());
            }
            catch (UnknownHostException ex) {
                Logger.getLogger(ServerCoreRoot.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return false;
    }

    private boolean handleHLOParams(InetSocketAddress sender, OSCMessage msg) {
        if (msg.getArgCount() < 1) {
            return true;
        }
        try {
            int fileServerPort;
            PMap services;
            PMap params = PMap.parse((String)msg.getArg(0).toString());
            String masterUserDir = params.getString("master-user-directory", null);
            if (masterUserDir != null) {
                this.remoteUserDir = URI.create(masterUserDir);
            }
            if (!(services = PMap.parse((String)params.getString("remote-services", ""))).isEmpty()) {
                for (String serviceName : services.keys()) {
                    Class service = "org.praxislive.logging.LogService".equals(serviceName) ? LogService.class : Class.forName(serviceName, true, Thread.currentThread().getContextClassLoader());
                    ComponentAddress serviceAddress = ComponentAddress.of((String)("/_remote" + services.getString(serviceName, null)));
                    this.getHubAccessor().registerService(service, serviceAddress);
                }
            }
            if ((fileServerPort = params.getInt("file-server-port", 0)) > 0) {
                this.remoteFileServer = URI.create("http://" + sender.getAddress().getHostAddress() + ":" + fileServerPort);
            }
            return true;
        }
        catch (Exception ex) {
            Logger.getLogger(ServerCoreRoot.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    private class ResourceResolver
    implements PResource.Resolver {
        private ResourceResolver() {
        }

        public List<URI> resolve(PResource resource) {
            URI dir = ServerCoreRoot.this.remoteUserDir;
            URI srv = ServerCoreRoot.this.remoteFileServer;
            URI res = resource.value();
            if (dir == null && srv == null) {
                return Collections.singletonList(res);
            }
            if (!"file".equals(res.getScheme())) {
                return Collections.singletonList(res);
            }
            ArrayList<URI> uris = new ArrayList<URI>(2);
            if (dir != null) {
                uris.add(Utils.getUserDirectory().toURI().resolve(dir.relativize(res)));
            }
            if (srv != null) {
                uris.add(srv.resolve(res.getRawPath()));
            }
            return uris;
        }
    }

    private class Dispatcher
    extends OSCDispatcher {
        private Dispatcher(PraxisPacketCodec codec) {
            super(codec, new Clock(){

                public long getTime() {
                    return ServerCoreRoot.this.getExecutionContext().getTime();
                }
            });
        }

        @Override
        void send(OSCPacket packet) {
            try {
                ServerCoreRoot.this.server.send(packet, ServerCoreRoot.this.master);
            }
            catch (IOException ex) {
                Logger.getLogger(ServerCoreRoot.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        @Override
        void send(Call call) {
            ServerCoreRoot.this.getRouter().route((Packet)call);
        }

        @Override
        String getRemoteSysPrefix() {
            return "/_remote";
        }

        @Override
        ControlAddress getAddRootAddress() {
            return ControlAddress.of((ComponentAddress)ServerCoreRoot.this.getAddress(), (String)"add-root");
        }

        @Override
        ControlAddress getRemoveRootAddress() {
            return ControlAddress.of((ComponentAddress)ServerCoreRoot.this.getAddress(), (String)"remove-root");
        }
    }
}

