/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.hub.net;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.praxislive.base.AbstractRoot;
import org.praxislive.core.Call;
import org.praxislive.core.Clock;
import org.praxislive.core.Control;
import org.praxislive.core.ExecutionContext;
import org.praxislive.core.Packet;
import org.praxislive.core.PacketRouter;
import org.praxislive.core.Value;
import org.praxislive.core.services.Service;
import org.praxislive.core.services.ServiceUnavailableException;
import org.praxislive.core.types.PError;
import org.praxislive.core.types.PMap;
import org.praxislive.hub.net.ChildLauncher;
import org.praxislive.hub.net.ChildRegistry;
import org.praxislive.hub.net.FileServer;
import org.praxislive.hub.net.OSCDispatcher;
import org.praxislive.hub.net.PraxisPacketCodec;
import org.praxislive.hub.net.ProxyInfo;
import org.praxislive.hub.net.Utils;
import org.praxislive.internal.osc.OSCClient;
import org.praxislive.internal.osc.OSCListener;
import org.praxislive.internal.osc.OSCMessage;
import org.praxislive.internal.osc.OSCPacket;
import org.praxislive.internal.osc.OSCPacketCodec;

class ProxyClientRoot
extends AbstractRoot {
    private static final Logger LOG = Logger.getLogger(ProxyClientRoot.class.getName());
    private static final String HLO = "/HLO";
    private static final String BYE = "/BYE";
    private final ProxyInfo proxyInfo;
    private final List<Class<? extends Service>> services;
    private final ChildLauncher childLauncher;
    private final FileServer.Info fileServerInfo;
    private final PraxisPacketCodec codec;
    private final Dispatcher dispatcher;
    private final Control addRootControl;
    private final Control removeRootControl;
    private OSCClient client;
    private long lastPurgeTime;
    private Watchdog watchdog;
    private Process execProcess;
    private SocketAddress socketAddress;

    ProxyClientRoot(ProxyInfo proxyInfo, List<Class<? extends Service>> services, ChildLauncher childLauncher, FileServer.Info fileServerInfo) {
        this.proxyInfo = proxyInfo;
        this.services = services;
        this.childLauncher = childLauncher;
        this.fileServerInfo = fileServerInfo;
        this.codec = new PraxisPacketCodec();
        this.dispatcher = new Dispatcher(this.codec);
        this.addRootControl = new RootControl(true);
        this.removeRootControl = new RootControl(false);
    }

    protected void activating() {
        this.lastPurgeTime = this.getExecutionContext().getTime();
        this.dispatcher.remoteSysPrefix = this.getAddress().toString() + "/_remote";
        this.setRunning();
    }

    protected void terminating() {
        super.terminating();
        if (this.client != null) {
            LOG.fine("Terminating - sending /BYE");
            try {
                this.client.send((OSCPacket)new OSCMessage(BYE));
            }
            catch (IOException ex) {
                LOG.log(Level.FINE, null, ex);
            }
        }
        this.dispose();
        this.destroyChild();
    }

    protected void processCall(Call call, PacketRouter router) {
        if (this.getState() != AbstractRoot.State.ACTIVE_RUNNING) {
            if (call.isReplyRequired()) {
                router.route((Packet)call.error(PError.of((String)"Terminated")));
            }
            return;
        }
        if (call.to().component().equals((Object)this.getAddress())) {
            try {
                switch (call.to().controlID()) {
                    case "add-root": {
                        this.addRootControl.call(call, router);
                        break;
                    }
                    case "remove-root": {
                        this.removeRootControl.call(call, router);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
            catch (Exception ex) {
                router.route((Packet)call.error(PError.of((Exception)ex)));
            }
        } else if (this.client != null) {
            this.dispatcher.handleCall(call);
        } else {
            this.connect();
            if (this.client != null) {
                this.dispatcher.handleCall(call);
            } else {
                this.getRouter().route((Packet)call.error(PError.of((String)"")));
            }
        }
    }

    protected void update() {
        ExecutionContext source = this.getExecutionContext();
        if (source.getTime() - this.lastPurgeTime > TimeUnit.SECONDS.toNanos(1L)) {
            this.dispatcher.purge(10L, TimeUnit.SECONDS);
            this.lastPurgeTime = source.getTime();
        }
        if (this.watchdog != null) {
            this.watchdog.tick();
        }
    }

    private void messageReceived(OSCMessage msg, SocketAddress sender, long timeTag) {
        this.dispatcher.handleMessage(msg, timeTag);
    }

    private void send(OSCPacket packet) {
        if (this.client != null) {
            try {
                this.client.send(packet);
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, "", ex);
                this.dispose();
            }
        }
    }

    private void connect() {
        try {
            this.checkAndExecChild();
            this.client = OSCClient.newUsing((OSCPacketCodec)this.codec, (String)"tcp");
            this.client.setBufferSize(65536);
            this.client.setTarget(this.socketAddress);
            this.watchdog = new Watchdog(this.getRootHub().getClock(), this.client);
            this.watchdog.start();
            CountDownLatch hloLatch = new CountDownLatch(1);
            this.client.addOSCListener((OSCListener)new Receiver(hloLatch));
            this.client.start();
            this.client.send((OSCPacket)new OSCMessage(HLO, new Object[]{this.buildHLOParams().toString()}));
            if (hloLatch.await(10L, TimeUnit.SECONDS)) {
                LOG.fine("/HLO received OK");
            } else {
                LOG.severe("Unable to connect");
                this.dispose();
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Unable to connect", ex);
            this.dispose();
        }
    }

    private void checkAndExecChild() throws Exception {
        if (this.execProcess != null) {
            if (this.execProcess.isAlive()) {
                LOG.log(Level.INFO, "Child process already running");
                return;
            }
            throw new IllegalStateException("Child process terminated");
        }
        ProxyInfo.Exec exec = this.proxyInfo.exec().orElse(null);
        if (exec == null) {
            this.socketAddress = this.proxyInfo.socketAddress();
            return;
        }
        String cmd = exec.command().orElse(null);
        if (cmd == null) {
            if (this.childLauncher == null) {
                throw new IllegalStateException("No child launcher for exec");
            }
        } else {
            throw new UnsupportedOperationException("Only default command supported at present");
        }
        ChildLauncher.Info childInfo = this.childLauncher.launch(exec.javaOptions(), exec.arguments());
        this.execProcess = childInfo.handle();
        this.socketAddress = childInfo.address();
        ChildRegistry.INSTANCE.add(this.execProcess);
    }

    private PMap buildHLOParams() {
        PMap.Builder params = PMap.builder();
        params.put("remote-services", (Value)this.buildServiceMap());
        if (!this.proxyInfo.isLocal()) {
            params.put("master-user-directory", Utils.getUserDirectory().toURI().toString());
            if (this.fileServerInfo != null) {
                params.put("file-server-port", this.fileServerInfo.getPort());
            }
        }
        return params.build();
    }

    private PMap buildServiceMap() {
        PMap.Builder srvs = PMap.builder((int)this.services.size());
        this.services.forEach(service -> {
            try {
                srvs.put(service.getName(), (Value)this.findService((Class)service));
            }
            catch (ServiceUnavailableException ex) {
                Logger.getLogger(ProxyClientRoot.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        return srvs.build();
    }

    private void dispose() {
        if (this.client != null) {
            this.client.dispose();
            this.client = null;
        }
        if (this.watchdog != null) {
            this.watchdog.shutdown();
            this.watchdog = null;
        }
        this.dispatcher.purge(0L, TimeUnit.NANOSECONDS);
    }

    private void destroyChild() {
        if (this.execProcess != null) {
            boolean exited = false;
            try {
                this.execProcess.destroy();
                exited = this.execProcess.waitFor(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!exited) {
                this.execProcess.destroyForcibly();
                try {
                    this.execProcess.waitFor(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException ex) {
                    LOG.log(Level.SEVERE, "Child process won't quit", ex);
                }
            }
            ChildRegistry.INSTANCE.remove(this.execProcess);
            this.execProcess = null;
        }
    }

    private class RootControl
    implements Control {
        private final boolean add;

        private RootControl(boolean add) {
            this.add = add;
        }

        public void call(Call call, PacketRouter router) throws Exception {
            if (call.isRequest()) {
                if (ProxyClientRoot.this.client != null) {
                    this.dispatch(call);
                } else {
                    ProxyClientRoot.this.connect();
                    if (ProxyClientRoot.this.client != null) {
                        this.dispatch(call);
                    } else {
                        router.route((Packet)call.error(PError.of((String)"Couldn't connect to client")));
                    }
                }
            }
        }

        private void dispatch(Call call) {
            if (this.add) {
                ProxyClientRoot.this.dispatcher.handleAddRoot(call);
            } else {
                ProxyClientRoot.this.dispatcher.handleRemoveRoot(call);
            }
        }
    }

    private class Receiver
    implements OSCListener {
        private CountDownLatch hloLatch;

        private Receiver(CountDownLatch hloLatch) {
            this.hloLatch = hloLatch;
        }

        public void messageReceived(final OSCMessage msg, final SocketAddress sender, final long timeTag) {
            if (this.hloLatch != null && ProxyClientRoot.HLO.equals(msg.getName())) {
                this.hloLatch.countDown();
                this.hloLatch = null;
            }
            ProxyClientRoot.this.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProxyClientRoot.this.messageReceived(msg, sender, timeTag);
                }
            });
        }
    }

    private class Watchdog
    extends Thread {
        private final Clock clock;
        private final OSCClient client;
        private volatile long lastTickTime;
        private volatile boolean active;

        private Watchdog(Clock clock, OSCClient client) {
            this.clock = clock;
            this.client = client;
            this.lastTickTime = clock.getTime();
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (this.active) {
                if (this.clock.getTime() - this.lastTickTime > TimeUnit.SECONDS.toNanos(10L)) {
                    this.client.dispose();
                    this.active = false;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        private void tick() {
            this.lastTickTime = this.clock.getTime();
        }

        private void shutdown() {
            this.active = false;
            this.interrupt();
        }
    }

    private class Dispatcher
    extends OSCDispatcher {
        private String remoteSysPrefix;

        private Dispatcher(PraxisPacketCodec codec) {
            super(codec, new Clock(){

                public long getTime() {
                    return ProxyClientRoot.this.getExecutionContext().getTime();
                }
            });
        }

        @Override
        void send(OSCPacket packet) {
            ProxyClientRoot.this.send(packet);
        }

        @Override
        void send(Call call) {
            ProxyClientRoot.this.getRouter().route((Packet)call);
        }

        @Override
        String getRemoteSysPrefix() {
            assert (this.remoteSysPrefix != null);
            return this.remoteSysPrefix;
        }
    }
}

