/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.hub.net;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.praxislive.core.Call;
import org.praxislive.core.Clock;
import org.praxislive.core.ComponentType;
import org.praxislive.core.ControlAddress;
import org.praxislive.core.Value;
import org.praxislive.core.types.PError;
import org.praxislive.core.types.PString;
import org.praxislive.hub.net.PraxisPacketCodec;
import org.praxislive.internal.osc.OSCBundle;
import org.praxislive.internal.osc.OSCMessage;
import org.praxislive.internal.osc.OSCPacket;

abstract class OSCDispatcher {
    private static final Logger LOG = Logger.getLogger(OSCDispatcher.class.getName());
    static final String SND = "/SND";
    static final String RES = "/RES";
    static final String ERR = "/ERR";
    static final String ADD = "/ADD";
    static final String DEL = "/DEL";
    static final String SYS_PREFIX = "/_sys";
    private final PraxisPacketCodec codec;
    private final Clock clock;
    private final Map<Integer, SentCallInfo> sentCalls;
    private final Map<Integer, Integer> localToRemoteID;

    OSCDispatcher(PraxisPacketCodec codec, Clock clock) {
        this.codec = codec;
        this.clock = clock;
        this.sentCalls = new LinkedHashMap<Integer, SentCallInfo>();
        this.localToRemoteID = new HashMap<Integer, Integer>();
    }

    void handleMessage(OSCMessage msg, long timeTag) {
        block18: {
            String address = msg.getName();
            try {
                switch (address) {
                    case "/SND": {
                        this.handleSND(msg, this.timeTagToNanos(timeTag));
                        break;
                    }
                    case "/RES": {
                        this.handleRES(msg);
                        break;
                    }
                    case "/ERR": {
                        this.handleERR(msg);
                        break;
                    }
                    case "/ADD": {
                        this.handleADD(msg, this.timeTagToNanos(timeTag));
                        break;
                    }
                    case "/DEL": {
                        this.handleDEL(msg, this.timeTagToNanos(timeTag));
                    }
                }
            }
            catch (Exception e) {
                if (RES.equals(address) || ERR.equals(address)) break block18;
                try {
                    this.send((OSCPacket)new OSCMessage(ERR, new Object[]{this.extractID(msg), e.getClass().getSimpleName()}));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    void handleSND(OSCMessage msg, long time) throws Exception {
        int id = this.extractID(msg);
        ControlAddress to = ControlAddress.parse((String)msg.getArg(1).toString());
        Object fromString = msg.getArg(2).toString();
        if (((String)fromString).startsWith(SYS_PREFIX)) {
            fromString = this.getRemoteSysPrefix() + (String)fromString;
        }
        ControlAddress from = ControlAddress.parse((String)fromString);
        Call call = Call.create((ControlAddress)to, (ControlAddress)from, (long)time, this.extractCallArguments(msg, 3));
        this.send(call);
        this.localToRemoteID.put(call.matchID(), id);
    }

    void handleRES(OSCMessage msg) throws Exception {
        int id = this.extractID(msg);
        SentCallInfo info = this.sentCalls.remove(id);
        if (info == null) {
            throw new IllegalArgumentException("Unexpected response");
        }
        Call call = info.localCall.reply(this.extractCallArguments(msg, 1));
        this.send(call);
    }

    void handleERR(OSCMessage msg) throws Exception {
        int id = this.extractID(msg);
        SentCallInfo info = this.sentCalls.remove(id);
        if (info == null) {
            throw new IllegalArgumentException("Unexpected response");
        }
        Call call = info.localCall.error(this.extractCallArguments(msg, 1));
        this.send(call);
    }

    void handleADD(OSCMessage msg, long time) throws Exception {
        int id = this.extractID(msg);
        ControlAddress to = this.getAddRootAddress();
        Object fromString = msg.getArg(1).toString();
        if (((String)fromString).startsWith(SYS_PREFIX)) {
            fromString = this.getRemoteSysPrefix() + (String)fromString;
        }
        ControlAddress from = ControlAddress.parse((String)fromString);
        PString rootID = PString.of((Object)msg.getArg(2));
        ComponentType rootType = ComponentType.parse((String)msg.getArg(3).toString());
        Call call = Call.create((ControlAddress)to, (ControlAddress)from, (long)time, Arrays.asList(rootID, rootType));
        this.send(call);
        this.localToRemoteID.put(call.matchID(), id);
    }

    void handleDEL(OSCMessage msg, long time) throws Exception {
        int id = this.extractID(msg);
        ControlAddress to = this.getRemoveRootAddress();
        Object fromString = msg.getArg(1).toString();
        if (((String)fromString).startsWith(SYS_PREFIX)) {
            fromString = this.getRemoteSysPrefix() + (String)fromString;
        }
        ControlAddress from = ControlAddress.parse((String)fromString);
        PString rootID = PString.of((Object)msg.getArg(2));
        Call call = Call.create((ControlAddress)to, (ControlAddress)from, (long)time, (Value)rootID);
        this.send(call);
        this.localToRemoteID.put(call.matchID(), id);
    }

    void handleCall(Call call) {
        if (call.isRequest()) {
            this.handleInvoke(SND, call);
        } else if (call.isReply()) {
            this.handleResponse(RES, call);
        } else {
            this.handleResponse(ERR, call);
        }
    }

    void handleAddRoot(Call call) {
        Object[] oscArgs = new Object[]{call.matchID(), call.from().toString(), this.codec.toOSCObject((Value)call.args().get(0)), this.codec.toOSCObject((Value)call.args().get(1))};
        this.send(ADD, call.time(), oscArgs);
        this.sentCalls.put(call.matchID(), new SentCallInfo(this.clock.getTime(), call));
    }

    void handleRemoveRoot(Call call) {
        Object[] oscArgs = new Object[]{call.matchID(), call.from().toString(), this.codec.toOSCObject((Value)call.args().get(0))};
        this.send(DEL, call.time(), oscArgs);
        this.sentCalls.put(call.matchID(), new SentCallInfo(this.clock.getTime(), call));
    }

    void handleInvoke(String target, Call call) {
        List callArgs = call.args();
        Object[] oscArgs = new Object[callArgs.size() + 3];
        oscArgs[0] = call.matchID();
        String to = call.to().toString();
        if (to.startsWith(this.getRemoteSysPrefix())) {
            to = to.substring(this.getRemoteSysPrefix().length());
        }
        oscArgs[1] = to;
        oscArgs[2] = call.from().toString();
        int i = 3;
        int k = 0;
        while (i < oscArgs.length) {
            oscArgs[i] = this.codec.toOSCObject((Value)callArgs.get(k));
            ++i;
            ++k;
        }
        this.send(target, call.time(), oscArgs);
        this.sentCalls.put(call.matchID(), new SentCallInfo(this.clock.getTime(), call));
    }

    void handleResponse(String target, Call call) {
        Integer remoteID = this.localToRemoteID.remove(call.matchID());
        if (remoteID == null) {
            LOG.log(Level.FINE, "Unexpected call response\n{0}", call);
            return;
        }
        List callArgs = call.args();
        Object[] oscArgs = new Object[callArgs.size() + 1];
        oscArgs[0] = remoteID;
        int i = 1;
        int k = 0;
        while (i < oscArgs.length) {
            oscArgs[i] = this.codec.toOSCObject((Value)callArgs.get(k));
            ++i;
            ++k;
        }
        this.send(target, call.time(), oscArgs);
    }

    void send(String target, long nanos, Object[] args) {
        OSCBundle b = new OSCBundle();
        b.setTimeTagRaw(this.nanosToTimeTag(nanos));
        b.addPacket((OSCPacket)new OSCMessage(target, args));
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "{0} : {1}", new Object[]{target, Arrays.toString(args)});
        }
        this.send((OSCPacket)b);
    }

    void purge(long time, TimeUnit unit) {
        long ago = unit.toNanos(time);
        long now = this.clock.getTime();
        Iterator<SentCallInfo> itr = this.sentCalls.values().iterator();
        while (itr.hasNext()) {
            SentCallInfo info = itr.next();
            if (now - info.sentTime < ago) {
                LOG.fine("No calls to purge");
                break;
            }
            itr.remove();
            LOG.log(Level.FINE, "Purging call\n{0}", info.localCall);
            Call err = info.localCall.error(PError.of((String)"Timeout"));
            this.send(err);
        }
    }

    ControlAddress getAddRootAddress() {
        throw new UnsupportedOperationException();
    }

    ControlAddress getRemoveRootAddress() {
        throw new UnsupportedOperationException();
    }

    long timeTagToNanos(long timeTag) {
        return this.clock.getTime();
    }

    long nanosToTimeTag(long nanos) {
        return 1L;
    }

    abstract void send(OSCPacket var1);

    abstract void send(Call var1);

    abstract String getRemoteSysPrefix();

    int extractID(OSCMessage msg) throws Exception {
        Object o = msg.getArg(0);
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        return Integer.valueOf(o.toString());
    }

    List<Value> extractCallArguments(OSCMessage msg, int fromIndex) {
        int argCount = msg.getArgCount() - fromIndex;
        if (argCount == 0) {
            return Collections.emptyList();
        }
        if (argCount == 1) {
            return Collections.singletonList(this.codec.toArgument(msg.getArg(fromIndex)));
        }
        Value[] args = new Value[argCount];
        for (int i = 0; i < argCount; ++i) {
            args[i] = this.codec.toArgument(msg.getArg(i + fromIndex));
        }
        return Arrays.asList(args);
    }

    private static class SentCallInfo {
        final long sentTime;
        final Call localCall;

        SentCallInfo(long sentTime, Call localCall) {
            this.sentTime = sentTime;
            this.localCall = localCall;
        }
    }
}

