/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.hub.net;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.praxislive.core.Lookup;
import org.praxislive.core.Root;
import org.praxislive.core.services.Service;
import org.praxislive.hub.Hub;
import org.praxislive.hub.net.CIDRUtils;
import org.praxislive.hub.net.ChildLauncher;
import org.praxislive.hub.net.HubConfiguration;
import org.praxislive.hub.net.NetworkCoreRoot;
import org.praxislive.hub.net.ServerCoreRoot;

public final class NetworkCoreFactory
extends Hub.CoreRootFactory {
    private final boolean enableServer;
    private final InetSocketAddress serverAddress;
    private final CIDRUtils cidr;
    private final List<Class<? extends Service>> services;
    private final ChildLauncher childLauncher;
    private final HubConfiguration hubConfiguration;
    private final CompletableFuture<Info> futureInfo;
    private Root root;

    private NetworkCoreFactory(Builder builder) {
        this.enableServer = builder.enableServer;
        if (this.enableServer) {
            this.serverAddress = builder.allowRemote ? new InetSocketAddress(builder.serverPort) : new InetSocketAddress(InetAddress.getLoopbackAddress(), builder.serverPort);
            this.cidr = builder.cidr;
        } else {
            this.serverAddress = null;
            this.cidr = null;
        }
        this.services = builder.services;
        this.hubConfiguration = builder.hubConfiguration;
        this.childLauncher = builder.childLauncher;
        this.futureInfo = new CompletableFuture();
    }

    public synchronized Root createCoreRoot(Hub.Accessor accessor, List<Root> extensions) {
        if (this.root != null) {
            throw new IllegalStateException("NetworkCoreFactory cannot be reused");
        }
        this.root = this.enableServer ? new ServerCoreRoot(accessor, extensions, this.services, this.childLauncher, this.hubConfiguration, this.serverAddress, this.cidr, this.futureInfo) : new NetworkCoreRoot(accessor, extensions, this.services, this.childLauncher, this.hubConfiguration);
        return this.root;
    }

    public synchronized Lookup extendLookup(Lookup lookup) {
        if (this.root instanceof ServerCoreRoot) {
            return Lookup.of((Lookup)lookup, (Object[])new Object[]{((ServerCoreRoot)this.root).getResourceResolver()});
        }
        return lookup;
    }

    public Info awaitInfo(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.futureInfo.get(timeout, unit);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Info {
        private final InetSocketAddress localAddress;

        Info() {
            this(null);
        }

        Info(InetSocketAddress localAddress) {
            this.localAddress = localAddress;
        }

        public Optional<SocketAddress> serverAddress() {
            return Optional.ofNullable(this.localAddress);
        }
    }

    public static final class Builder {
        private boolean enableServer;
        private int serverPort;
        private boolean allowRemote;
        private CIDRUtils cidr;
        private List<Class<? extends Service>> services = List.of();
        private ChildLauncher childLauncher;
        private HubConfiguration hubConfiguration;

        private Builder() {
        }

        public Builder enableServer() {
            this.enableServer = true;
            return this;
        }

        public Builder serverPort(int port) {
            if (port < 0 || port > 65535) {
                throw new IllegalArgumentException("Out of range");
            }
            this.serverPort = port;
            return this;
        }

        public Builder allowRemoteServerConnection() {
            return this.allowRemoteServerConnection(null);
        }

        public Builder allowRemoteServerConnection(String cidr) {
            this.allowRemote = true;
            if (cidr == null) {
                this.cidr = null;
            } else {
                try {
                    this.cidr = new CIDRUtils(cidr);
                }
                catch (UnknownHostException ex) {
                    throw new IllegalArgumentException("Invalid net mask", ex);
                }
            }
            return this;
        }

        public Builder exposeServices(List<Class<? extends Service>> services) {
            this.services = List.copyOf(services);
            return this;
        }

        public Builder childLauncher(ChildLauncher launcher) {
            this.childLauncher = launcher;
            return this;
        }

        public Builder hubConfiguration(HubConfiguration configuration) {
            this.hubConfiguration = configuration;
            return this;
        }

        public NetworkCoreFactory build() {
            return new NetworkCoreFactory(this);
        }
    }
}

