/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.hub.net;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.praxislive.internal.httpd.NanoHTTPD;

class FileServer
extends NanoHTTPD {
    public static final List<String> INDEX_FILE_NAMES = new ArrayList<String>(){
        {
            this.add("index.html");
            this.add("index.htm");
        }
    };
    private final boolean quiet = true;
    private final File homeDir;

    FileServer(int port, File homeDir) {
        super(null, port);
        if (!homeDir.isAbsolute() && !homeDir.isDirectory()) {
            throw new IllegalArgumentException();
        }
        this.homeDir = homeDir;
    }

    Info getInfo() {
        return new Info(this.getListeningPort());
    }

    private boolean canServeUri(String uri) {
        try {
            for (File f = new File(uri).getCanonicalFile(); f != null; f = f.getParentFile()) {
                if (!f.equals(this.homeDir)) continue;
                return true;
            }
        }
        catch (IOException ex) {
            Logger.getLogger(FileServer.class.getName()).log(Level.SEVERE, null, ex);
        }
        return false;
    }

    private String encodeUri(String uri) {
        Object newUri = "";
        StringTokenizer st = new StringTokenizer(uri, "/ ", true);
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if ("/".equals(tok)) {
                newUri = (String)newUri + "/";
                continue;
            }
            if (" ".equals(tok)) {
                newUri = (String)newUri + "%20";
                continue;
            }
            try {
                newUri = (String)newUri + URLEncoder.encode(tok, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        return newUri;
    }

    private String findIndexFileInDirectory(File directory) {
        for (String fileName : INDEX_FILE_NAMES) {
            File indexFile = new File(directory, fileName);
            if (!indexFile.isFile()) continue;
            return fileName;
        }
        return null;
    }

    protected NanoHTTPD.Response getForbiddenResponse(String s) {
        return FileServer.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.FORBIDDEN, "text/plain", "FORBIDDEN: " + s);
    }

    protected NanoHTTPD.Response getInternalErrorResponse(String s) {
        return FileServer.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.INTERNAL_ERROR, "text/plain", "INTERNAL ERROR: " + s);
    }

    protected NanoHTTPD.Response getNotFoundResponse() {
        return FileServer.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NOT_FOUND, "text/plain", "Error 404, file not found.");
    }

    protected String listDirectory(String uri, File f) {
        String u;
        int slash;
        String heading = "Directory " + uri;
        StringBuilder msg = new StringBuilder("<html><head><title>" + heading + "</title><style><!--\nspan.dirname { font-weight: bold; }\nspan.filesize { font-size: 75%; }\n// -->\n</style></head><body><h1>" + heading + "</h1>");
        String up = null;
        if (uri.length() > 1 && (slash = (u = uri.substring(0, uri.length() - 1)).lastIndexOf(47)) >= 0 && slash < u.length()) {
            up = uri.substring(0, slash + 1);
        }
        List<String> files = Arrays.asList(f.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return new File(dir, name).isFile();
            }
        }));
        Collections.sort(files);
        List<String> directories = Arrays.asList(f.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return new File(dir, name).isDirectory();
            }
        }));
        Collections.sort(directories);
        if (up != null || directories.size() + files.size() > 0) {
            msg.append("<ul>");
            if (up != null || directories.size() > 0) {
                msg.append("<section class=\"directories\">");
                if (up != null) {
                    msg.append("<li><a rel=\"directory\" href=\"").append(up).append("\"><span class=\"dirname\">..</span></a></b></li>");
                }
                for (String directory : directories) {
                    String dir = directory + "/";
                    msg.append("<li><a rel=\"directory\" href=\"").append(this.encodeUri(uri + dir)).append("\"><span class=\"dirname\">").append(dir).append("</span></a></b></li>");
                }
                msg.append("</section>");
            }
            if (files.size() > 0) {
                msg.append("<section class=\"files\">");
                for (String file : files) {
                    msg.append("<li><a href=\"").append(this.encodeUri(uri + file)).append("\"><span class=\"filename\">").append(file).append("</span></a>");
                    File curFile = new File(f, file);
                    long len = curFile.length();
                    msg.append("&nbsp;<span class=\"filesize\">(");
                    if (len < 1024L) {
                        msg.append(len).append(" bytes");
                    } else if (len < 0x100000L) {
                        msg.append(len / 1024L).append(".").append(len % 1024L / 10L % 100L).append(" KB");
                    } else {
                        msg.append(len / 0x100000L).append(".").append(len % 0x100000L / 10000L % 100L).append(" MB");
                    }
                    msg.append(")</span></li>");
                }
                msg.append("</section>");
            }
            msg.append("</ul>");
        }
        msg.append("</body></html>");
        return msg.toString();
    }

    public static NanoHTTPD.Response newFixedLengthResponse(NanoHTTPD.Response.IStatus status, String mimeType, String message) {
        NanoHTTPD.Response response = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)status, (String)mimeType, (String)message);
        response.addHeader("Accept-Ranges", "bytes");
        return response;
    }

    private NanoHTTPD.Response respond(Map<String, String> headers, NanoHTTPD.IHTTPSession session, String uri) {
        return this.defaultRespond(headers, session, uri);
    }

    private NanoHTTPD.Response defaultRespond(Map<String, String> headers, NanoHTTPD.IHTTPSession session, String uri) {
        if (((String)(uri = ((String)uri).trim().replace(File.separatorChar, '/'))).indexOf(63) >= 0) {
            uri = ((String)uri).substring(0, ((String)uri).indexOf(63));
        }
        if (((String)uri).contains("../")) {
            return this.getForbiddenResponse("Won't serve ../ for security reasons.");
        }
        if (!this.canServeUri((String)uri)) {
            return this.getNotFoundResponse();
        }
        File f = new File((String)uri);
        if (f.isDirectory() && !((String)uri).endsWith("/")) {
            uri = (String)uri + "/";
            NanoHTTPD.Response res = FileServer.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.REDIRECT, "text/html", "<html><body>Redirected: <a href=\"" + (String)uri + "\">" + (String)uri + "</a></body></html>");
            res.addHeader("Location", (String)uri);
            return res;
        }
        if (f.isDirectory()) {
            String indexFile = this.findIndexFileInDirectory(f);
            if (indexFile == null) {
                if (f.canRead()) {
                    return FileServer.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, "text/html", this.listDirectory((String)uri, f));
                }
                return this.getForbiddenResponse("No directory listing.");
            }
            return this.respond(headers, session, (String)uri + indexFile);
        }
        String mimeTypeForFile = FileServer.getMimeTypeForFile((String)uri);
        NanoHTTPD.Response response = null;
        response = this.serveFile((String)uri, headers, f, mimeTypeForFile);
        return response != null ? response : this.getNotFoundResponse();
    }

    public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
        Map header = session.getHeaders();
        Map parms = session.getParms();
        String uri = session.getUri();
        Objects.requireNonNull(this);
        return this.respond(Collections.unmodifiableMap(header), session, uri);
    }

    NanoHTTPD.Response serveFile(String uri, Map<String, String> header, File file, String mime) {
        NanoHTTPD.Response res;
        try {
            String ifRange;
            String etag = Integer.toHexString((file.getAbsolutePath() + file.lastModified() + file.length()).hashCode());
            long startFrom = 0L;
            long endAt = -1L;
            String range = header.get("range");
            if (range != null && range.startsWith("bytes=")) {
                range = range.substring("bytes=".length());
                int minus = range.indexOf(45);
                try {
                    if (minus > 0) {
                        startFrom = Long.parseLong(range.substring(0, minus));
                        endAt = Long.parseLong(range.substring(minus + 1));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            boolean headerIfRangeMissingOrMatching = (ifRange = header.get("if-range")) == null || etag.equals(ifRange);
            String ifNoneMatch = header.get("if-none-match");
            boolean headerIfNoneMatchPresentAndMatching = ifNoneMatch != null && ("*".equals(ifNoneMatch) || ifNoneMatch.equals(etag));
            long fileLen = file.length();
            if (headerIfRangeMissingOrMatching && range != null && startFrom >= 0L && startFrom < fileLen) {
                if (headerIfNoneMatchPresentAndMatching) {
                    res = FileServer.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NOT_MODIFIED, mime, "");
                    res.addHeader("ETag", etag);
                } else {
                    long newLen;
                    if (endAt < 0L) {
                        endAt = fileLen - 1L;
                    }
                    if ((newLen = endAt - startFrom + 1L) < 0L) {
                        newLen = 0L;
                    }
                    FileInputStream fis = new FileInputStream(file);
                    fis.skip(startFrom);
                    res = FileServer.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.PARTIAL_CONTENT, (String)mime, (InputStream)fis, (long)newLen);
                    res.addHeader("Accept-Ranges", "bytes");
                    res.addHeader("Content-Length", "" + newLen);
                    res.addHeader("Content-Range", "bytes " + startFrom + "-" + endAt + "/" + fileLen);
                    res.addHeader("ETag", etag);
                }
            } else if (headerIfRangeMissingOrMatching && range != null && startFrom >= fileLen) {
                res = FileServer.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.RANGE_NOT_SATISFIABLE, "text/plain", "");
                res.addHeader("Content-Range", "bytes */" + fileLen);
                res.addHeader("ETag", etag);
            } else if (range == null && headerIfNoneMatchPresentAndMatching) {
                res = FileServer.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NOT_MODIFIED, mime, "");
                res.addHeader("ETag", etag);
            } else if (!headerIfRangeMissingOrMatching && headerIfNoneMatchPresentAndMatching) {
                res = FileServer.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NOT_MODIFIED, mime, "");
                res.addHeader("ETag", etag);
            } else {
                res = this.newFixedFileResponse(file, mime);
                res.addHeader("Content-Length", "" + fileLen);
                res.addHeader("ETag", etag);
            }
        }
        catch (IOException ioe) {
            res = this.getForbiddenResponse("Reading file failed.");
        }
        return res;
    }

    private NanoHTTPD.Response newFixedFileResponse(File file, String mime) throws FileNotFoundException {
        NanoHTTPD.Response res = FileServer.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)mime, (InputStream)new FileInputStream(file), (long)((int)file.length()));
        res.addHeader("Accept-Ranges", "bytes");
        return res;
    }

    static class Info {
        private final int port;

        private Info(int port) {
            this.port = port;
        }

        int getPort() {
            return this.port;
        }
    }
}

