/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.hub.net;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.praxislive.core.ComponentType;
import org.praxislive.core.Value;
import org.praxislive.core.types.PArray;
import org.praxislive.core.types.PMap;
import org.praxislive.hub.net.ProxyInfo;

public class DefaultProxyInfo
implements ProxyInfo {
    private static final String KEY_HOST = "host";
    private static final String KEY_PORT = "port";
    private static final String KEY_TYPE_PATTERN = "type-pattern";
    private static final String KEY_ID_PATTERN = "id-pattern";
    private static final String KEY_EXEC = "exec";
    private static final String KEY_EXEC_COMMAND = "command";
    private static final String VALUE_EXEC_DEFAULT = "default";
    private static final String KEY_EXEC_OPTIONS = "java-options";
    private static final String KEY_EXEC_ARGS = "arguments";
    private final InetSocketAddress socketAddress;
    private final Pattern typePattern;
    private final Pattern idPattern;
    private final Exec exec;

    private DefaultProxyInfo(Builder builder) {
        this.socketAddress = builder.address;
        this.typePattern = builder.typeMatch;
        this.idPattern = builder.idMatch;
        this.exec = builder.exec;
    }

    @Override
    public InetSocketAddress socketAddress() {
        return this.socketAddress;
    }

    @Override
    public boolean matches(String rootID, ComponentType rootType) {
        if (!this.idPattern.matcher(rootID).matches()) {
            return false;
        }
        String tp = rootType.toString();
        if (!tp.startsWith("root:")) {
            return false;
        }
        tp = tp.substring(5);
        return this.typePattern.matcher(tp).matches();
    }

    @Override
    public Optional<ProxyInfo.Exec> exec() {
        return Optional.ofNullable(this.exec);
    }

    public static DefaultProxyInfo fromMap(PMap conf) {
        Builder builder = DefaultProxyInfo.builder();
        String host = conf.getString(KEY_HOST, "localhost");
        int port = conf.getInt(KEY_PORT, 0);
        if (!"localhost".equalsIgnoreCase(host)) {
            builder.address(host, port);
        } else {
            builder.address(port);
        }
        builder.typeMatch(conf.getString(KEY_TYPE_PATTERN, "*"));
        builder.idMatch(conf.getString(KEY_ID_PATTERN, "*"));
        Value exec = conf.get(KEY_EXEC);
        if (exec != null) {
            PMap execMap = (PMap)PMap.from((Value)exec).orElseThrow(IllegalArgumentException::new);
            String command = execMap.getString(KEY_EXEC_COMMAND, VALUE_EXEC_DEFAULT);
            List<String> options = DefaultProxyInfo.extractArgsList(execMap.get(KEY_EXEC_OPTIONS));
            List<String> args = DefaultProxyInfo.extractArgsList(execMap.get(KEY_EXEC_ARGS));
            if (VALUE_EXEC_DEFAULT.equals(command)) {
                builder.execDefault(options, args);
            } else {
                builder.execCommand(command, args);
            }
        }
        return new DefaultProxyInfo(builder);
    }

    private static List<String> extractArgsList(Value value) {
        if (value == null) {
            return List.of();
        }
        return ((PArray)PArray.from((Value)value).orElseThrow(IllegalArgumentException::new)).stream().map(Value::toString).collect(Collectors.toList());
    }

    static Builder builder() {
        return new Builder();
    }

    private static class Exec
    implements ProxyInfo.Exec {
        private final Optional<String> command;
        private final List<String> javaOptions;
        private final List<String> arguments;

        Exec(Optional<String> command, List<String> javaOptions, List<String> arguments) {
            this.command = command;
            this.javaOptions = javaOptions;
            this.arguments = arguments;
        }

        @Override
        public Optional<String> command() {
            return this.command;
        }

        @Override
        public List<String> javaOptions() {
            return this.javaOptions;
        }

        @Override
        public List<String> arguments() {
            return this.arguments;
        }
    }

    static class Builder {
        private static final Pattern DEFAULT_MATCH = Builder.globToRegex("*");
        private InetSocketAddress address = new InetSocketAddress(InetAddress.getLoopbackAddress(), 0);
        private Pattern typeMatch = DEFAULT_MATCH;
        private Pattern idMatch = DEFAULT_MATCH;
        private Exec exec = null;

        private Builder() {
        }

        public Builder address(int port) {
            this.address = new InetSocketAddress(InetAddress.getLoopbackAddress(), port);
            return this;
        }

        public Builder address(String host, int port) {
            this.address = new InetSocketAddress(host, port);
            return this;
        }

        public Builder typeMatch(String glob) {
            this.typeMatch = Builder.globToRegex(glob);
            return this;
        }

        public Builder idMatch(String glob) {
            this.idMatch = Builder.globToRegex(glob);
            return this;
        }

        public Builder execDefault(List<String> javaOptions, List<String> arguments) {
            this.exec = new Exec(Optional.empty(), List.copyOf(javaOptions), List.copyOf(arguments));
            return this;
        }

        public Builder execCommand(String command, List<String> arguments) {
            this.exec = new Exec(Optional.of(command), List.of(), List.copyOf(arguments));
            return this;
        }

        public DefaultProxyInfo build() {
            return new DefaultProxyInfo(this);
        }

        private static Pattern globToRegex(String glob) {
            StringBuilder regex = new StringBuilder();
            block7: for (char c : glob.toCharArray()) {
                switch (c) {
                    case '*': {
                        regex.append(".*");
                        continue block7;
                    }
                    case '?': {
                        regex.append('.');
                        continue block7;
                    }
                    case '|': {
                        regex.append('|');
                        continue block7;
                    }
                    case '_': {
                        regex.append('_');
                        continue block7;
                    }
                    case '-': {
                        regex.append("\\-");
                        continue block7;
                    }
                    default: {
                        if (Character.isJavaIdentifierPart(c)) {
                            regex.append(c);
                            continue block7;
                        }
                        throw new IllegalArgumentException();
                    }
                }
            }
            return Pattern.compile(regex.toString());
        }
    }
}

