/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.hub.net;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;

class ChildRegistry {
    static final ChildRegistry INSTANCE = new ChildRegistry();
    private final Set<Process> processes = new HashSet<Process>();

    private ChildRegistry() {
        Runtime.getRuntime().addShutdownHook(new Thread(this::terminate));
    }

    synchronized void add(Process child) {
        this.processes.add(child);
    }

    synchronized void remove(Process child) {
        this.processes.remove(child);
    }

    private synchronized void terminate() {
        this.processes.forEach(this::terminate);
        this.processes.clear();
    }

    private void terminate(Process process) {
        if (process.isAlive()) {
            boolean exited = false;
            process.destroy();
            try {
                exited = process.waitFor(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!exited) {
                process.destroyForcibly();
            }
        }
    }
}

