/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.audio.code;

import java.lang.reflect.Field;
import org.jaudiolibs.pipes.Pipe;
import org.praxislive.audio.code.AudioCodeConnector;
import org.praxislive.audio.code.AudioCodeContext;
import org.praxislive.audio.code.AudioCodeDelegate;
import org.praxislive.code.CodeContext;
import org.praxislive.core.services.LogLevel;

class UGenDescriptor {
    private final Field field;
    private final Field previousField;
    private Pipe ugen;

    private UGenDescriptor(Field field, Field previousField, Pipe ugen) {
        this.field = field;
        this.previousField = previousField;
        this.ugen = ugen;
    }

    void attach(AudioCodeContext<?> context, CodeContext<?> previous) {
        if (this.ugen == null) {
            try {
                this.ugen = (Pipe)this.previousField.get(previous.getDelegate());
            }
            catch (Exception ex) {
                context.getLog().log(LogLevel.ERROR, ex);
                return;
            }
        }
        try {
            this.field.set(context.getDelegate(), this.ugen);
        }
        catch (Exception ex) {
            context.getLog().log(LogLevel.ERROR, ex);
        }
    }

    Pipe getUGen() {
        return this.ugen;
    }

    static UGenDescriptor create(AudioCodeConnector connector, Field field) {
        Class<?> fieldType = field.getType();
        if (!Pipe.class.isAssignableFrom(fieldType)) {
            return null;
        }
        field.setAccessible(true);
        Field oldField = null;
        Class<AudioCodeDelegate> oldClass = connector.getPreviousClass();
        if (oldClass != null) {
            try {
                Field f = oldClass.getDeclaredField(field.getName());
                if (f.getType() == field.getType()) {
                    f.setAccessible(true);
                    oldField = f;
                }
            }
            catch (Exception f) {
                // empty catch block
            }
        }
        Pipe ugen = null;
        if (oldField == null) {
            try {
                ugen = field.getType().asSubclass(Pipe.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                connector.getLog().log(LogLevel.ERROR, ex);
                return null;
            }
        }
        return new UGenDescriptor(field, oldField, ugen);
    }
}

