/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.audio.code;

import org.jaudiolibs.pipes.Pipe;
import org.praxislive.audio.AudioContext;
import org.praxislive.audio.code.AudioCodeConnector;
import org.praxislive.audio.code.AudioCodeDelegate;
import org.praxislive.audio.code.AudioInPort;
import org.praxislive.audio.code.AudioOutPort;
import org.praxislive.audio.code.UGenDescriptor;
import org.praxislive.audio.code.Utils;
import org.praxislive.code.CodeComponent;
import org.praxislive.code.CodeContext;
import org.praxislive.code.PortDescriptor;
import org.praxislive.core.ExecutionContext;
import org.praxislive.core.services.LogLevel;

public class AudioCodeContext<D extends AudioCodeDelegate>
extends CodeContext<D> {
    private final UGenDescriptor[] ugens;
    private final AudioInPort.Descriptor[] ins;
    private final AudioOutPort.Descriptor[] outs;
    private AudioContext audioCtxt;

    public AudioCodeContext(AudioCodeConnector<D> connector) {
        super(connector, true);
        this.ugens = connector.extractUGens();
        this.ins = connector.extractIns();
        this.outs = connector.extractOuts();
    }

    protected void configure(CodeComponent<D> cmp, CodeContext<D> oldCtxt) {
        super.configure(cmp, oldCtxt);
        for (UGenDescriptor ugd : this.ugens) {
            ugd.attach(this, oldCtxt);
        }
    }

    protected void hierarchyChanged() {
        this.audioCtxt = this.getLookup().find(AudioContext.class).orElse(null);
    }

    protected void starting(ExecutionContext source) {
        this.setupDelegate();
    }

    protected void stopping(ExecutionContext source) {
        this.resetPorts();
    }

    protected void tick(ExecutionContext source) {
        this.updateDelegate();
    }

    private void setupDelegate() {
        this.setupPorts();
        this.setupUGens();
        AudioCodeDelegate delegate = (AudioCodeDelegate)this.getDelegate();
        if (this.audioCtxt != null) {
            delegate.sampleRate = this.audioCtxt.getSampleRate();
            delegate.blockSize = this.audioCtxt.getBlockSize();
        } else {
            delegate.sampleRate = 48000.0;
            delegate.blockSize = 64;
        }
        try {
            delegate.init();
        }
        catch (Exception e) {
            this.getLog().log(LogLevel.ERROR, e, "Exception thrown during setup()");
        }
    }

    private void updateDelegate() {
        try {
            ((AudioCodeDelegate)this.getDelegate()).update();
        }
        catch (Exception e) {
            this.getLog().log(LogLevel.ERROR, e, "Exception thrown during update()");
        }
    }

    private void setupUGens() {
        for (UGenDescriptor ugd : this.ugens) {
            Pipe ug = ugd.getUGen();
            Utils.disconnect(ug);
            ug.reset();
        }
    }

    private void setupPorts() {
        for (AudioInPort.Descriptor descriptor : this.ins) {
            Utils.disconnectSinks(descriptor.getPort().getPipe());
        }
        for (PortDescriptor portDescriptor : this.outs) {
            AudioOutPort.AudioOutPipe pipe = portDescriptor.getPort().getPipe();
            Utils.disconnectSources(pipe);
            pipe.triggerSwitch();
        }
    }

    private void resetPorts() {
        for (AudioOutPort.Descriptor aopd : this.outs) {
            AudioOutPort.AudioOutPipe pipe = aopd.getPort().getPipe();
            pipe.resetSwitch();
        }
    }
}

