/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.audio.code;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.jaudiolibs.pipes.Pipe;
import org.jaudiolibs.pipes.units.AudioTable;
import org.praxislive.audio.code.AudioCodeDelegate;
import org.praxislive.audio.code.AudioInPort;
import org.praxislive.audio.code.AudioOutPort;
import org.praxislive.audio.code.TableLoader;
import org.praxislive.audio.code.UGenDescriptor;
import org.praxislive.audio.code.userapi.AudioIn;
import org.praxislive.audio.code.userapi.AudioOut;
import org.praxislive.audio.code.userapi.UGen;
import org.praxislive.code.CodeConnector;
import org.praxislive.code.CodeFactory;
import org.praxislive.code.ControlDescriptor;
import org.praxislive.code.ResourceProperty;
import org.praxislive.code.userapi.In;
import org.praxislive.code.userapi.Out;
import org.praxislive.code.userapi.P;

public class AudioCodeConnector<D extends AudioCodeDelegate>
extends CodeConnector<D> {
    private final Class<? extends AudioCodeDelegate> previousClass;
    private final List<AudioInPort.Descriptor> ins;
    private final List<AudioOutPort.Descriptor> outs;
    private final List<UGenDescriptor> ugens;

    public AudioCodeConnector(CodeFactory.Task<D> task, D delegate, Class<? extends AudioCodeDelegate> previousClass) {
        super(task, delegate);
        this.previousClass = previousClass;
        this.ins = new ArrayList<AudioInPort.Descriptor>();
        this.outs = new ArrayList<AudioOutPort.Descriptor>();
        this.ugens = new ArrayList<UGenDescriptor>();
    }

    protected void analyseField(Field field) {
        ResourceProperty.Descriptor ipd;
        P p;
        UGenDescriptor ugd;
        AudioOutPort.Descriptor aod;
        Out out;
        AudioInPort.Descriptor aid;
        In in;
        if (AudioIn.class.isAssignableFrom(field.getType()) && (in = field.getAnnotation(In.class)) != null && (aid = AudioInPort.createDescriptor(this, in, field)) != null) {
            this.addPort(aid);
            this.ins.add(aid);
            return;
        }
        if (AudioOut.class.isAssignableFrom(field.getType()) && (out = field.getAnnotation(Out.class)) != null && (aod = AudioOutPort.createDescriptor(this, out, field)) != null) {
            this.addPort(aod);
            this.outs.add(aod);
            return;
        }
        if (field.isAnnotationPresent(UGen.class) && Pipe.class.isAssignableFrom(field.getType()) && (ugd = UGenDescriptor.create(this, field)) != null) {
            this.ugens.add(ugd);
            return;
        }
        if (AudioTable.class.isAssignableFrom(field.getType()) && (p = field.getAnnotation(P.class)) != null && (ipd = ResourceProperty.Descriptor.create((CodeConnector)this, (P)p, (Field)field, (ResourceProperty.Loader)TableLoader.getDefault())) != null) {
            this.addControl((ControlDescriptor)ipd);
            if (this.shouldAddPort(field)) {
                this.addPort(ipd.createPortDescriptor());
            }
            return;
        }
        super.analyseField(field);
    }

    UGenDescriptor[] extractUGens() {
        return this.ugens.toArray(new UGenDescriptor[this.ugens.size()]);
    }

    AudioInPort.Descriptor[] extractIns() {
        return this.ins.toArray(new AudioInPort.Descriptor[this.ins.size()]);
    }

    AudioOutPort.Descriptor[] extractOuts() {
        return this.outs.toArray(new AudioOutPort.Descriptor[this.outs.size()]);
    }

    Class<? extends AudioCodeDelegate> getPreviousClass() {
        return this.previousClass;
    }
}

