/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.audio.code;

class NoteUtils {
    private NoteUtils() {
    }

    static int noteToMidi(String note) {
        int midi;
        int len = note.length();
        if (len < 2 || len > 3) {
            return -1;
        }
        switch (note.charAt(0)) {
            case 'C': 
            case 'c': {
                midi = 0;
                break;
            }
            case 'D': 
            case 'd': {
                midi = 2;
                break;
            }
            case 'E': 
            case 'e': {
                midi = 4;
                break;
            }
            case 'F': 
            case 'f': {
                midi = 5;
                break;
            }
            case 'G': 
            case 'g': {
                midi = 7;
                break;
            }
            case 'A': 
            case 'a': {
                midi = 9;
                break;
            }
            case 'B': 
            case 'b': {
                midi = 11;
                break;
            }
            default: {
                return -1;
            }
        }
        block9 : switch (len) {
            case 3: {
                switch (note.charAt(1)) {
                    case '#': {
                        ++midi;
                        break block9;
                    }
                    case 'b': {
                        --midi;
                        break block9;
                    }
                }
                return -1;
            }
        }
        int octave = note.charAt(len - 1) - 48;
        if (octave < 0 || octave > 9) {
            return -1;
        }
        return midi += octave * 12 + 12;
    }

    static double midiToFrequency(int midi) {
        return midi < 1 ? 0.0 : 440.0 * Math.pow(2.0, ((double)midi - 69.0) / 12.0);
    }
}

