/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.audio.code;

import java.lang.reflect.Field;
import java.util.List;
import org.jaudiolibs.pipes.Buffer;
import org.jaudiolibs.pipes.Pipe;
import org.praxislive.audio.AudioPort;
import org.praxislive.audio.DefaultAudioInputPort;
import org.praxislive.audio.code.userapi.AudioIn;
import org.praxislive.code.CodeConnector;
import org.praxislive.code.CodeContext;
import org.praxislive.code.PortDescriptor;
import org.praxislive.code.userapi.AuxIn;
import org.praxislive.code.userapi.In;
import org.praxislive.core.Port;
import org.praxislive.core.PortInfo;
import org.praxislive.core.services.LogLevel;
import org.praxislive.core.types.PMap;

class AudioInPort
extends DefaultAudioInputPort {
    private final AudioInPipe in;

    private AudioInPort(AudioInPipe in) {
        super((Pipe)in);
        this.in = in;
    }

    AudioInPipe getPipe() {
        return this.in;
    }

    static Descriptor createDescriptor(CodeConnector<?> connector, In ann, Field field) {
        return AudioInPort.createDescriptor(connector, PortDescriptor.Category.In, ann.value(), field);
    }

    static Descriptor createDescriptor(CodeConnector<?> connector, AuxIn ann, Field field) {
        return AudioInPort.createDescriptor(connector, PortDescriptor.Category.AuxIn, ann.value(), field);
    }

    private static Descriptor createDescriptor(CodeConnector<?> connector, PortDescriptor.Category category, int index, Field field) {
        if (!AudioIn.class.isAssignableFrom(field.getType())) {
            return null;
        }
        String id = connector.findID(field);
        return new Descriptor(id, category, index, field);
    }

    static class Descriptor
    extends PortDescriptor {
        private static final PortInfo INFO = PortInfo.create(AudioPort.class, (PortInfo.Direction)PortInfo.Direction.IN, (PMap)PMap.EMPTY);
        private final Field field;
        private AudioInPort port;

        private Descriptor(String id, PortDescriptor.Category category, int index, Field field) {
            super(id, category, index);
            field.setAccessible(true);
            this.field = field;
        }

        public void attach(CodeContext<?> context, Port previous) {
            if (previous instanceof AudioInPort) {
                this.port = (AudioInPort)previous;
            } else {
                if (previous != null) {
                    previous.disconnectAll();
                }
                this.port = new AudioInPort(new AudioInPipe());
            }
            try {
                this.field.set(context.getDelegate(), (Object)this.port.in);
            }
            catch (Exception ex) {
                context.getLog().log(LogLevel.ERROR, ex);
            }
        }

        public AudioInPort getPort() {
            return this.port;
        }

        public PortInfo getInfo() {
            return INFO;
        }
    }

    static class AudioInPipe
    extends AudioIn {
        AudioInPipe() {
        }

        protected void process(List<Buffer> list) {
        }
    }
}

