/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.audio.code;

import java.lang.reflect.Field;
import java.util.List;
import org.jaudiolibs.pipes.Buffer;
import org.jaudiolibs.pipes.Pipe;
import org.praxislive.audio.AudioPort;
import org.praxislive.audio.DefaultAudioOutputPort;
import org.praxislive.audio.code.userapi.AudioOut;
import org.praxislive.code.CodeConnector;
import org.praxislive.code.CodeContext;
import org.praxislive.code.PortDescriptor;
import org.praxislive.code.userapi.AuxOut;
import org.praxislive.code.userapi.Out;
import org.praxislive.core.Port;
import org.praxislive.core.PortInfo;
import org.praxislive.core.services.LogLevel;
import org.praxislive.core.types.PMap;

class AudioOutPort
extends DefaultAudioOutputPort {
    private final AudioOutPipe out;

    private AudioOutPort(AudioOutPipe out) {
        super((Pipe)out);
        this.out = out;
    }

    AudioOutPipe getPipe() {
        return this.out;
    }

    static Descriptor createDescriptor(CodeConnector<?> connector, Out ann, Field field) {
        return AudioOutPort.createDescriptor(connector, PortDescriptor.Category.Out, ann.value(), field);
    }

    static Descriptor createDescriptor(CodeConnector<?> connector, AuxOut ann, Field field) {
        return AudioOutPort.createDescriptor(connector, PortDescriptor.Category.AuxOut, ann.value(), field);
    }

    private static Descriptor createDescriptor(CodeConnector<?> connector, PortDescriptor.Category category, int index, Field field) {
        if (!AudioOut.class.isAssignableFrom(field.getType())) {
            return null;
        }
        String id = connector.findID(field);
        return new Descriptor(id, category, index, field);
    }

    static class Descriptor
    extends PortDescriptor {
        private static final PortInfo INFO = PortInfo.create(AudioPort.class, (PortInfo.Direction)PortInfo.Direction.OUT, (PMap)PMap.EMPTY);
        private final Field field;
        private AudioOutPort port;

        private Descriptor(String id, PortDescriptor.Category category, int index, Field field) {
            super(id, category, index);
            field.setAccessible(true);
            this.field = field;
        }

        public void attach(CodeContext<?> context, Port previous) {
            if (previous instanceof AudioOutPort) {
                this.port = (AudioOutPort)previous;
            } else {
                if (previous != null) {
                    previous.disconnectAll();
                }
                this.port = new AudioOutPort(new AudioOutPipe());
            }
            this.port.out.context = context;
            try {
                this.field.set(context.getDelegate(), (Object)this.port.out);
            }
            catch (Exception ex) {
                context.getLog().log(LogLevel.ERROR, ex);
            }
        }

        public AudioOutPort getPort() {
            return this.port;
        }

        public PortInfo getInfo() {
            return INFO;
        }
    }

    static class AudioOutPipe
    extends AudioOut {
        private float last;
        private boolean switchAndRamp;
        private CodeContext<?> context;

        AudioOutPipe() {
        }

        public void process(Pipe sink, Buffer buffer, long time) {
            try {
                super.process(sink, buffer, time);
                if (!this.isProcessRequired(time)) {
                    this.last = 0.0f;
                    this.switchAndRamp = false;
                }
            }
            catch (Exception ex) {
                this.context.getLog().log(LogLevel.ERROR, ex);
            }
        }

        protected void process(List<Buffer> list) {
            this.process(list.get(0));
        }

        void process(Buffer buffer) {
            float[] data = buffer.getData();
            int bsize = buffer.getSize();
            if (this.switchAndRamp) {
                float factor = this.last - data[0];
                float delta = factor / (float)bsize;
                for (int i = 0; i < bsize; ++i) {
                    data[i] = data[i] + factor;
                    factor -= delta;
                }
                this.switchAndRamp = false;
            } else {
                this.last = data[bsize - 1];
            }
        }

        void triggerSwitch() {
            this.switchAndRamp = true;
        }

        void resetSwitch() {
            this.switchAndRamp = false;
            this.last = 0.0f;
        }
    }
}

