/*
 * Decompiled with CFR 0.152.
 */
package org.plumelib.bcelutil;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.StackMap;
import org.apache.bcel.classfile.StackMapEntry;
import org.apache.bcel.classfile.StackMapType;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.IINC;
import org.apache.bcel.generic.IndexedInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LoadInstruction;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.LocalVariableInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.StoreInstruction;
import org.apache.bcel.generic.Type;
import org.apache.bcel.verifier.VerificationResult;
import org.apache.bcel.verifier.structurals.OperandStack;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.index.qual.IndexOrLow;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.InternedDistinct;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.checker.mustcall.qual.MustCall;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.regex.qual.UnknownRegex;
import org.checkerframework.checker.signature.qual.ClassGetName;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.checker.signedness.qual.Signed;
import org.checkerframework.common.initializedfields.qual.InitializedFields;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;
import org.checkerframework.common.value.qual.UnknownVal;
import org.checkerframework.dataflow.qual.Pure;
import org.plumelib.bcelutil.BcelUtil;
import org.plumelib.bcelutil.SimpleLog;
import org.plumelib.bcelutil.StackTypes;
import org.plumelib.bcelutil.StackVer;

public abstract class StackMapUtils {
    protected @Nullable @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) ConstantPoolGen pool = null;
    protected @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) SimpleLog debugInstrument = new SimpleLog(false);
    protected @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) boolean needStackMap = false;
    protected @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) StackMapEntry @Nullable @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) [] stackMapTable = null;
    protected @Nullable @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) StackMap smta = null;
    protected @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) StackMapType @MonotonicNonNull @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) [] initialTypeList;
    protected @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) int initialLocalsCount;
    protected @NonNegative @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) int numberActiveLocals;
    protected @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) int runningOffset;
    protected @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) int firstLocalIndex;
    private @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) StackMapEntry @InternedDistinct @UnknownFormat @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) [] emptyStackmaptable = new StackMapEntry[0];
    private @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) Map<@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) InstructionHandle, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) Integer> uninitializedNewMap = new HashMap<InstructionHandle, Integer>();
    protected @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) InstructionHandle liveRangeStart = null;
    protected @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) InstructionHandle liveRangeEnd = null;
    protected @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) Type liveRangeType = null;
    protected @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) int liveRangeOperandSize = 0;
    protected @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) StackTypes stackTypes = null;

    protected @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) String @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) [] addString(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) String @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) [] arr, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) String newString) {
        String[] newArr = new String[arr.length + 1];
        for (int ii = 0; ii < arr.length; ++ii) {
            newArr[ii] = arr[ii];
        }
        newArr[arr.length] = newString;
        return newArr;
    }

    @Pure
    protected final @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) String get_attribute_name(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) Attribute a) {
        int conIndex = a.getNameIndex();
        Constant c = this.pool.getConstant(conIndex);
        String attName = ((ConstantUtf8)c).getBytes();
        return attName;
    }

    @Pure
    protected final @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) boolean is_local_variable_type_table(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) Attribute a) {
        return this.get_attribute_name(a).equals("LocalVariableTypeTable");
    }

    @Pure
    protected final @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) boolean isStackMapTable(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) Attribute a) {
        return this.get_attribute_name(a).equals("StackMapTable");
    }

    @Pure
    protected final @Nullable @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) Attribute getStackMapTable_attribute(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) MethodGen mgen) {
        for (Attribute a : mgen.getCodeAttributes()) {
            if (!this.isStackMapTable(a)) continue;
            return a;
        }
        return null;
    }

    @Pure
    protected final @Nullable @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) Attribute get_local_variable_type_table_attribute(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) MethodGen mgen) {
        for (Attribute a : mgen.getCodeAttributes()) {
            if (!this.is_local_variable_type_table(a)) continue;
            return a;
        }
        return null;
    }

    protected final void remove_local_variable_type_table(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) MethodGen mgen) {
        mgen.removeLocalVariableTypeTable();
    }

    protected final void updateStackMapOffset(@UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) int position, @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) int delta) {
        this.runningOffset = -1;
        for (int i = 0; i < this.stackMapTable.length; ++i) {
            this.runningOffset = this.stackMapTable[i].getByteCodeOffset() + this.runningOffset + 1;
            if (this.runningOffset <= position) continue;
            this.stackMapTable[i].updateByteCodeOffset(delta);
            return;
        }
    }

    protected final @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) StackMapEntry findStackMapEqual(@UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) int offset) {
        this.runningOffset = -1;
        for (int i = 0; i < this.stackMapTable.length; ++i) {
            this.runningOffset = this.stackMapTable[i].getByteCodeOffset() + this.runningOffset + 1;
            if (this.runningOffset > offset) {
                throw new RuntimeException("Invalid StackMap offset 1");
            }
            if (this.runningOffset != offset) continue;
            return this.stackMapTable[i];
        }
        throw new RuntimeException("Invalid StackMap offset 2");
    }

    protected final @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) int findStackMapIndexBefore(@UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) int offset) {
        this.numberActiveLocals = this.initialLocalsCount;
        this.runningOffset = -1;
        for (int i = 0; i < this.stackMapTable.length; ++i) {
            this.runningOffset = this.runningOffset + this.stackMapTable[i].getByteCodeOffset() + 1;
            if (this.runningOffset >= offset) {
                if (i == 0) {
                    this.runningOffset = -1;
                    return -1;
                }
                this.runningOffset = this.runningOffset - this.stackMapTable[i].getByteCodeOffset() - 1;
                return i - 1;
            }
            int frameType = this.stackMapTable[i].getFrameType();
            if (frameType >= 252 && frameType <= 254) {
                this.numberActiveLocals += frameType - 251;
                continue;
            }
            if (frameType >= 248 && frameType <= 250) {
                this.numberActiveLocals -= 251 - frameType;
                continue;
            }
            if (frameType != 255) continue;
            this.numberActiveLocals = this.stackMapTable[i].getNumberOfLocals();
        }
        if (this.stackMapTable.length == 0) {
            return -1;
        }
        return this.stackMapTable.length - 1;
    }

    protected final @IndexOrLow(value={"stackMapTable"}) @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) int findStackMapIndexAfter(@UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) int offset) {
        this.runningOffset = -1;
        for (int i = 0; i < this.stackMapTable.length; ++i) {
            this.runningOffset = this.runningOffset + this.stackMapTable[i].getByteCodeOffset() + 1;
            if (this.runningOffset <= offset) continue;
            return i;
        }
        return -1;
    }

    protected final void modifyStackMapsForSwitches(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) InstructionHandle ih, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) InstructionList il) {
        if (!this.needStackMap) {
            return;
        }
        il.setPositions();
        while (ih != null) {
            Instruction inst = ih.getInstruction();
            short opcode = inst.getOpcode();
            if (opcode == 170 || opcode == 171) {
                int currentOffset = ih.getPosition();
                int index = this.findStackMapIndexAfter(currentOffset);
                if (index == -1) {
                    throw new RuntimeException("Invalid StackMap offset 3");
                }
                StackMapEntry stackMap = this.stackMapTable[index];
                int delta = currentOffset + inst.getLength() - this.runningOffset;
                if (delta != 0) {
                    stackMap.updateByteCodeOffset(delta);
                }
            }
            ih = ih.getNext();
        }
    }

    protected final void buildUninitializedNewMap(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) InstructionList il) {
        this.uninitializedNewMap.clear();
        il.setPositions();
        for (StackMapEntry smte : this.stackMapTable) {
            int i;
            int frameType = smte.getFrameType();
            if (!(frameType >= 64 && frameType <= 247 || frameType >= 252 && frameType <= 254) && frameType != 255) continue;
            if (smte.getNumberOfLocals() > 0) {
                for (StackMapType smt : smte.getTypesOfLocals()) {
                    if (smt.getType() != 8) continue;
                    i = smt.getIndex();
                    this.uninitializedNewMap.put(il.findHandle(i), i);
                }
            }
            if (smte.getNumberOfStackItems() <= 0) continue;
            for (StackMapType smt : smte.getTypesOfStackItems()) {
                if (smt.getType() != 8) continue;
                i = smt.getIndex();
                this.uninitializedNewMap.put(il.findHandle(i), i);
            }
        }
    }

    private final void updateNewObjectStackMapEntries(@UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) int oldOffset, @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) int newOffset) {
        for (StackMapEntry smte : this.stackMapTable) {
            int frameType = smte.getFrameType();
            if (!(frameType >= 64 && frameType <= 247 || frameType >= 252 && frameType <= 254) && frameType != 255) continue;
            if (smte.getNumberOfLocals() > 0) {
                for (StackMapType smt : smte.getTypesOfLocals()) {
                    if (smt.getType() != 8 || oldOffset != smt.getIndex()) continue;
                    smt.setIndex(newOffset);
                }
            }
            if (smte.getNumberOfStackItems() <= 0) continue;
            for (StackMapType smt : smte.getTypesOfStackItems()) {
                if (smt.getType() != 8 || oldOffset != smt.getIndex()) continue;
                smt.setIndex(newOffset);
            }
        }
    }

    protected final void updateUninitializedNewOffsets(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) InstructionList il) {
        il.setPositions();
        for (Map.Entry<InstructionHandle, Integer> e : this.uninitializedNewMap.entrySet()) {
            int newOffset;
            InstructionHandle ih = e.getKey();
            int oldOffset = e.getValue();
            if (oldOffset == (newOffset = ih.getPosition())) continue;
            this.updateNewObjectStackMapEntries(oldOffset, newOffset);
            e.setValue(newOffset);
        }
    }

    protected final void adjust_code_for_locals_change(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) MethodGen mgen, @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) int indexFirstMovedlocal, @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) int size) {
        InstructionList il = mgen.getInstructionList();
        for (InstructionHandle ih = il.getStart(); ih != null; ih = ih.getNext()) {
            int operand;
            Instruction inst = ih.getInstruction();
            int origLength = inst.getLength();
            if (inst instanceof RET || inst instanceof IINC) {
                IndexedInstruction indexInst = (IndexedInstruction)inst;
                if (indexInst.getIndex() >= indexFirstMovedlocal) {
                    indexInst.setIndex(indexInst.getIndex() + size);
                }
            } else if (inst instanceof LocalVariableInstruction && (operand = ((LocalVariableInstruction)inst).getIndex()) >= indexFirstMovedlocal) {
                ((LocalVariableInstruction)inst).setIndex(operand + size);
            }
            int delta = inst.getLength() - origLength;
            if (delta <= 0) continue;
            il.setPositions();
            this.updateStackMapOffset(ih.getPosition(), delta);
            this.modifyStackMapsForSwitches(ih, il);
        }
    }

    @EnsuresNonNull(value={"stackMapTable"})
    protected final void setCurrentStackMapTable(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) MethodGen mgen, @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) int javaClassVersion) {
        this.needStackMap = false;
        this.smta = (StackMap)this.getStackMapTable_attribute(mgen);
        if (this.smta != null) {
            this.stackMapTable = ((StackMap)this.smta.copy(this.smta.getConstantPool())).getStackMap();
            this.needStackMap = true;
            this.debugInstrument.log("Attribute tag: %s length: %d nameIndex: %d%n", this.smta.getTag(), this.smta.getLength(), this.smta.getNameIndex());
            mgen.removeCodeAttribute((Attribute)this.smta);
        } else {
            this.stackMapTable = this.emptyStackmaptable;
            if (javaClassVersion > 50) {
                this.needStackMap = true;
            }
        }
        this.printStackMapTable("Original");
    }

    protected final void printStackMapTable(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) String prefix) {
        this.debugInstrument.log("%nStackMap(%s) %s items:%n", prefix, this.stackMapTable.length);
        this.runningOffset = -1;
        for (int i = 0; i < this.stackMapTable.length; ++i) {
            this.runningOffset = this.stackMapTable[i].getByteCodeOffset() + this.runningOffset + 1;
            this.debugInstrument.log("@%03d %s %n", this.runningOffset, this.stackMapTable[i]);
        }
    }

    protected final void createNewStackMapAttribute(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) MethodGen mgen) throws @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) IOException {
        if (!this.needStackMap) {
            return;
        }
        if (this.stackMapTable == this.emptyStackmaptable) {
            return;
        }
        this.printStackMapTable("Final");
        StackMap mapTable = new StackMap(this.pool.addUtf8("StackMapTable"), 0, null, this.pool.getConstantPool());
        mapTable.setStackMap(this.stackMapTable);
        mgen.addCodeAttribute((Attribute)mapTable);
    }

    protected static @ClassGetName @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @InitializedFields(value={}) String typeToClassGetName(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) Type t) {
        if (t instanceof ObjectType) {
            return ((ObjectType)t).getClassName();
        }
        if (t instanceof BasicType) {
            return t.toString();
        }
        return t.getSignature().replace('/', '.');
    }

    protected final @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) StackMapType generateStackMapTypeFromType(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) Type t) {
        switch (t.getType()) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return new StackMapType(1, -1, this.pool.getConstantPool());
            }
            case 6: {
                return new StackMapType(2, -1, this.pool.getConstantPool());
            }
            case 7: {
                return new StackMapType(3, -1, this.pool.getConstantPool());
            }
            case 11: {
                return new StackMapType(4, -1, this.pool.getConstantPool());
            }
            case 13: 
            case 14: {
                return new StackMapType(7, this.pool.addClass(StackMapUtils.typeToClassGetName(t)), this.pool.getConstantPool());
            }
            case 15: {
                return new StackMapType(8, 0, this.pool.getConstantPool());
            }
        }
        throw new RuntimeException("Invalid type: " + t + t.getType());
    }

    protected final @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) Type generate_Type_from_StackMapType(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) StackMapType smt) {
        switch (smt.getType()) {
            case 0: 
            case 5: {
                return null;
            }
            case 1: {
                return Type.INT;
            }
            case 2: {
                return Type.FLOAT;
            }
            case 3: {
                return Type.DOUBLE;
            }
            case 4: {
                return Type.LONG;
            }
            case 7: {
                Constant c = this.pool.getConstantPool().getConstant(smt.getIndex());
                String className = ((ConstantClass)c).getBytes(this.pool.getConstantPool());
                if (className.charAt(0) == '[') {
                    return Type.getType((String)className);
                }
                return new ObjectType(className);
            }
        }
        Thread.dumpStack();
        assert (false) : "Invalid StackMapType: " + smt + smt.getType();
        throw new RuntimeException("Invalid StackMapType: " + smt + smt.getType());
    }

    protected final @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) int getSize(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) StackMapType smt) {
        switch (smt.getType()) {
            case 3: 
            case 4: {
                return 2;
            }
        }
        return 1;
    }

    protected final void update_full_frameStackMap_entries(@UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) int offset, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) Type typeNewVar, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) LocalVariableGen @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) [] locals) {
        for (int i = 0; i < this.stackMapTable.length; ++i) {
            int index;
            if (this.stackMapTable[i].getFrameType() != 255) continue;
            int numLocals = this.stackMapTable[i].getNumberOfLocals();
            StackMapType[] newLocalTypes = new StackMapType[numLocals + 1];
            StackMapType[] oldLocalTypes = this.stackMapTable[i].getTypesOfLocals();
            for (index = 0; index < numLocals && index < locals.length && locals[index].getIndex() < offset; ++index) {
                newLocalTypes[index] = oldLocalTypes[index];
            }
            newLocalTypes[index++] = this.generateStackMapTypeFromType(typeNewVar);
            while (index <= numLocals) {
                newLocalTypes[index] = oldLocalTypes[index - 1];
                ++index;
            }
            this.stackMapTable[i].setTypesOfLocals(newLocalTypes);
        }
    }

    protected final @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) LocalVariableGen addNewParameter(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) MethodGen mgen, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) String argName, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) Type argType) {
        boolean hasCode;
        LocalVariableGen argNew = null;
        LocalVariableGen[] locals = mgen.getLocalVariables();
        Type[] argTypes = mgen.getArgumentTypes();
        int newIndex = 0;
        int newOffset = 0;
        boolean bl = hasCode = mgen.getInstructionList() != null;
        if (hasCode) {
            if (!mgen.isStatic()) {
                ++newIndex;
                ++newOffset;
            }
            if (argTypes.length > 0) {
                LocalVariableGen lastArg = locals[(newIndex += argTypes.length) - 1];
                newOffset = lastArg.getIndex() + lastArg.getType().getSize();
            }
            argNew = mgen.addLocalVariable(argName, argType, newOffset, null, null);
            ++this.firstLocalIndex;
        }
        ++this.initialLocalsCount;
        argTypes = BcelUtil.postpendToArray(argTypes, argType);
        String[] argNames = this.addString(mgen.getArgumentNames(), argName);
        mgen.setArgumentTypes(argTypes);
        mgen.setArgumentNames(argNames);
        if (hasCode) {
            for (int i = newIndex; i < locals.length; ++i) {
                LocalVariableGen lv = locals[i];
                lv.setIndex(lv.getIndex() + argType.getSize());
            }
            mgen.setMaxLocals(mgen.getMaxLocals() + argType.getSize());
            this.debugInstrument.log("Added arg    %s%n", argNew.getIndex() + ": " + argNew.getName() + ", " + argNew.getType());
            this.adjust_code_for_locals_change(mgen, newOffset, argType.getSize());
            this.update_full_frameStackMap_entries(newOffset, argType, locals);
            this.debugInstrument.log("New LocalVariableTable:%n%s%n", mgen.getLocalVariableTable(this.pool));
        }
        return argNew;
    }

    protected final @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) LocalVariableGen create_method_scope_local(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) MethodGen mgen, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) String localName, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) Type localType) {
        LocalVariableGen lvNew;
        LocalVariableGen lv;
        int i;
        int maxOffset = 0;
        int newOffset = -1;
        LocalVariableGen[] locals = mgen.getLocalVariables();
        int compilerTempI = -1;
        int newIndex = -1;
        for (i = 0; i < locals.length; ++i) {
            lv = locals[i];
            if (i >= this.firstLocalIndex && lv.getStart().getPosition() != 0 && newOffset == -1) {
                if (compilerTempI != -1) {
                    newOffset = locals[compilerTempI].getIndex();
                    newIndex = compilerTempI;
                } else {
                    newOffset = lv.getIndex();
                    newIndex = i;
                }
            }
            maxOffset = lv.getIndex() + lv.getType().getSize();
            if (lv.getName().startsWith("DaIkOnTeMp")) {
                if (compilerTempI != -1) continue;
                compilerTempI = i;
                continue;
            }
            compilerTempI = -1;
        }
        if (newOffset == -1 && compilerTempI != -1) {
            newOffset = locals[compilerTempI].getIndex();
            newIndex = compilerTempI;
        }
        if (newOffset == -1) {
            newOffset = maxOffset;
            if (newOffset < mgen.getMaxLocals()) {
                mgen.setMaxLocals(mgen.getMaxLocals() + localType.getSize());
            }
            lvNew = mgen.addLocalVariable(localName, localType, newOffset, null, null);
        } else {
            lvNew = mgen.addLocalVariable(localName, localType, newOffset, null, null);
            for (i = newIndex; i < locals.length; ++i) {
                lv = locals[i];
                lv.setIndex(lv.getIndex() + localType.getSize());
            }
            mgen.setMaxLocals(mgen.getMaxLocals() + localType.getSize());
        }
        this.debugInstrument.log("Added local  %s%n", lvNew.getIndex() + ": " + lvNew.getName() + ", " + lvNew.getType());
        this.adjust_code_for_locals_change(mgen, newOffset, localType.getSize());
        this.update_full_frameStackMap_entries(newOffset, localType, locals);
        this.debugInstrument.log("New LocalVariableTable:%n%s%n", mgen.getLocalVariableTable(this.pool));
        return lvNew;
    }

    @EnsuresNonNull(value={"initialTypeList"})
    protected final void fixLocalVariableTable(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) MethodGen mgen) {
        int ii;
        LocalVariableGen newLvg;
        LocalVariableGen l;
        InstructionList il = mgen.getInstructionList();
        if (il == null) {
            this.firstLocalIndex = 0;
            return;
        }
        LocalVariableGen[] locals = mgen.getLocalVariables();
        for (int ii2 = 0; ii2 < locals.length; ++ii2) {
            locals[ii2] = (LocalVariableGen)locals[ii2].clone();
        }
        Type[] argTypes = mgen.getArgumentTypes();
        int offset = 0;
        int locIndex = 0;
        mgen.setMaxLocals();
        int maxLocals = mgen.getMaxLocals();
        mgen.removeLocalVariables();
        mgen.setMaxLocals(0);
        this.firstLocalIndex = argTypes.length;
        if (!mgen.isStatic()) {
            l = locals[0];
            newLvg = mgen.addLocalVariable(l.getName(), l.getType(), l.getIndex(), null, null);
            this.debugInstrument.log("Added <this> %s%n", newLvg.getIndex() + ": " + newLvg.getName() + ", " + newLvg.getType());
            locIndex = 1;
            offset = 1;
            ++this.firstLocalIndex;
        } else if (mgen.getClassName().startsWith("com.sun.proxy.") && mgen.getName().equals("<clinit>")) {
            newLvg = mgen.addLocalVariable("$clinit$hidden$" + offset, (Type)Type.INT, offset, null, null);
            this.debugInstrument.log("Added hidden proxy local  %s%n", newLvg.getIndex() + ": " + newLvg.getName() + ", " + newLvg.getType());
            offset = 1;
            ++this.firstLocalIndex;
        }
        for (int ii3 = 0; ii3 < argTypes.length; ++ii3) {
            if (locIndex >= locals.length || offset != locals[locIndex].getIndex()) {
                newLvg = mgen.addLocalVariable("$hidden$" + offset, argTypes[ii3], offset, null, null);
            } else {
                l = locals[locIndex];
                newLvg = mgen.addLocalVariable(l.getName(), l.getType(), l.getIndex(), null, null);
                ++locIndex;
            }
            this.debugInstrument.log("Added param  %s%n", newLvg.getIndex() + ": " + newLvg.getName() + ", " + newLvg.getType());
            offset += argTypes[ii3].getSize();
        }
        LocalVariableGen[] initialLocals = mgen.getLocalVariables();
        this.initialLocalsCount = initialLocals.length;
        this.initialTypeList = new StackMapType[this.initialLocalsCount];
        for (ii = 0; ii < this.initialLocalsCount; ++ii) {
            this.initialTypeList[ii] = this.generateStackMapTypeFromType(initialLocals[ii].getType());
        }
        this.stackTypes = null;
        for (ii = this.firstLocalIndex; ii < locals.length; ++ii) {
            l = locals[ii];
            if (l.getIndex() > offset) {
                offset = this.gen_locals(mgen, offset);
                --ii;
                continue;
            }
            newLvg = mgen.addLocalVariable(l.getName(), l.getType(), l.getIndex(), l.getStart(), l.getEnd());
            this.debugInstrument.log("Added local  %s%n", newLvg.getIndex() + ": " + newLvg.getName() + ", " + newLvg.getType());
            offset = newLvg.getIndex() + newLvg.getType().getSize();
        }
        while (offset < maxLocals) {
            offset = this.gen_locals(mgen, offset);
        }
        mgen.setMaxLocals();
    }

    @RequiresNonNull(value={"initialTypeList"})
    protected final @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) int gen_locals(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) MethodGen mgen, @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) int offset) {
        int liveStart = 0;
        Type liveType = null;
        InstructionList il = mgen.getInstructionList();
        il.setPositions();
        int localsOffsetHeight = 0;
        int byteCodeOffset = -1;
        int minSize = 3;
        this.numberActiveLocals = this.initialLocalsCount;
        StackMapType[] typesOfActiveLocals = new StackMapType[this.numberActiveLocals];
        for (int ii = 0; ii < this.numberActiveLocals; ++ii) {
            typesOfActiveLocals[ii] = this.initialTypeList[ii];
            localsOffsetHeight += this.getSize(this.initialTypeList[ii]);
        }
        for (StackMapEntry smte : this.stackMapTable) {
            int n;
            int frameType = smte.getFrameType();
            byteCodeOffset += smte.getByteCodeOffset() + 1;
            if (frameType >= 252 && frameType <= 254) {
                typesOfActiveLocals = Arrays.copyOf(typesOfActiveLocals, this.numberActiveLocals + frameType - 251);
                StackMapType[] stackMapTypeArray = smte.getTypesOfLocals();
                int n2 = stackMapTypeArray.length;
                for (n = 0; n < n2; ++n) {
                    StackMapType smt = stackMapTypeArray[n];
                    typesOfActiveLocals[this.numberActiveLocals++] = smt;
                    localsOffsetHeight += this.getSize(smt);
                }
            } else if (frameType >= 248 && frameType <= 250) {
                for (int numberToChop = 251 - frameType; numberToChop > 0; --numberToChop) {
                    localsOffsetHeight -= this.getSize(typesOfActiveLocals[--this.numberActiveLocals]);
                }
                typesOfActiveLocals = Arrays.copyOf(typesOfActiveLocals, this.numberActiveLocals);
            } else if (frameType == 255) {
                localsOffsetHeight = 0;
                this.numberActiveLocals = 0;
                typesOfActiveLocals = new StackMapType[smte.getNumberOfLocals()];
                StackMapType[] numberToChop = smte.getTypesOfLocals();
                int n3 = numberToChop.length;
                for (n = 0; n < n3; ++n) {
                    StackMapType smt = numberToChop[n];
                    typesOfActiveLocals[this.numberActiveLocals++] = smt;
                    localsOffsetHeight += this.getSize(smt);
                }
            }
            if (liveStart == 0) {
                if (offset >= localsOffsetHeight) continue;
                liveStart = byteCodeOffset;
                int runningOffset = 0;
                StackMapType[] stackMapTypeArray = typesOfActiveLocals;
                n = stackMapTypeArray.length;
                for (int i = 0; i < n; ++i) {
                    StackMapType smt = stackMapTypeArray[i];
                    if (runningOffset == offset) {
                        liveType = this.generate_Type_from_StackMapType(smt);
                        break;
                    }
                    runningOffset += this.getSize(smt);
                }
                if (liveType != null) continue;
                liveStart = 0;
                continue;
            }
            if (offset < localsOffsetHeight) continue;
            LocalVariableGen newLvg = mgen.addLocalVariable("DaIkOnTeMp" + offset, liveType, offset, il.findHandle(liveStart), il.findHandle(byteCodeOffset));
            this.debugInstrument.log("Added local  %s, %d, %d : %s, %s%n", newLvg.getIndex(), newLvg.getStart().getPosition(), newLvg.getEnd().getPosition(), newLvg.getName(), newLvg.getType());
            minSize = Math.min(minSize, liveType.getSize());
            liveStart = 0;
            liveType = null;
        }
        if (liveStart != 0) {
            this.liveRangeEnd = this.liveRangeStart = il.findHandle(liveStart);
            this.liveRangeType = liveType;
            this.liveRangeOperandSize = minSize;
            minSize = this.gen_locals_from_byte_codes(mgen, offset, il.findHandle(byteCodeOffset));
        } else if (minSize == 3 && (minSize = this.gen_locals_from_byte_codes(mgen, offset)) == 3) {
            return offset + 1;
        }
        return offset + minSize;
    }

    protected final @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) int gen_locals_from_byte_codes(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) MethodGen mgen, @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) int offset) {
        this.liveRangeStart = null;
        this.liveRangeEnd = null;
        this.liveRangeType = null;
        this.liveRangeOperandSize = 3;
        return this.gen_locals_from_byte_codes(mgen, offset, mgen.getInstructionList().getStart());
    }

    protected final @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) int gen_locals_from_byte_codes(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) MethodGen mgen, @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) int offset, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) InstructionHandle start) {
        this.set_method_stackTypes(mgen);
        InstructionList il = mgen.getInstructionList();
        for (InstructionHandle ih = start; ih != null; ih = ih.getNext()) {
            Type tos;
            OperandStack stack;
            Instruction inst = ih.getInstruction();
            this.debugInstrument.log("gen_locals_from_byte_codes for offset: %d :: position: %d, inst: %s%n", offset, ih.getPosition(), inst);
            if (inst instanceof StoreInstruction) {
                if (offset != ((LocalVariableInstruction)inst).getIndex()) continue;
                stack = this.stackTypes.get(ih.getPosition());
                tos = stack.peek(0);
                if (this.liveRangeStart == null || !tos.equals((Object)Type.NULL) && !tos.equals((Object)this.liveRangeType)) {
                    this.create_local_from_live_range(mgen, offset);
                    this.liveRangeType = tos;
                    this.liveRangeStart = ih.getNext();
                }
                this.liveRangeEnd = ih.getNext();
                continue;
            }
            if (inst instanceof IINC) {
                if (offset != ((IndexedInstruction)inst).getIndex()) continue;
                if (this.liveRangeType == null) {
                    throw new RuntimeException("gen_locals_from_byte_code: no store before IINC");
                }
                if (this.liveRangeType != Type.INT) {
                    throw new RuntimeException("gen_locals_from_byte_code: IINC operand not type int");
                }
                this.liveRangeEnd = ih.getNext();
                continue;
            }
            if (inst instanceof RET) {
                if (offset != ((IndexedInstruction)inst).getIndex()) continue;
                if (this.liveRangeType == null) {
                    throw new RuntimeException("gen_locals_from_byte_code: no store before RET");
                }
                if (this.liveRangeType.getType() != 16) {
                    throw new RuntimeException("gen_locals_from_byte_code: RET operand not type returnAddress");
                }
                this.liveRangeEnd = ih.getNext();
                continue;
            }
            if (!(inst instanceof LoadInstruction) || offset != ((LocalVariableInstruction)inst).getIndex()) continue;
            stack = this.stackTypes.get(ih.getPosition() + inst.getLength());
            tos = stack.peek(0);
            if (this.liveRangeType == null) {
                throw new RuntimeException("gen_locals_from_byte_code: no store before load");
            }
            if (!tos.equals((Object)this.liveRangeType)) {
                // empty if block
            }
            this.liveRangeEnd = ih.getNext();
        }
        if (this.liveRangeEnd == null) {
            this.liveRangeEnd = il.getEnd();
        }
        this.create_local_from_live_range(mgen, offset);
        return this.liveRangeOperandSize;
    }

    protected final void create_local_from_live_range(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) MethodGen mgen, @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) int offset) {
        if (this.liveRangeStart == null) {
            return;
        }
        if (Type.NULL.equals((Object)this.liveRangeType)) {
            this.liveRangeType = Type.OBJECT;
        }
        if (this.liveRangeType.getType() == 16) {
            this.liveRangeType = Type.OBJECT;
        }
        LocalVariableGen newLvg = mgen.addLocalVariable("DaIkOnTeMp" + offset, this.liveRangeType, offset, this.liveRangeStart, this.liveRangeEnd);
        this.debugInstrument.log("Added local  %s, %d, %d : %s, %s%n", newLvg.getIndex(), newLvg.getStart().getPosition(), newLvg.getEnd().getPosition(), newLvg.getName(), newLvg.getType());
        this.liveRangeOperandSize = Math.min(this.liveRangeOperandSize, this.liveRangeType.getSize());
    }

    protected final void set_method_stackTypes(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) MethodGen mgen) {
        if (this.stackTypes == null) {
            mgen.setMaxLocals();
            this.stackTypes = this.bcelCalcStackTypes(mgen);
            if (this.stackTypes == null) {
                Error e = new Error(String.format("bcelCalcStackTypes failure in %s.%s%n", mgen.getClassName(), mgen.getName()));
                e.printStackTrace();
                throw e;
            }
        }
    }

    protected final @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) StackTypes bcelCalcStackTypes(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) MethodGen mg) {
        VerificationResult vr;
        StackVer stackver = new StackVer();
        try {
            vr = stackver.do_stack_ver(mg);
        }
        catch (Throwable t) {
            System.out.printf("Warning: StackVer exception for %s.%s%n", mg.getClassName(), mg.getName());
            System.out.printf("Exception: %s%n", t);
            System.out.printf("Method is NOT instrumented%n", new Object[0]);
            return null;
        }
        if (vr != VerificationResult.VR_OK) {
            System.out.printf("Warning: StackVer failed for %s.%s: %s%n", mg.getClassName(), mg.getName(), vr);
            System.out.printf("Method is NOT instrumented%n", new Object[0]);
            return null;
        }
        return stackver.get_stackTypes();
    }
}

