/*
 * Decompiled with CFR 0.152.
 */
package org.plumelib.bcelutil;

import java.util.Arrays;
import org.apache.bcel.classfile.StackMapEntry;
import org.apache.bcel.classfile.StackMapType;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.IfInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.InstructionTargeter;
import org.apache.bcel.generic.LOOKUPSWITCH;
import org.apache.bcel.generic.LineNumberGen;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.TABLESWITCH;
import org.apache.bcel.verifier.structurals.OperandStack;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.checker.mustcall.qual.MustCall;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.regex.qual.UnknownRegex;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.checker.signedness.qual.Signed;
import org.checkerframework.common.initializedfields.qual.InitializedFields;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;
import org.checkerframework.common.value.qual.UnknownVal;
import org.plumelib.bcelutil.StackMapUtils;
import org.plumelib.bcelutil.StackTypes;

public abstract class InstructionListUtils
extends StackMapUtils {
    protected final void append_inst(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) InstructionList il, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) Instruction inst) {
        if (inst instanceof LOOKUPSWITCH) {
            LOOKUPSWITCH ls = (LOOKUPSWITCH)inst;
            il.append((BranchInstruction)new LOOKUPSWITCH(ls.getMatchs(), ls.getTargets(), ls.getTarget()));
        } else if (inst instanceof TABLESWITCH) {
            TABLESWITCH ts = (TABLESWITCH)inst;
            il.append((BranchInstruction)new TABLESWITCH(ts.getMatchs(), ts.getTargets(), ts.getTarget()));
        } else if (inst instanceof IfInstruction) {
            IfInstruction ifi = (IfInstruction)inst;
            il.append(InstructionFactory.createBranchInstruction((short)inst.getOpcode(), (InstructionHandle)ifi.getTarget()));
        } else {
            il.append(inst);
        }
    }

    protected final void insertAtMethodStart(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) MethodGen mg, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) InstructionList newIl) {
        InstructionList il = mg.getInstructionList();
        if (il == null) {
            return;
        }
        this.insertBeforeHandle(mg, il.getStart(), newIl, false);
    }

    protected final void insertBeforeHandle(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) MethodGen mg, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) InstructionHandle ih, @Nullable @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) InstructionList newIl, @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) boolean redirectBranches) {
        if (newIl == null) {
            return;
        }
        InstructionList il = mg.getInstructionList();
        if (il == null) {
            return;
        }
        boolean atStart = ih.getPrev() == null;
        newIl.setPositions();
        InstructionHandle newEnd = newIl.getEnd();
        int newLength = newEnd.getPosition() + newEnd.getInstruction().getLength();
        this.printIl(ih, "Before insert_inst");
        this.debugInstrument.log("  insert_inst: %d%n%s%n", newIl.getLength(), newIl);
        this.debugInstrument.log("  ih: %s%n", ih);
        InstructionHandle newStart = il.insert(ih, newIl);
        il.setPositions();
        if (redirectBranches) {
            il.redirectBranches(ih, newStart);
        }
        if (ih.hasTargeters()) {
            for (InstructionTargeter it : ih.getTargeters()) {
                if (it instanceof LineNumberGen && redirectBranches) {
                    it.updateTarget(ih, newStart);
                    continue;
                }
                if (it instanceof LocalVariableGen) {
                    LocalVariableGen lvg = (LocalVariableGen)it;
                    if (lvg.getStart() != ih || !atStart) continue;
                    it.updateTarget(ih, newStart);
                    continue;
                }
                if (!(it instanceof CodeExceptionGen) || !redirectBranches) continue;
                CodeExceptionGen exc = (CodeExceptionGen)it;
                if (exc.getStartPC() == ih) {
                    exc.updateTarget(ih, newStart);
                    continue;
                }
                if (exc.getEndPC() == ih) continue;
                if (exc.getHandlerPC() == ih) {
                    exc.setHandlerPC(newStart);
                    continue;
                }
                System.out.printf("Malformed CodeException: %s%n", exc);
            }
        }
        il.setPositions();
        this.updateStackMapOffset(newStart.getPosition() - (redirectBranches ? 0 : 1), newLength);
        this.printIl(newStart, "After updateStackMapOffset");
        this.modifyStackMapsForSwitches(newStart, il);
    }

    private void printIl(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) InstructionHandle start, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) String label) {
        if (this.debugInstrument.enabled()) {
            this.printStackMapTable(label);
            for (InstructionHandle tih = start; tih != null; tih = tih.getNext()) {
                this.debugInstrument.log("inst: %s %n", tih);
                if (!tih.hasTargeters()) continue;
                for (InstructionTargeter it : tih.getTargeters()) {
                    this.debugInstrument.log("targeter: %s %n", it);
                }
            }
        }
    }

    protected final @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) InstructionList build_il(Instruction ... instructions) {
        InstructionList il = new InstructionList();
        for (Instruction inst : instructions) {
            this.append_inst(il, inst);
        }
        return il;
    }

    protected final void delete_instructions(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) MethodGen mg, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) InstructionHandle startIh, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) InstructionHandle endIh) {
        InstructionList il = mg.getInstructionList();
        InstructionHandle newStart = endIh.getNext();
        if (newStart == null) {
            throw new RuntimeException("Cannot delete last instruction.");
        }
        il.setPositions();
        int numDeleted = startIh.getPosition() - newStart.getPosition();
        il.redirectBranches(startIh, newStart);
        if (startIh.hasTargeters()) {
            for (InstructionTargeter it : startIh.getTargeters()) {
                if (it instanceof LineNumberGen) {
                    it.updateTarget(startIh, newStart);
                    continue;
                }
                if (it instanceof LocalVariableGen) {
                    it.updateTarget(startIh, newStart);
                    continue;
                }
                if (it instanceof CodeExceptionGen) {
                    CodeExceptionGen exc = (CodeExceptionGen)it;
                    if (exc.getStartPC() == startIh) {
                        exc.updateTarget(startIh, newStart);
                        continue;
                    }
                    if (exc.getEndPC() == startIh) {
                        exc.updateTarget(startIh, newStart);
                        continue;
                    }
                    if (exc.getHandlerPC() == startIh) {
                        exc.setHandlerPC(newStart);
                        continue;
                    }
                    System.out.printf("Malformed CodeException: %s%n", exc);
                    continue;
                }
                System.out.printf("unexpected target %s%n", it);
            }
        }
        try {
            il.delete(startIh, endIh);
        }
        catch (Exception e) {
            throw new Error("Can't delete instruction list", e);
        }
        il.setPositions();
        this.updateStackMapOffset(newStart.getPosition(), numDeleted);
        this.modifyStackMapsForSwitches(newStart, il);
    }

    protected final @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) StackMapType @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) [] calculateLiveLocalTypes(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) MethodGen mg, @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) int location) {
        int maxLocalIndex = -1;
        Object[] localMapTypes = new StackMapType[mg.getMaxLocals()];
        Arrays.fill(localMapTypes, new StackMapType(0, -1, this.pool.getConstantPool()));
        for (LocalVariableGen lv : mg.getLocalVariables()) {
            if (location < lv.getStart().getPosition() || !lv.getLiveToEnd() && location >= lv.getEnd().getPosition()) continue;
            int i = lv.getIndex();
            localMapTypes[i] = this.generateStackMapTypeFromType(lv.getType());
            maxLocalIndex = Math.max(maxLocalIndex, i);
        }
        return (StackMapType[])Arrays.copyOf(localMapTypes, maxLocalIndex + 1);
    }

    protected final @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) StackMapType @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) [] calculateLiveStackTypes(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) OperandStack stack) {
        int ss = stack.size();
        StackMapType[] stackMapTypes = new StackMapType[ss];
        for (int ii = 0; ii < ss; ++ii) {
            stackMapTypes[ii] = this.generateStackMapTypeFromType(stack.peek(ss - ii - 1));
        }
        return stackMapTypes;
    }

    protected final void replaceInstructions(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) MethodGen mg, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) InstructionList il, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) InstructionHandle ih, @Nullable @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) InstructionList newIl) {
        InstructionHandle newEnd;
        if (newIl == null) {
            return;
        }
        int oldLength = ih.getInstruction().getLength();
        newIl.setPositions();
        InstructionHandle end = newIl.getEnd();
        int newLength = end.getPosition() + end.getInstruction().getLength();
        this.debugInstrument.log("  replace_inst: %s %d%n%s%n", ih, newIl.getLength(), newIl);
        this.printIl(ih, "Before replace_inst");
        if (newIl.getLength() == 1) {
            ih.setInstruction(newIl.getEnd().getInstruction());
            if (oldLength == newLength) {
                return;
            }
            this.printStackMapTable("replace_inst_with_single_inst B");
            il.setPositions();
            newEnd = ih;
            this.updateStackMapOffset(ih.getPosition(), newLength - oldLength);
            this.modifyStackMapsForSwitches(newEnd, il);
        } else {
            this.printStackMapTable("replace_inst_with_inst_list B");
            newEnd = newIl.getEnd();
            InstructionHandle newStart = il.insert(ih, newIl);
            il.setPositions();
            newLength = newEnd.getNext().getPosition() - newStart.getPosition();
            il.redirectBranches(ih, newStart);
            this.printIl(newEnd, "replace_inst #1");
            if (ih.hasTargeters()) {
                for (InstructionTargeter instructionTargeter : ih.getTargeters()) {
                    if (instructionTargeter instanceof LineNumberGen) {
                        instructionTargeter.updateTarget(ih, newStart);
                        continue;
                    }
                    if (instructionTargeter instanceof LocalVariableGen) {
                        instructionTargeter.updateTarget(ih, newEnd);
                        continue;
                    }
                    if (instructionTargeter instanceof CodeExceptionGen) {
                        CodeExceptionGen exc = (CodeExceptionGen)instructionTargeter;
                        if (exc.getStartPC() == ih) {
                            exc.updateTarget(ih, newStart);
                            continue;
                        }
                        if (exc.getEndPC() == ih) {
                            exc.updateTarget(ih, newEnd);
                            continue;
                        }
                        if (exc.getHandlerPC() == ih) {
                            exc.setHandlerPC(newStart);
                            continue;
                        }
                        System.out.printf("Malformed CodeException: %s%n", exc);
                        continue;
                    }
                    System.out.printf("unexpected target %s%n", instructionTargeter);
                }
            }
            this.printIl(newEnd, "replace_inst #2");
            try {
                il.delete(ih);
            }
            catch (Exception e) {
                System.out.printf("Can't delete instruction: %s at %s%n", mg.getClassName(), mg.getName());
                throw new Error("Can't delete instruction", e);
            }
            il.setPositions();
            this.printIl(newEnd, "replace_inst #3");
            if (this.needStackMap) {
                this.updateStackMapOffset(newStart.getPosition(), newLength - oldLength);
                this.modifyStackMapsForSwitches(newEnd, il);
                this.printStackMapTable("replace_inst_with_inst_list C");
                InstructionHandle nih = newStart;
                int targetCount = 0;
                int[] targetOffsets = new int[2];
                newEnd = newEnd.getNext();
                for (nih = nih.getNext(); nih != newEnd; nih = nih.getNext()) {
                    if (!nih.hasTargeters()) continue;
                    for (InstructionTargeter it : nih.getTargeters()) {
                        if (!(it instanceof BranchInstruction)) continue;
                        targetOffsets[targetCount++] = nih.getPosition();
                        this.debugInstrument.log("New branch target: %s %n", nih);
                    }
                }
                this.printIl(newEnd, "replace_inst #4");
                if (targetCount != 0) {
                    OperandStack stack;
                    int n = newStart.getPosition();
                    int origSize = this.stackMapTable.length;
                    StackMapEntry[] newStackMapTable = new StackMapEntry[origSize + targetCount];
                    mg.setMaxStack();
                    StackTypes stackTypes = this.bcelCalcStackTypes(mg);
                    if (stackTypes == null) {
                        Error e = new Error(String.format("bcelCalcStackTypes failure in %s.%s%n", mg.getClassName(), mg.getName()));
                        e.printStackTrace();
                        throw e;
                    }
                    int newIndex = this.findStackMapIndexBefore(targetOffsets[0]) + 1;
                    StackMapType[] localMapTypes = this.calculateLiveLocalTypes(mg, n);
                    int localMapIndex = localMapTypes.length;
                    int numberExtraLocals = localMapIndex - this.numberActiveLocals;
                    assert (numberExtraLocals >= 0) : "invalid extra locals count: " + this.numberActiveLocals + ", " + localMapIndex;
                    System.arraycopy(this.stackMapTable, 0, newStackMapTable, 0, newIndex);
                    boolean needFullMaps = false;
                    for (int i = 0; i < targetCount; ++i) {
                        stack = stackTypes.get(targetOffsets[i]);
                        this.debugInstrument.log("stack: %s %n", stack);
                        if (numberExtraLocals == 0 && stack.size() == 1 && !needFullMaps) {
                            StackMapType stackMapType0 = this.generateStackMapTypeFromType(stack.peek(0));
                            StackMapType[] stackMapTypes0 = new StackMapType[]{stackMapType0};
                            newStackMapTable[newIndex + i] = new StackMapEntry(64, 0, null, stackMapTypes0, this.pool.getConstantPool());
                        } else {
                            needFullMaps = true;
                            newStackMapTable[newIndex + i] = new StackMapEntry(255, 0, this.calculateLiveLocalTypes(mg, targetOffsets[i]), this.calculateLiveStackTypes(stack), this.pool.getConstantPool());
                        }
                        newStackMapTable[newIndex + i].updateByteCodeOffset(targetOffsets[i] - (this.runningOffset + 1));
                        this.runningOffset = targetOffsets[i];
                    }
                    int remainder = origSize - newIndex;
                    if (remainder > 0) {
                        block6: while (nih != null) {
                            if (nih.hasTargeters()) {
                                for (InstructionTargeter it : nih.getTargeters()) {
                                    CodeExceptionGen exc;
                                    if (it instanceof BranchInstruction) {
                                        this.stackMapTable[newIndex].updateByteCodeOffset(nih.getPosition() - targetOffsets[targetCount - 1] - 1 - this.stackMapTable[newIndex].getByteCodeOffset());
                                        break block6;
                                    }
                                    if (!(it instanceof CodeExceptionGen) || (exc = (CodeExceptionGen)it).getHandlerPC() != nih) continue;
                                    this.stackMapTable[newIndex].updateByteCodeOffset(nih.getPosition() - targetOffsets[targetCount - 1] - 1 - this.stackMapTable[newIndex].getByteCodeOffset());
                                    break block6;
                                }
                            }
                            nih = nih.getNext();
                        }
                        if (needFullMaps) {
                            while (remainder > 0) {
                                int stackMapOffset = this.stackMapTable[newIndex].getByteCodeOffset();
                                this.runningOffset = this.runningOffset + stackMapOffset + 1;
                                stack = stackTypes.get(this.runningOffset);
                                newStackMapTable[newIndex + targetCount] = new StackMapEntry(255, stackMapOffset, this.calculateLiveLocalTypes(mg, this.runningOffset), this.calculateLiveStackTypes(stack), this.pool.getConstantPool());
                                ++newIndex;
                                --remainder;
                            }
                        } else {
                            System.arraycopy(this.stackMapTable, newIndex, newStackMapTable, newIndex + targetCount, remainder);
                        }
                    }
                    this.stackMapTable = newStackMapTable;
                }
            }
        }
        this.debugInstrument.log("%n", new Object[0]);
        this.printIl(newEnd, "replace_inst #5");
    }
}

