/*
 * Decompiled with CFR 0.152.
 */
package org.plumelib.bcelutil;

import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.bcel.Const;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.InstructionTargeter;
import org.apache.bcel.generic.LineNumberGen;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.RETURN;
import org.apache.bcel.generic.Type;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import org.checkerframework.checker.formatter.qual.FormatBottom;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.index.qual.SameLen;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.InternedDistinct;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.GuardedByBottom;
import org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.checker.mustcall.qual.MustCall;
import org.checkerframework.checker.mustcall.qual.MustCallUnknown;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.regex.qual.RegexBottom;
import org.checkerframework.checker.regex.qual.UnknownRegex;
import org.checkerframework.checker.signature.qual.BinaryName;
import org.checkerframework.checker.signature.qual.BinaryNameOrPrimitiveType;
import org.checkerframework.checker.signature.qual.ClassGetName;
import org.checkerframework.checker.signature.qual.FqBinaryName;
import org.checkerframework.checker.signature.qual.InternalForm;
import org.checkerframework.checker.signature.qual.SignatureBottom;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.checker.signedness.qual.Signed;
import org.checkerframework.checker.signedness.qual.SignednessBottom;
import org.checkerframework.checker.signedness.qual.UnknownSignedness;
import org.checkerframework.common.initializedfields.qual.InitializedFields;
import org.checkerframework.common.initializedfields.qual.InitializedFieldsBottom;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;
import org.checkerframework.common.value.qual.BottomVal;
import org.checkerframework.common.value.qual.UnknownVal;
import org.plumelib.reflection.ReflectionPlume;
import org.plumelib.reflection.Signatures;

public final class BcelUtil {
    public static @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) boolean skipChecks = false;
    private static final @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) Type stringArray = Type.getType("[Ljava.lang.String;");
    public static final @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) int javaVersion = BcelUtil.getJavaVersion();

    private BcelUtil() {
        throw new Error("do not instantiate");
    }

    private static @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) int getJavaVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            return Integer.parseInt(version.substring(2, 3));
        }
        Pattern newVersionPattern = Pattern.compile("^(\\d+).*$");
        Matcher newVersionMatcher = newVersionPattern.matcher(version);
        if (newVersionMatcher.matches()) {
            String v = newVersionMatcher.group(1);
            assert (v != null) : "@AssumeAssertion(nullness): inspection";
            return Integer.parseInt(v);
        }
        throw new RuntimeException("Could not determine version from property java.version=" + version);
    }

    public static @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) String methodDeclarationToString(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) Method m) {
        StringBuilder sb = new StringBuilder();
        String flags = BcelUtil.accessFlagsToString(m);
        boolean argsExist = false;
        if (flags != null && !flags.isEmpty()) {
            sb.append(String.format("%s ", flags));
        }
        sb.append(String.format("%s %s(", m.getReturnType(), m.getName()));
        for (Type at : m.getArgumentTypes()) {
            sb.append(String.format("%s, ", at));
            argsExist = true;
        }
        if (argsExist) {
            sb.setLength(sb.length() - 2);
        }
        sb.append(")");
        return sb.toString();
    }

    static @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) String accessFlagsToString(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) Method m) {
        int flags = m.getAccessFlags();
        StringBuilder buf = new StringBuilder();
        int pow = 1;
        for (int i = 0; i <= 32768; ++i) {
            if ((flags & pow) != 0) {
                if (buf.length() > 0) {
                    buf.append(" ");
                }
                if (i < Const.ACCESS_NAMES_LENGTH) {
                    buf.append(Const.getAccessName(i));
                } else {
                    buf.append(String.format("ACC_BIT(%x)", pow));
                }
            }
            pow <<= 1;
        }
        return buf.toString();
    }

    public static @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) String instructionListToString(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) InstructionList il, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) ConstantPoolGen pool) {
        StringBuilder out = new StringBuilder();
        for (InstructionHandle handle : il) {
            out.append(handle.getInstruction().toString(pool.getConstantPool()) + "\n");
        }
        return out.toString();
    }

    public static @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) String localVariablesToString(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) MethodGen mg) {
        StringBuilder out = new StringBuilder();
        out.append(String.format("Locals for %s [cnt %d]%n", mg, mg.getMaxLocals()));
        LocalVariableGen[] lvgs = mg.getLocalVariables();
        if (lvgs != null && lvgs.length > 0) {
            for (LocalVariableGen lvg : lvgs) {
                out.append(String.format("  %s [index %d]%n", lvg, lvg.getIndex()));
            }
        }
        return out.toString();
    }

    public static @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) String attributeNameToString(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) Attribute a) {
        ConstantPool pool = a.getConstantPool();
        int conIndex = a.getNameIndex();
        Constant c = pool.getConstant(conIndex);
        String attName = ((ConstantUtf8)c).getBytes();
        return attName;
    }

    public static @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) String attributeNameToString(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) Attribute a, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) ConstantPoolGen pool) {
        int conIndex = a.getNameIndex();
        Constant c = pool.getConstant(conIndex);
        String attName = ((ConstantUtf8)c).getBytes();
        return attName;
    }

    public static @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) boolean isConstructor(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) MethodGen mg) {
        if (mg.getName().equals("")) {
            throw new Error("method name cannot be empty");
        }
        return mg.getName().equals("<init>");
    }

    public static @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) boolean isConstructor(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) Method m) {
        if (m.getName().equals("")) {
            throw new Error("method name cannot be empty");
        }
        return m.getName().equals("<init>");
    }

    public static @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) boolean isClinit(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) MethodGen mg) {
        return mg.getName().equals("<clinit>");
    }

    public static @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) boolean isClinit(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) Method m) {
        return m.getName().equals("<clinit>");
    }

    public static @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) boolean inJdk(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) ClassGen gen) {
        return BcelUtil.inJdk(gen.getClassName());
    }

    public static @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) boolean inJdk(@ClassGetName @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @InitializedFields(value={}) String classname) {
        if (classname.startsWith("java.") || classname.startsWith("com.sun.") || classname.startsWith("javax.") || classname.startsWith("jdk.") || classname.startsWith("org.ietf.") || classname.startsWith("org.jcp.") || classname.startsWith("org.w3c.") || classname.startsWith("org.xml.") || classname.startsWith("sun.")) {
            return true;
        }
        return javaVersion <= 8 ? classname.startsWith("com.oracle.") || classname.startsWith("org.omg.") : classname.startsWith("netscape.javascript.") || classname.startsWith("org.graalvm.");
    }

    public static @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) boolean inJdkInternalform(@InternalForm @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @InitializedFields(value={}) String classname) {
        if (classname.startsWith("java/") || classname.startsWith("com/sun/") || classname.startsWith("javax/") || classname.startsWith("jdk/") || classname.startsWith("org/ietj/") || classname.startsWith("org/jcp/") || classname.startsWith("org/w3c/") || classname.startsWith("org/xml/") || classname.startsWith("sun/")) {
            return true;
        }
        return javaVersion <= 8 ? classname.startsWith("com/oracle/") || classname.startsWith("org/omg/") : classname.startsWith("netscape/javascript/") || classname.startsWith("org/graalvm/");
    }

    public static @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) boolean isLocalVariableTypeTable(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) Attribute a, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) ConstantPoolGen pool) {
        return BcelUtil.attributeNameToString(a, pool).equals("LocalVariableTypeTable");
    }

    public static @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) boolean isMain(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) MethodGen mg) {
        Type[] argTypes = mg.getArgumentTypes();
        return mg.isStatic() && mg.getReturnType() == Type.VOID && mg.getName().equals("main") && argTypes.length == 1 && argTypes[0].equals(stringArray);
    }

    public static void checkMgen(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) MethodGen mgen) {
        if (skipChecks) {
            return;
        }
        try {
            CodeExceptionGen[] exceptionHandlers;
            String ignore = mgen.toString();
            mgen.getLineNumberTable(mgen.getConstantPool());
            InstructionList ilist = mgen.getInstructionList();
            if (ilist == null || ilist.getStart() == null) {
                return;
            }
            for (CodeExceptionGen gen : exceptionHandlers = mgen.getExceptionHandlers()) {
                assert (ilist.contains(gen.getStartPC())) : "exception handler " + gen + " has been forgotten in " + mgen.getClassName() + "." + mgen.getName();
            }
            MethodGen nmg = new MethodGen(mgen.getMethod(), mgen.getClassName(), mgen.getConstantPool());
            nmg.getLineNumberTable(mgen.getConstantPool());
        }
        catch (Throwable t) {
            Error e = new Error(String.format("failure while checking method %s.%s%n", mgen.getClassName(), mgen.getName()), t);
            e.printStackTrace();
            throw e;
        }
    }

    public static void checkMgens(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) ClassGen gen) {
        if (skipChecks) {
            return;
        }
        Method[] methods = gen.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            BcelUtil.checkMgen(new MethodGen(method, gen.getClassName(), gen.getConstantPool()));
        }
    }

    public static void dumpStackTrace() {
        StackTraceElement[] ste = Thread.currentThread().getStackTrace();
        if (ste.length < 3) {
            System.out.println("No stack trace information available");
        } else {
            StackTraceElement caller = ste[2];
            System.out.printf("%s.%s (%s line %d)", caller.getClassName(), caller.getMethodName(), caller.getFileName(), caller.getLineNumber());
            for (int ii = 3; ii < ste.length; ++ii) {
                System.out.printf(" [%s line %d]", ste[ii].getFileName(), ste[ii].getLineNumber());
            }
            System.out.printf("%n", new Object[0]);
        }
    }

    static void dumpMethods(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) ClassGen gen) {
        System.out.printf("Class %s methods:%n", gen.getClassName());
        for (Method m : gen.getMethods()) {
            System.out.printf("  %s%n", m);
        }
    }

    public static void dump(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) JavaClass jc, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) String dumpDir) {
        BcelUtil.dump(jc, new File(dumpDir));
    }

    public static void dump(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) JavaClass jc, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) File dumpDir) {
        dumpDir.mkdir();
        try (PrintStream p = new PrintStream(new File(dumpDir, jc.getClassName() + ".bcel"));){
            p.printf("class %s extends %s%n", jc.getClassName(), jc.getSuperclassName());
            String[] inames = jc.getInterfaceNames();
            boolean first = true;
            if (inames != null && inames.length > 0) {
                p.printf("   implements ", new Object[0]);
                for (String string : inames) {
                    if (!first) {
                        p.printf(", ", new Object[0]);
                    }
                    p.printf("%s", string);
                    first = false;
                }
                p.printf("%n", new Object[0]);
            }
            p.printf("%nFields%n", new Object[0]);
            for (Field field : jc.getFields()) {
                p.printf("  %s%n", field);
            }
            p.printf("%nMethods%n", new Object[0]);
            for (Method method : jc.getMethods()) {
                p.printf("  %s%n", method);
            }
            for (Method method : jc.getMethods()) {
                Code code = method.getCode();
                if (code == null) continue;
                p.printf("%nMethod %s%n", method);
                p.printf("  %s%n", code.toString().replace("\n", "\n  "));
            }
            p.printf("Constant Pool:%n", new Object[0]);
            ConstantPool cp = jc.getConstantPool();
            Constant[] constants = cp.getConstantPool();
            for (int ii = 0; ii < constants.length; ++ii) {
                p.printf("  %d %s%n", ii, constants[ii]);
            }
        }
        catch (Exception e) {
            throw new Error("Unexpected error dumping JavaClass: " + jc.getClassName() + " to " + dumpDir.getName(), e);
        }
    }

    public static void addToStart(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) MethodGen mg, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) InstructionList newList) {
        InstructionList il = mg.getInstructionList();
        InstructionHandle oldStart = il.getStart();
        InstructionHandle newStart = il.insert(newList);
        if (oldStart.hasTargeters()) {
            for (InstructionTargeter it : oldStart.getTargeters()) {
                if (!(it instanceof LineNumberGen) && !(it instanceof LocalVariableGen)) continue;
                it.updateTarget(oldStart, newStart);
            }
        }
        mg.setMaxStack();
        mg.setMaxLocals();
    }

    public static @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) String getConstantString(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) ConstantPool pool, @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) int index) {
        Constant c = pool.getConstant(index);
        assert (c != null) : "Bad index " + index + " into pool";
        if (c instanceof ConstantUtf8) {
            return ((ConstantUtf8)c).getBytes();
        }
        if (c instanceof ConstantClass) {
            ConstantClass cc = (ConstantClass)c;
            return cc.getBytes(pool) + " [" + cc.getNameIndex() + "]";
        }
        throw new Error("unexpected constant " + c + " of class " + c.getClass());
    }

    public static void resetLocalsToFormals(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) MethodGen mg) {
        mg.setMaxLocals(0);
        mg.removeLocalVariables();
        if (!mg.isStatic()) {
            mg.addLocalVariable("this", new ObjectType(mg.getClassName()), null, null);
        }
        Type @SameLen(value={"argTypes", "mg.getArgumentTypes()"}) [] argTypes = mg.getArgumentTypes();
        String @SameLen(value={"argTypes", "argNames", "mg.getArgumentTypes()", "mg.getArgumentNames()"}) [] argNames = mg.getArgumentNames();
        for (int ii = 0; ii < argNames.length; ++ii) {
            mg.addLocalVariable(argNames[ii], argTypes[ii], null, null);
        }
        mg.setMaxLocals();
    }

    public static void makeMethodBodyEmpty(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) MethodGen mg) {
        mg.setInstructionList(new InstructionList(new RETURN()));
        mg.removeExceptionHandlers();
        mg.removeLineNumbers();
        mg.removeLocalVariables();
        mg.setMaxLocals();
    }

    public static void removeLocalVariableTypeTables(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) MethodGen mg) {
        for (Attribute a : mg.getCodeAttributes()) {
            if (!BcelUtil.isLocalVariableTypeTable(a, mg.getConstantPool())) continue;
            mg.removeCodeAttribute(a);
        }
    }

    public static @ClassGetName @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @InitializedFields(value={}) String typeToClassgetname(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) Type type) {
        String signature = type.getSignature();
        return Signatures.fieldDescriptorToClassGetName(signature);
    }

    public static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) Class<@UnknownFormat @FormatBottom @UnknownInterned @InternedDistinct @LockPossiblyHeld @GuardedBy(value={}) @LockPossiblyHeld @GuardedByBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownRegex @RegexBottom @UnknownThis @UnknownThis @MustCallUnknown @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @SignatureUnknown @SignatureBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @InitializedFields(value={}) @InitializedFieldsBottom ?> typeToClass(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) Type type) {
        String classname = BcelUtil.typeToClassgetname(type);
        try {
            return ReflectionPlume.classForName(classname);
        }
        catch (Exception e) {
            throw new RuntimeException("can't find class for " + classname, e);
        }
    }

    public static @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) Type @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) [] postpendToArray(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) Type @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) [] types, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) Type newType) {
        if (types.length == Integer.MAX_VALUE) {
            throw new Error("array " + Arrays.toString(types) + " is too large to extend");
        }
        Type[] newTypes = new Type[types.length + 1];
        System.arraycopy(types, 0, newTypes, 0, types.length);
        newTypes[types.length] = newType;
        return newTypes;
    }

    public static @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) Type @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) [] prependToArray(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) Type newType, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) Type @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) [] types) {
        if (types.length == Integer.MAX_VALUE) {
            throw new Error("array " + Arrays.toString(types) + " is too large to extend");
        }
        Type[] newTypes = new Type[types.length + 1];
        System.arraycopy(types, 0, newTypes, 1, types.length);
        newTypes[0] = newType;
        return newTypes;
    }

    public static @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) Type binaryNameToType(@BinaryNameOrPrimitiveType @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @InitializedFields(value={}) String classname) {
        if ((classname = classname.intern()) == "int") {
            return Type.INT;
        }
        if (classname == "boolean") {
            return Type.BOOLEAN;
        }
        if (classname == "byte") {
            return Type.BYTE;
        }
        if (classname == "char") {
            return Type.CHAR;
        }
        if (classname == "double") {
            return Type.DOUBLE;
        }
        if (classname == "float") {
            return Type.FLOAT;
        }
        if (classname == "long") {
            return Type.LONG;
        }
        if (classname == "short") {
            return Type.SHORT;
        }
        @BinaryName String binaryName = classname;
        return new ObjectType(binaryName);
    }

    public static @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) Type fqBinaryNameToType(@FqBinaryName @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @InitializedFields(value={}) String classname) {
        Signatures.ClassnameAndDimensions cad = Signatures.ClassnameAndDimensions.parseFqBinaryName(classname);
        Type eltType = BcelUtil.binaryNameToType(cad.classname);
        if (cad.dimensions == 0) {
            return eltType;
        }
        return new ArrayType(eltType, cad.dimensions);
    }
}

