/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier.statics;

import org.apache.bcel.classfile.AnnotationDefault;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Annotations;
import org.apache.bcel.classfile.BootstrapMethods;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantInterfaceMethodref;
import org.apache.bcel.classfile.ConstantInvokeDynamic;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantMethodHandle;
import org.apache.bcel.classfile.ConstantMethodType;
import org.apache.bcel.classfile.ConstantMethodref;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.ConstantValue;
import org.apache.bcel.classfile.Deprecated;
import org.apache.bcel.classfile.EmptyVisitor;
import org.apache.bcel.classfile.EnclosingMethod;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.InnerClass;
import org.apache.bcel.classfile.InnerClasses;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LineNumber;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.LocalVariableTypeTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.MethodParameters;
import org.apache.bcel.classfile.NestMembers;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.ParameterAnnotationEntry;
import org.apache.bcel.classfile.ParameterAnnotations;
import org.apache.bcel.classfile.Signature;
import org.apache.bcel.classfile.SourceFile;
import org.apache.bcel.classfile.StackMap;
import org.apache.bcel.classfile.StackMapEntry;
import org.apache.bcel.classfile.Synthetic;
import org.apache.bcel.classfile.Unknown;
import org.apache.bcel.verifier.exc.AssertionViolatedException;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class StringRepresentation
extends EmptyVisitor {
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String tostring;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Node n;

    public StringRepresentation(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Node n) {
        this.n = n;
        n.accept(this);
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        if (this.tostring == null) {
            throw new AssertionViolatedException("Please adapt '" + this.getClass() + "' to deal with objects of class '" + this.n.getClass() + "'.");
        }
        return this.tostring;
    }

    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Node obj) {
        String ret;
        try {
            ret = obj.toString();
        }
        catch (RuntimeException e) {
            String s = obj.getClass().getName();
            s = s.substring(s.lastIndexOf(".") + 1);
            ret = "<<" + s + ">>";
        }
        return ret;
    }

    @Override
    public void visitCode(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Code obj) {
        this.tostring = "<CODE>";
    }

    @Override
    public void visitAnnotation(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Annotations obj) {
        this.tostring = this.toString(obj);
    }

    @Override
    public void visitLocalVariableTypeTable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariableTypeTable obj) {
        this.tostring = this.toString(obj);
    }

    @Override
    public void visitCodeException(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown CodeException obj) {
        this.tostring = this.toString(obj);
    }

    @Override
    public void visitConstantClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantClass obj) {
        this.tostring = this.toString(obj);
    }

    @Override
    public void visitConstantDouble(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantDouble obj) {
        this.tostring = this.toString(obj);
    }

    @Override
    public void visitConstantFieldref(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantFieldref obj) {
        this.tostring = this.toString(obj);
    }

    @Override
    public void visitConstantFloat(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantFloat obj) {
        this.tostring = this.toString(obj);
    }

    @Override
    public void visitConstantInteger(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantInteger obj) {
        this.tostring = this.toString(obj);
    }

    @Override
    public void visitConstantInterfaceMethodref(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantInterfaceMethodref obj) {
        this.tostring = this.toString(obj);
    }

    @Override
    public void visitConstantLong(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantLong obj) {
        this.tostring = this.toString(obj);
    }

    @Override
    public void visitConstantMethodref(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantMethodref obj) {
        this.tostring = this.toString(obj);
    }

    @Override
    public void visitConstantNameAndType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantNameAndType obj) {
        this.tostring = this.toString(obj);
    }

    @Override
    public void visitConstantPool(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool obj) {
        this.tostring = this.toString(obj);
    }

    @Override
    public void visitConstantString(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantString obj) {
        this.tostring = this.toString(obj);
    }

    @Override
    public void visitConstantUtf8(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantUtf8 obj) {
        this.tostring = this.toString(obj);
    }

    @Override
    public void visitConstantValue(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantValue obj) {
        this.tostring = this.toString(obj);
    }

    @Override
    public void visitDeprecated(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Deprecated obj) {
        this.tostring = this.toString(obj);
    }

    @Override
    public void visitExceptionTable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ExceptionTable obj) {
        this.tostring = this.toString(obj);
    }

    @Override
    public void visitField(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Field obj) {
        this.tostring = this.toString(obj);
    }

    @Override
    public void visitInnerClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InnerClass obj) {
        this.tostring = this.toString(obj);
    }

    @Override
    public void visitInnerClasses(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InnerClasses obj) {
        this.tostring = this.toString(obj);
    }

    @Override
    public void visitJavaClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass obj) {
        this.tostring = this.toString(obj);
    }

    @Override
    public void visitLineNumber(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LineNumber obj) {
        this.tostring = this.toString(obj);
    }

    @Override
    public void visitLineNumberTable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LineNumberTable obj) {
        this.tostring = "<LineNumberTable: " + this.toString(obj) + ">";
    }

    @Override
    public void visitLocalVariable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariable obj) {
        this.tostring = this.toString(obj);
    }

    @Override
    public void visitLocalVariableTable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariableTable obj) {
        this.tostring = "<LocalVariableTable: " + this.toString(obj) + ">";
    }

    @Override
    public void visitMethod(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Method obj) {
        this.tostring = this.toString(obj);
    }

    @Override
    public void visitSignature(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Signature obj) {
        this.tostring = this.toString(obj);
    }

    @Override
    public void visitSourceFile(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown SourceFile obj) {
        this.tostring = this.toString(obj);
    }

    @Override
    public void visitStackMap(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown StackMap obj) {
        this.tostring = this.toString(obj);
    }

    @Override
    public void visitSynthetic(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Synthetic obj) {
        this.tostring = this.toString(obj);
    }

    @Override
    public void visitUnknown(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Unknown obj) {
        this.tostring = this.toString(obj);
    }

    @Override
    public void visitEnclosingMethod(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown EnclosingMethod obj) {
        this.tostring = this.toString(obj);
    }

    @Override
    public void visitBootstrapMethods(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BootstrapMethods obj) {
        this.tostring = this.toString(obj);
    }

    @Override
    public void visitMethodParameters(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown MethodParameters obj) {
        this.tostring = this.toString(obj);
    }

    @Override
    public void visitConstantInvokeDynamic(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantInvokeDynamic obj) {
        this.tostring = this.toString(obj);
    }

    @Override
    public void visitStackMapEntry(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown StackMapEntry obj) {
        this.tostring = this.toString(obj);
    }

    @Override
    public void visitParameterAnnotation(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ParameterAnnotations obj) {
        this.tostring = this.toString(obj);
    }

    @Override
    public void visitAnnotationEntry(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown AnnotationEntry obj) {
        this.tostring = this.toString(obj);
    }

    @Override
    public void visitAnnotationDefault(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown AnnotationDefault obj) {
        this.tostring = this.toString(obj);
    }

    @Override
    public void visitConstantMethodType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantMethodType obj) {
        this.tostring = this.toString(obj);
    }

    @Override
    public void visitConstantMethodHandle(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantMethodHandle obj) {
        this.tostring = this.toString(obj);
    }

    @Override
    public void visitParameterAnnotationEntry(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ParameterAnnotationEntry obj) {
        this.tostring = this.toString(obj);
    }

    @Override
    public void visitNestMembers(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown NestMembers obj) {
        this.tostring = this.toString(obj);
    }
}

